/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ThresholdDataEvent;
import weka.gui.beans.ThresholdDataListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class ModelPerformanceChart
extends JPanel
implements ThresholdDataListener,
Visible,
UserRequestAcceptor,
Serializable,
BeanContextChild {
    protected BeanVisual m_visual;
    protected transient PlotData2D m_masterPlot;
    protected transient JFrame m_popupFrame;
    protected boolean m_framePoppedUp = false;
    protected boolean m_design;
    protected transient BeanContext m_beanContext = null;
    private transient VisualizePanel m_visPanel;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);

    public ModelPerformanceChart() {
        this.appearanceFinal();
    }

    public String globalInfo() {
        return "Visualize performance charts (such as ROC).";
    }

    protected void appearanceDesign() {
        this.removeAll();
        this.m_visual = new BeanVisual("ModelPerformanceChart", "weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        if (this.m_visPanel == null) {
            this.m_visPanel = new VisualizePanel();
        }
        this.add((Component)this.m_visPanel, "Center");
    }

    public synchronized void acceptDataSet(ThresholdDataEvent thresholdDataEvent) {
        if (this.m_visPanel == null) {
            this.m_visPanel = new VisualizePanel();
        }
        if (this.m_masterPlot == null) {
            this.m_masterPlot = thresholdDataEvent.getDataSet();
        }
        try {
            if (!this.m_masterPlot.getPlotInstances().relationName().equals(thresholdDataEvent.getDataSet().getPlotInstances().relationName())) {
                this.m_masterPlot = thresholdDataEvent.getDataSet();
                this.m_visPanel.setMasterPlot(this.m_masterPlot);
                this.m_visPanel.validate();
                this.m_visPanel.repaint();
            } else {
                this.m_visPanel.addPlot(thresholdDataEvent.getDataSet());
                this.m_visPanel.validate();
                this.m_visPanel.repaint();
            }
            this.m_visPanel.setXIndex(4);
            this.m_visPanel.setYIndex(5);
        }
        catch (Exception exception) {
            System.err.println("Problem setting up visualization (ModelPerformanceChart)");
            exception.printStackTrace();
        }
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_masterPlot != null) {
            vector.addElement("Show plot");
        }
        return vector.elements();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_bcSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_bcSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.addVetoableChangeListener(string, vetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.removeVetoableChangeListener(string, vetoableChangeListener);
    }

    public void setBeanContext(BeanContext beanContext) {
        this.m_beanContext = beanContext;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            this.appearanceFinal();
        }
    }

    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    public void performRequest(String string) {
        block5: {
            if (string.compareTo("Show plot") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        final JFrame jFrame = new JFrame("Model Performance Chart");
                        jFrame.setSize(800, 600);
                        jFrame.getContentPane().setLayout(new BorderLayout());
                        jFrame.getContentPane().add((Component)this.m_visPanel, "Center");
                        jFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent windowEvent) {
                                jFrame.dispose();
                                ModelPerformanceChart.this.m_framePoppedUp = false;
                            }
                        });
                        jFrame.setVisible(true);
                        this.m_popupFrame = jFrame;
                        break block5;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else {
                throw new IllegalArgumentException(string + " not supported (Model Performance Chart)");
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.err.println("Usage: ModelPerformanceChart <dataset>");
                System.exit(1);
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            Instances instances = new Instances(bufferedReader);
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            ModelPerformanceChart modelPerformanceChart = new ModelPerformanceChart();
            PlotData2D plotData2D = new PlotData2D(instances);
            plotData2D.setPlotName(instances.relationName());
            ThresholdDataEvent thresholdDataEvent = new ThresholdDataEvent(modelPerformanceChart, plotData2D);
            modelPerformanceChart.acceptDataSet(thresholdDataEvent);
            jFrame.getContentPane().add((Component)modelPerformanceChart, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

