/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Customizer;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.UIManager;
import weka.core.Utils;
import weka.gui.HierarchyPropertyParser;
import weka.gui.LogPanel;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanConnection;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class KnowledgeFlow
extends JPanel
implements PropertyChangeListener {
    protected static String PROPERTY_FILE;
    private static Properties BEAN_PROPERTIES;
    private static Vector TOOLBARS;
    FontMetrics m_fontM;
    protected static final int NONE = 0;
    protected static final int MOVING = 1;
    protected static final int CONNECTING = 2;
    protected static final int ADDING = 3;
    private int m_mode = 0;
    private ButtonGroup m_toolBarGroup = new ButtonGroup();
    private Object m_toolBarBean;
    private BeanLayout m_beanLayout = new BeanLayout();
    private JTabbedPane m_toolBars = new JTabbedPane();
    private JToggleButton m_pointerB;
    private JButton m_saveB;
    private JButton m_loadB;
    private JButton m_stopB;
    private JButton m_helpB;
    private BeanInstance m_editElement;
    private EventSetDescriptor m_sourceEventSetDescriptor;
    private int m_oldX;
    private int m_oldY;
    private int m_startX;
    private int m_startY;
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected LogPanel m_logPanel = new LogPanel(null, true);
    protected BeanContextSupport m_bcSupport = new BeanContextSupport();
    private static KnowledgeFlow m_knowledgeFlow;
    private static long m_initialJVMSize;
    static /* synthetic */ Class class$java$lang$String;

    public KnowledgeFlow() {
        JWindow jWindow = new JWindow();
        jWindow.show();
        jWindow.getGraphics().setFont(new Font("Monospaced", 0, 10));
        this.m_fontM = jWindow.getGraphics().getFontMetrics();
        jWindow.hide();
        this.m_bcSupport.setDesignTime(true);
        this.m_beanLayout.setLayout(null);
        this.m_beanLayout.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (KnowledgeFlow.this.m_toolBarBean == null && (mouseEvent.getModifiers() & 0x10) == 16 && KnowledgeFlow.this.m_mode == 0) {
                    BeanInstance beanInstance = BeanInstance.findInstance(mouseEvent.getPoint());
                    JComponent jComponent = null;
                    if (beanInstance != null) {
                        jComponent = (JComponent)beanInstance.getBean();
                    }
                    if (jComponent != null && jComponent instanceof Visible) {
                        KnowledgeFlow.this.m_editElement = beanInstance;
                        KnowledgeFlow.this.m_oldX = mouseEvent.getX();
                        KnowledgeFlow.this.m_oldY = mouseEvent.getY();
                        KnowledgeFlow.this.m_mode = 1;
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (KnowledgeFlow.this.m_editElement != null && KnowledgeFlow.this.m_mode == 1) {
                    KnowledgeFlow.this.m_editElement = null;
                    KnowledgeFlow.this.revalidate();
                    KnowledgeFlow.this.m_beanLayout.repaint();
                    KnowledgeFlow.this.m_mode = 0;
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Serializable serializable;
                BeanInstance beanInstance = BeanInstance.findInstance(mouseEvent.getPoint());
                if (KnowledgeFlow.this.m_mode == 3 || KnowledgeFlow.this.m_mode == 0) {
                    if (beanInstance != null) {
                        serializable = (JComponent)beanInstance.getBean();
                        if ((mouseEvent.getModifiers() & 0x10) != 16 || mouseEvent.isAltDown()) {
                            KnowledgeFlow.this.doPopup(mouseEvent.getPoint(), beanInstance, mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else if ((mouseEvent.getModifiers() & 0x10) != 16 || mouseEvent.isAltDown()) {
                        int n = 10;
                        KnowledgeFlow.this.deleteConnectionPopup(BeanConnection.getClosestConnections(new Point(mouseEvent.getX(), mouseEvent.getY()), n), mouseEvent.getX(), mouseEvent.getY());
                    } else if (KnowledgeFlow.this.m_toolBarBean != null) {
                        KnowledgeFlow.this.addComponent(mouseEvent.getX(), mouseEvent.getY());
                    }
                }
                if (KnowledgeFlow.this.m_mode == 2) {
                    Serializable serializable2;
                    int n;
                    KnowledgeFlow.this.m_beanLayout.repaint();
                    serializable = BeanInstance.getBeanInstances();
                    for (n = 0; n < ((Vector)serializable).size(); ++n) {
                        serializable2 = (JComponent)((BeanInstance)((Vector)serializable).elementAt(n)).getBean();
                        if (!(serializable2 instanceof Visible)) continue;
                        ((Visible)((Object)serializable2)).getVisual().setDisplayConnectors(false);
                    }
                    if (beanInstance != null) {
                        n = 0;
                        if (!(beanInstance.getBean() instanceof BeanCommon)) {
                            n = 1;
                        } else if (((BeanCommon)beanInstance.getBean()).connectionAllowed(KnowledgeFlow.this.m_sourceEventSetDescriptor.getName())) {
                            n = 1;
                        }
                        if (n != 0) {
                            serializable2 = new BeanConnection(KnowledgeFlow.this.m_editElement, beanInstance, KnowledgeFlow.this.m_sourceEventSetDescriptor);
                        }
                        KnowledgeFlow.this.m_beanLayout.repaint();
                    }
                    KnowledgeFlow.this.m_mode = 0;
                    KnowledgeFlow.this.m_editElement = null;
                    KnowledgeFlow.this.m_sourceEventSetDescriptor = null;
                }
            }
        });
        this.m_beanLayout.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (KnowledgeFlow.this.m_editElement != null && KnowledgeFlow.this.m_mode == 1) {
                    ImageIcon imageIcon = ((Visible)KnowledgeFlow.this.m_editElement.getBean()).getVisual().getStaticIcon();
                    int n = imageIcon.getIconWidth() / 2;
                    int n2 = imageIcon.getIconHeight() / 2;
                    KnowledgeFlow.this.m_editElement.setX(KnowledgeFlow.this.m_oldX - n);
                    KnowledgeFlow.this.m_editElement.setY(KnowledgeFlow.this.m_oldY - n2);
                    KnowledgeFlow.this.m_beanLayout.repaint();
                    KnowledgeFlow.this.m_oldX = mouseEvent.getX();
                    KnowledgeFlow.this.m_oldY = mouseEvent.getY();
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (KnowledgeFlow.this.m_mode == 2) {
                    KnowledgeFlow.this.m_beanLayout.repaint();
                    KnowledgeFlow.this.m_oldX = mouseEvent.getX();
                    KnowledgeFlow.this.m_oldY = mouseEvent.getY();
                }
            }
        });
        String string = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        this.m_logPanel.logMessage("Weka Knowledge Flow was written by Mark Hall");
        this.m_logPanel.logMessage("Weka Knowledge Flow");
        this.m_logPanel.logMessage("(c) 2002-2004 Mark Hall");
        this.m_logPanel.logMessage("web: http://www.cs.waikato.ac.nz/~ml/");
        this.m_logPanel.logMessage(string);
        this.m_logPanel.statusMessage("Welcome to the Weka Knowledge Flow");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Knowledge Flow Layout"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JScrollPane jScrollPane = new JScrollPane(this.m_beanLayout);
        jPanel.add((Component)jScrollPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.m_beanLayout.setSize(1024, 768);
        Dimension dimension = this.m_beanLayout.getPreferredSize();
        this.m_beanLayout.setMinimumSize(dimension);
        this.m_beanLayout.setMaximumSize(dimension);
        this.m_beanLayout.setPreferredSize(dimension);
        this.add((Component)this.m_logPanel, "South");
        this.setUpToolBars();
    }

    private Image loadImage(String string) {
        Image image = null;
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        return image;
    }

    private void setUpToolBars() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOrientation(1);
        this.m_saveB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/Save24.gif")));
        this.m_saveB.setToolTipText("Save layout");
        this.m_loadB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/Open24.gif")));
        this.m_stopB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/Stop24.gif")));
        this.m_helpB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/Help24.gif")));
        this.m_stopB.setToolTipText("Stop all execution");
        this.m_loadB.setToolTipText("Load layout");
        this.m_helpB.setToolTipText("Display help");
        Image image = this.loadImage("weka/gui/beans/icons/Pointer.gif");
        this.m_pointerB = new JToggleButton(new ImageIcon(image));
        this.m_pointerB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnowledgeFlow.this.m_toolBarBean = null;
                KnowledgeFlow.this.m_mode = 0;
                KnowledgeFlow.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.m_toolBarGroup.add(this.m_pointerB);
        jToolBar.add(this.m_pointerB);
        jToolBar.add(this.m_saveB);
        jToolBar.add(this.m_loadB);
        jToolBar.add(this.m_stopB);
        Dimension dimension = this.m_saveB.getPreferredSize();
        Dimension dimension2 = this.m_saveB.getMaximumSize();
        jToolBar.setFloatable(false);
        this.m_pointerB.setPreferredSize(dimension);
        this.m_pointerB.setMaximumSize(dimension2);
        jPanel.add((Component)jToolBar, "West");
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setOrientation(1);
        jToolBar2.setFloatable(false);
        jToolBar2.add(this.m_helpB);
        this.m_helpB.setPreferredSize(dimension);
        this.m_helpB.setMaximumSize(dimension);
        jPanel.add((Component)jToolBar2, "East");
        this.m_saveB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnowledgeFlow.this.saveLayout();
            }
        });
        this.m_loadB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnowledgeFlow.this.loadLayout();
            }
        });
        this.m_stopB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Vector vector = BeanInstance.getBeanInstances();
                for (int i = 0; i < vector.size(); ++i) {
                    Object object = ((BeanInstance)vector.elementAt(i)).getBean();
                    if (!(object instanceof BeanCommon)) continue;
                    ((BeanCommon)object).stop();
                }
            }
        });
        this.m_helpB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnowledgeFlow.this.popupHelp();
            }
        });
        boolean bl = false;
        for (int i = 0; i < TOOLBARS.size(); ++i) {
            int n;
            Object object;
            JPanel jPanel2;
            HierarchyPropertyParser hierarchyPropertyParser;
            String string;
            String string2;
            Box box;
            String string3;
            Vector vector;
            block13: {
                vector = (Vector)TOOLBARS.elementAt(i);
                string3 = (String)vector.elementAt(0);
                box = null;
                string2 = (String)vector.elementAt(1);
                string = "";
                hierarchyPropertyParser = null;
                if (string2.compareTo("null") != 0) {
                    jPanel2 = null;
                    bl = true;
                    string = (String)vector.elementAt(2);
                    hierarchyPropertyParser = (HierarchyPropertyParser)vector.elementAt(3);
                    try {
                        Beans.instantiate(null, string2);
                        break block13;
                    }
                    catch (Exception exception) {
                        System.err.println("Failed to instantiate: " + string2);
                        break;
                    }
                }
                bl = false;
            }
            JToolBar jToolBar3 = new JToolBar();
            int n2 = 2;
            if (bl) {
                if (!hierarchyPropertyParser.goTo(string)) {
                    System.err.println("**** Failed to locate root package in tree ");
                    System.exit(1);
                }
                object = hierarchyPropertyParser.childrenValues();
                for (n = 0; n < ((String[])object).length; ++n) {
                    Object object2;
                    hierarchyPropertyParser.goToChild(object[n]);
                    if (hierarchyPropertyParser.isLeafReached()) {
                        if (box == null) {
                            box = Box.createHorizontalBox();
                            box.setBorder(BorderFactory.createTitledBorder(string3));
                        }
                        if ((jPanel2 = this.instantiateToolBarBean(true, string2, (String)(object2 = hierarchyPropertyParser.fullValue()))) != null) {
                            box.add(jPanel2);
                        }
                        hierarchyPropertyParser.goToParent();
                        continue;
                    }
                    object2 = Box.createHorizontalBox();
                    ((JComponent)object2).setBorder(BorderFactory.createTitledBorder(object[n]));
                    this.processPackage((JComponent)object2, string2, hierarchyPropertyParser);
                    jToolBar3.add((Component)object2);
                }
                if (box != null) {
                    jToolBar3.add(box);
                    box = null;
                }
            } else {
                object = Box.createHorizontalBox();
                ((JComponent)object).setBorder(BorderFactory.createTitledBorder(string3));
                for (n = n2; n < vector.size(); ++n) {
                    jPanel2 = null;
                    jPanel2 = this.instantiateToolBarBean(bl, string2 = (String)vector.elementAt(n), "");
                    if (jPanel2 == null) continue;
                    ((Container)object).add(jPanel2);
                }
                jToolBar3.add((Component)object);
            }
            object = new JScrollPane(jToolBar3, 21, 32);
            Dimension dimension3 = jToolBar3.getPreferredSize();
            ((JComponent)object).setMinimumSize(new Dimension((int)dimension3.getWidth(), (int)(dimension3.getHeight() + 15.0)));
            ((JComponent)object).setPreferredSize(new Dimension((int)dimension3.getWidth(), (int)(dimension3.getHeight() + 15.0)));
            this.m_toolBars.addTab(string3, null, (Component)object, string3);
        }
        jPanel.add((Component)this.m_toolBars, "Center");
        this.add((Component)jPanel, "North");
    }

    private void processPackage(JComponent jComponent, String string, HierarchyPropertyParser hierarchyPropertyParser) {
        if (hierarchyPropertyParser.isLeafReached()) {
            String string2 = hierarchyPropertyParser.fullValue();
            JPanel jPanel = this.instantiateToolBarBean(true, string, string2);
            if (jPanel != null) {
                jComponent.add(jPanel);
            }
            hierarchyPropertyParser.goToParent();
            return;
        }
        String[] stringArray = hierarchyPropertyParser.childrenValues();
        for (int i = 0; i < stringArray.length; ++i) {
            hierarchyPropertyParser.goToChild(stringArray[i]);
            this.processPackage(jComponent, string, hierarchyPropertyParser);
        }
        hierarchyPropertyParser.goToParent();
    }

    private JPanel instantiateToolBarBean(boolean bl, String string, String string2) {
        Object object;
        JPanel jPanel;
        Serializable serializable;
        Object object2;
        if (bl) {
            try {
                object2 = Beans.instantiate(null, string);
            }
            catch (Exception exception) {
                System.err.println("Failed to instantiate :" + string + "KnowledgeFlow.instantiateToolBarBean()");
                return null;
            }
            if (object2 instanceof WekaWrapper) {
                serializable = null;
                try {
                    serializable = Class.forName(string2);
                }
                catch (Exception exception) {
                    System.err.println("Can't find class called: " + string2);
                    return null;
                }
                try {
                    jPanel = ((Class)serializable).newInstance();
                    ((WekaWrapper)object2).setWrappedAlgorithm(jPanel);
                }
                catch (Exception exception) {
                    System.err.println("Failed to configure " + string + " with " + string2);
                    return null;
                }
            }
        } else {
            try {
                object2 = Beans.instantiate(null, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Failed to instantiate :" + string + "KnowledgeFlow.setUpToolBars()");
                return null;
            }
        }
        if (object2 instanceof BeanContextChild) {
            this.m_bcSupport.add(object2);
        }
        if (object2 instanceof Visible) {
            ((Visible)object2).getVisual().scale(3);
        }
        jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("Monospaced", 0, 10));
        String string3 = bl ? string2 : string;
        string3 = string3.substring(string3.lastIndexOf(46) + 1, string3.length());
        jLabel.setText(" " + string3 + " ");
        jLabel.setHorizontalAlignment(0);
        jPanel.setLayout(new BorderLayout());
        if (object2 instanceof Visible) {
            object = ((Visible)object2).getVisual();
            serializable = new JToggleButton(((BeanVisual)object).getStaticIcon());
            int n = ((BeanVisual)object).getStaticIcon().getIconWidth();
            int n2 = ((BeanVisual)object).getStaticIcon().getIconHeight();
            JPanel jPanel2 = this.multiLineLabelPanel(string3, n);
            jPanel.add((Component)jPanel2, "South");
        } else {
            serializable = new JToggleButton();
            jPanel.add((Component)jLabel, "South");
        }
        jPanel.add((Component)serializable, "North");
        this.m_toolBarGroup.add((AbstractButton)serializable);
        object = string;
        Object object3 = object2;
        ((AbstractButton)serializable).addActionListener(new ActionListener((String)object, object3){
            private final /* synthetic */ String val$tempName;
            private final /* synthetic */ Object val$tempBN;
            {
                this.val$tempName = string;
                this.val$tempBN = object;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    KnowledgeFlow.this.m_toolBarBean = null;
                    KnowledgeFlow.this.m_toolBarBean = Beans.instantiate(null, this.val$tempName);
                    if (KnowledgeFlow.this.m_toolBarBean instanceof WekaWrapper) {
                        Object object = ((WekaWrapper)this.val$tempBN).getWrappedAlgorithm();
                        ((WekaWrapper)KnowledgeFlow.this.m_toolBarBean).setWrappedAlgorithm(object.getClass().newInstance());
                    }
                    KnowledgeFlow.this.setCursor(Cursor.getPredefinedCursor(1));
                    KnowledgeFlow.this.m_mode = 3;
                }
                catch (Exception exception) {
                    System.err.println("Problem adding bean to data flow layout");
                }
            }
        });
        String string4 = KnowledgeFlow.getGlobalInfo(object2);
        if (string4 != null) {
            int n = string4.indexOf(46);
            if (n != -1) {
                string4 = string4.substring(0, n + 1);
            }
            ((JComponent)serializable).setToolTipText(string4);
        }
        return jPanel;
    }

    private JPanel multiLineLabelPanel(String string, int n) {
        int n2;
        JPanel jPanel = new JPanel();
        Vector<String> vector = new Vector<String>();
        int n3 = this.m_fontM.stringWidth(string);
        if (n3 < n) {
            vector.addElement(string);
        } else {
            n2 = string.length() / 2;
            int n4 = string.length();
            int n5 = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) >= 'a' || Math.abs(n2 - i) >= n4) continue;
                n4 = Math.abs(n2 - i);
                n5 = i;
            }
            if (n5 != -1) {
                String string2 = string.substring(0, n5);
                String string3 = string.substring(n5, string.length());
                if (string2.length() > 1 && string3.length() > 1) {
                    vector.addElement(string2);
                    vector.addElement(string3);
                } else {
                    vector.addElement(string);
                }
            } else {
                vector.addElement(string);
            }
        }
        jPanel.setLayout(new GridLayout(vector.size(), 1));
        for (n2 = 0; n2 < vector.size(); ++n2) {
            JLabel jLabel = new JLabel();
            jLabel.setFont(new Font("Monospaced", 0, 10));
            jLabel.setText(" " + (String)vector.elementAt(n2) + " ");
            jLabel.setHorizontalAlignment(0);
            jPanel.add(jLabel);
        }
        return jPanel;
    }

    private void popupHelp() {
        final JButton jButton = this.m_helpB;
        try {
            String string;
            jButton.setEnabled(false);
            InputStream inputStream = ClassLoader.getSystemResourceAsStream("weka/gui/beans/README_KnowledgeFlow");
            StringBuffer stringBuffer = new StringBuffer();
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            while ((string = lineNumberReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
            lineNumberReader.close();
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            JTextArea jTextArea = new JTextArea(stringBuffer.toString());
            jTextArea.setFont(new Font("Monospaced", 0, 12));
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jFrame.getContentPane().add((Component)jScrollPane, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jButton.setEnabled(true);
                    jFrame.dispose();
                }
            });
            jFrame.setSize(600, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            jButton.setEnabled(true);
        }
    }

    private void doPopup(Point point, final BeanInstance beanInstance, int n, int n2) {
        JMenuItem jMenuItem;
        Class<?> clazz;
        Object object;
        final JComponent jComponent = (JComponent)beanInstance.getBean();
        final int n3 = n;
        final int n4 = n2;
        int n5 = 0;
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.insert(new JLabel("Edit", 0), n5);
        ++n5;
        JMenuItem jMenuItem2 = new JMenuItem("Delete");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanConnection.removeConnections(beanInstance);
                beanInstance.removeBean(KnowledgeFlow.this.m_beanLayout);
                KnowledgeFlow.this.revalidate();
            }
        });
        jPopupMenu.add(jMenuItem2);
        ++n5;
        try {
            object = Introspector.getBeanInfo(jComponent.getClass());
            if (object == null) {
                System.err.println("Error");
            } else {
                EventSetDescriptor[] eventSetDescriptorArray;
                clazz = object.getBeanDescriptor().getCustomizerClass();
                if (clazz != null) {
                    eventSetDescriptorArray = new JMenuItem("Configure...");
                    eventSetDescriptorArray.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            KnowledgeFlow.this.popupCustomizer(clazz, jComponent);
                        }
                    });
                    jPopupMenu.add((JMenuItem)eventSetDescriptorArray);
                    ++n5;
                } else {
                    System.err.println("No customizer class");
                }
                eventSetDescriptorArray = object.getEventSetDescriptors();
                if (eventSetDescriptorArray != null && eventSetDescriptorArray.length > 0) {
                    jPopupMenu.insert(new JLabel("Connections", 0), n5);
                    ++n5;
                }
                for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
                    jMenuItem = new JMenuItem(eventSetDescriptorArray[i].getName());
                    final EventSetDescriptor eventSetDescriptor = eventSetDescriptorArray[i];
                    boolean bl = true;
                    if (jComponent instanceof EventConstraints) {
                        bl = ((EventConstraints)((Object)jComponent)).eventGeneratable(eventSetDescriptor.getName());
                    }
                    if (bl) {
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                KnowledgeFlow.this.connectComponents(eventSetDescriptor, beanInstance, n3, n4);
                            }
                        });
                    } else {
                        jMenuItem.setEnabled(false);
                    }
                    jPopupMenu.add(jMenuItem);
                    ++n5;
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
        if (jComponent instanceof UserRequestAcceptor) {
            object = ((UserRequestAcceptor)((Object)jComponent)).enumerateRequests();
            if (object.hasMoreElements()) {
                jPopupMenu.insert(new JLabel("Actions", 0), n5);
                ++n5;
            }
            while (object.hasMoreElements()) {
                clazz = (String)object.nextElement();
                boolean bl = false;
                if (((String)((Object)clazz)).charAt(0) == '$') {
                    clazz = ((String)((Object)clazz)).substring(1, ((String)((Object)clazz)).length());
                    bl = true;
                }
                Class<?> clazz2 = clazz;
                jMenuItem = new JMenuItem((String)((Object)clazz2));
                jMenuItem.addActionListener(new ActionListener((String)((Object)clazz2)){
                    private final /* synthetic */ String val$tempS2;
                    {
                        this.val$tempS2 = string;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((UserRequestAcceptor)((Object)jComponent)).performRequest(this.val$tempS2);
                    }
                });
                if (bl) {
                    jMenuItem.setEnabled(false);
                }
                jPopupMenu.add(jMenuItem);
                ++n5;
            }
        }
        if (n5 > 0) {
            jPopupMenu.show(this.m_beanLayout, n, n2);
        }
    }

    private void popupCustomizer(Class clazz, JComponent jComponent) {
        try {
            final Object t = clazz.newInstance();
            ((Customizer)t).setObject(jComponent);
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)((JComponent)t), "Center");
            if (t instanceof CustomizerCloseRequester) {
                ((CustomizerCloseRequester)t).setParentFrame(jFrame);
            }
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    if (t instanceof CustomizerClosingListener) {
                        ((CustomizerClosingListener)t).customizerClosing();
                    }
                    jFrame.dispose();
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void deleteConnectionPopup(Vector vector, int n, int n2) {
        if (vector.size() > 0) {
            int n3 = 0;
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.insert(new JLabel("Delete Connection", 0), n3);
            ++n3;
            for (int i = 0; i < vector.size(); ++i) {
                final BeanConnection beanConnection = (BeanConnection)vector.elementAt(i);
                String string = beanConnection.getSourceEventSetDescriptor().getName();
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        beanConnection.remove();
                        KnowledgeFlow.this.m_beanLayout.revalidate();
                        KnowledgeFlow.this.m_beanLayout.repaint();
                    }
                });
                jPopupMenu.add(jMenuItem);
                ++n3;
            }
            jPopupMenu.show(this.m_beanLayout, n, n2);
        }
    }

    private void connectComponents(EventSetDescriptor eventSetDescriptor, BeanInstance beanInstance, int n, int n2) {
        Object object;
        this.m_sourceEventSetDescriptor = eventSetDescriptor;
        Class<?> clazz = eventSetDescriptor.getListenerType();
        JComponent jComponent = (JComponent)beanInstance.getBean();
        int n3 = 0;
        Vector vector = BeanInstance.getBeanInstances();
        for (int i = 0; i < vector.size(); ++i) {
            object = (JComponent)((BeanInstance)vector.elementAt(i)).getBean();
            boolean bl = false;
            if (!clazz.isInstance(object) || object == jComponent) continue;
            if (!(object instanceof BeanCommon)) {
                bl = true;
            } else if (((BeanCommon)object).connectionAllowed(eventSetDescriptor.getName())) {
                bl = true;
            }
            if (!bl || !(object instanceof Visible)) continue;
            ++n3;
            ((Visible)object).getVisual().setDisplayConnectors(true);
        }
        if (n3 > 0) {
            if (jComponent instanceof Visible) {
                ((Visible)((Object)jComponent)).getVisual().setDisplayConnectors(true);
            }
            this.m_editElement = beanInstance;
            Point point = ((Visible)((Object)jComponent)).getVisual().getClosestConnectorPoint(new Point(n, n2));
            this.m_startX = (int)point.getX();
            this.m_startY = (int)point.getY();
            this.m_oldX = this.m_startX;
            this.m_oldY = this.m_startY;
            object = (Graphics2D)this.m_beanLayout.getGraphics();
            ((Graphics)object).setXORMode(Color.white);
            ((Graphics)object).drawLine(this.m_startX, this.m_startY, this.m_startX, this.m_startY);
            ((Graphics)object).dispose();
            this.m_mode = 2;
        }
    }

    private void addComponent(int n, int n2) {
        if (this.m_toolBarBean instanceof BeanContextChild) {
            this.m_bcSupport.add(this.m_toolBarBean);
        }
        BeanInstance beanInstance = new BeanInstance((JComponent)this.m_beanLayout, this.m_toolBarBean, n, n2);
        if (this.m_toolBarBean instanceof Visible) {
            ((Visible)this.m_toolBarBean).getVisual().addPropertyChangeListener(this);
        }
        if (this.m_toolBarBean instanceof BeanCommon) {
            ((BeanCommon)this.m_toolBarBean).setLog(this.m_logPanel);
        }
        this.m_toolBarBean = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.m_beanLayout.repaint();
        this.m_pointerB.setSelected(true);
        this.m_mode = 0;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.revalidate();
        this.m_beanLayout.repaint();
    }

    private void loadLayout() {
        this.m_loadB.setEnabled(false);
        this.m_saveB.setEnabled(false);
        int n = this.m_FileChooser.showOpenDialog(this);
        if (n == 0) {
            try {
                File file = this.m_FileChooser.getSelectedFile();
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                Vector vector = (Vector)objectInputStream.readObject();
                Vector vector2 = (Vector)objectInputStream.readObject();
                objectInputStream.close();
                Color color = this.getBackground();
                this.m_bcSupport = new BeanContextSupport();
                this.m_bcSupport.setDesignTime(true);
                for (int i = 0; i < vector.size(); ++i) {
                    BeanInstance beanInstance = (BeanInstance)vector.elementAt(i);
                    if (beanInstance.getBean() instanceof Visible) {
                        ((Visible)beanInstance.getBean()).getVisual().addPropertyChangeListener(this);
                        ((Visible)beanInstance.getBean()).getVisual().setBackground(color);
                        ((JComponent)beanInstance.getBean()).setBackground(color);
                    }
                    if (beanInstance.getBean() instanceof BeanCommon) {
                        ((BeanCommon)beanInstance.getBean()).setLog(this.m_logPanel);
                    }
                    if (!(beanInstance.getBean() instanceof BeanContextChild)) continue;
                    this.m_bcSupport.add(beanInstance.getBean());
                }
                BeanInstance.setBeanInstances(vector, this.m_beanLayout);
                BeanConnection.setConnections(vector2);
                this.m_beanLayout.revalidate();
                this.m_beanLayout.repaint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.m_loadB.setEnabled(true);
        this.m_saveB.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveLayout() {
        block11: {
            this.m_loadB.setEnabled(false);
            this.m_saveB.setEnabled(false);
            int n = this.m_FileChooser.showSaveDialog(this);
            Color color = this.getBackground();
            if (n == 0) {
                Object object;
                Vector vector = BeanInstance.getBeanInstances();
                for (int i = 0; i < vector.size(); ++i) {
                    object = (BeanInstance)vector.elementAt(i);
                    if (!(((BeanInstance)object).getBean() instanceof Visible)) continue;
                    ((Visible)((BeanInstance)object).getBean()).getVisual().removePropertyChangeListener(this);
                    ((Visible)((BeanInstance)object).getBean()).getVisual().setBackground(Color.white);
                    ((JComponent)((BeanInstance)object).getBean()).setBackground(Color.white);
                }
                try {
                    try {
                        File file = this.m_FileChooser.getSelectedFile();
                        object = new FileOutputStream(file);
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                        objectOutputStream.writeObject(vector);
                        objectOutputStream.writeObject(BeanConnection.getConnections());
                        objectOutputStream.flush();
                        objectOutputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var8_10 = null;
                        for (int i = 0; i < vector.size(); ++i) {
                            BeanInstance beanInstance = (BeanInstance)vector.elementAt(i);
                            if (!(beanInstance.getBean() instanceof Visible)) continue;
                            ((Visible)beanInstance.getBean()).getVisual().addPropertyChangeListener(this);
                            ((Visible)beanInstance.getBean()).getVisual().setBackground(color);
                            ((JComponent)beanInstance.getBean()).setBackground(color);
                        }
                        break block11;
                    }
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    int i = 0;
                    while (true) {
                        if (i >= vector.size()) {
                            throw throwable;
                        }
                        BeanInstance beanInstance = (BeanInstance)vector.elementAt(i);
                        if (beanInstance.getBean() instanceof Visible) {
                            ((Visible)beanInstance.getBean()).getVisual().addPropertyChangeListener(this);
                            ((Visible)beanInstance.getBean()).getVisual().setBackground(color);
                            ((JComponent)beanInstance.getBean()).setBackground(color);
                        }
                        ++i;
                    }
                }
                for (int i = 0; i < vector.size(); ++i) {
                    BeanInstance beanInstance = (BeanInstance)vector.elementAt(i);
                    if (!(beanInstance.getBean() instanceof Visible)) continue;
                    ((Visible)beanInstance.getBean()).getVisual().addPropertyChangeListener(this);
                    ((Visible)beanInstance.getBean()).getVisual().setBackground(color);
                    ((JComponent)beanInstance.getBean()).setBackground(color);
                }
            }
        }
        this.m_saveB.setEnabled(true);
        this.m_loadB.setEnabled(true);
    }

    public static String getGlobalInfo(Object object) {
        String string = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
            for (int i = 0; i < methodDescriptorArray.length; ++i) {
                String string2;
                String string3 = methodDescriptorArray[i].getDisplayName();
                Method method = methodDescriptorArray[i].getMethod();
                if (!string3.equals("globalInfo") || !method.getReturnType().equals(class$java$lang$String == null ? KnowledgeFlow.class$("java.lang.String") : class$java$lang$String)) continue;
                Object[] objectArray = new Object[]{};
                string = string2 = (String)method.invoke(object, objectArray);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            m_knowledgeFlow = new KnowledgeFlow();
            jFrame.getContentPane().add((Component)m_knowledgeFlow, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                17.sleep(4000L);
                                System.gc();
                                if (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() >= m_initialJVMSize + 200000L) continue;
                                jFrame.dispose();
                                m_knowledgeFlow = null;
                                System.gc();
                                Thread[] threadArray = new Thread[Thread.activeCount()];
                                Thread.enumerate(threadArray);
                                for (int i = 0; i < threadArray.length; ++i) {
                                    Thread thread = threadArray[i];
                                    if (thread == null || thread == Thread.currentThread()) continue;
                                    if (thread.getName().startsWith("Thread")) {
                                        thread.stop();
                                        continue;
                                    }
                                    if (!thread.getName().startsWith("AWT-EventQueue")) continue;
                                    thread.stop();
                                }
                                threadArray = null;
                                JOptionPane.showMessageDialog(null, "Not enough memory. Please load a smaller dataset or use larger heap size.", "OutOfMemory", 2);
                                System.err.println("displayed message");
                                System.err.println("Not enough memory. Please load a smaller dataset or use larger heap size.");
                                System.err.println("exiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(5);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        Object object;
        String string2;
        Vector<Object> vector;
        String string3;
        Object object2;
        Object object3;
        Object object4;
        PROPERTY_FILE = "weka/gui/beans/Beans.props";
        TOOLBARS = new Vector();
        try {
            BEAN_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            object4 = BEAN_PROPERTIES.propertyNames();
            if (!object4.hasMoreElements()) {
                throw new Exception("Could not read a configuration file for the bean\npanel. An example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n");
            }
            object3 = BEAN_PROPERTIES.getProperty("weka.gui.beans.KnowledgeFlow.standardToolBars");
            object2 = new StringTokenizer((String)object3, ", ");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string3 = ((StringTokenizer)object2).nextToken().trim();
                vector = new Vector<Object>();
                vector.addElement(string3);
                vector.addElement("null");
                string2 = BEAN_PROPERTIES.getProperty("weka.gui.beans.KnowledgeFlow." + string3);
                object = new StringTokenizer(string2, ", ");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken().trim();
                    vector.addElement(string);
                }
                TOOLBARS.addElement(vector);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "KnowledgeFlow", 0);
        }
        try {
            object4 = Utils.readProperties("weka/gui/GenericObjectEditor.props");
            object3 = ((Properties)object4).propertyNames();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                string3 = BEAN_PROPERTIES.getProperty((String)object2);
                if (string3 == null) continue;
                vector = new Vector();
                string2 = BEAN_PROPERTIES.getProperty((String)object2 + ".alias");
                object = string2 != null ? string2 : ((String)object2).substring(((String)object2).lastIndexOf(46) + 1, ((String)object2).length());
                vector.addElement(object);
                vector.addElement(string3);
                string = ((String)object2).substring(0, ((String)object2).lastIndexOf(46));
                vector.addElement(string);
                String string4 = ((Properties)object4).getProperty((String)object2);
                HierarchyPropertyParser hierarchyPropertyParser = new HierarchyPropertyParser();
                hierarchyPropertyParser.build(string4, ", ");
                vector.addElement(hierarchyPropertyParser);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ", ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken().trim();
                    vector.addElement(string5);
                }
                TOOLBARS.addElement(vector);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the generic objecte editor. An example file is included with the Weka distribution.\nThis file should be named \"GenericObjectEditor.props\" and\nshould be placed either in your user home (which is set\nto \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "KnowledgeFlow", 0);
        }
    }

    protected class BeanLayout
    extends JPanel {
        protected BeanLayout() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            BeanInstance.paintLabels(graphics);
            BeanConnection.paintConnections(graphics);
            if (KnowledgeFlow.this.m_mode == 2) {
                graphics.drawLine(KnowledgeFlow.this.m_startX, KnowledgeFlow.this.m_startY, KnowledgeFlow.this.m_oldX, KnowledgeFlow.this.m_oldY);
            }
        }

        public void doLayout() {
            super.doLayout();
            Vector vector = BeanInstance.getBeanInstances();
            for (int i = 0; i < vector.size(); ++i) {
                BeanInstance beanInstance = (BeanInstance)vector.elementAt(i);
                JComponent jComponent = (JComponent)beanInstance.getBean();
                Dimension dimension = jComponent.getPreferredSize();
                jComponent.setBounds(beanInstance.getX(), beanInstance.getY(), dimension.width, dimension.height);
                jComponent.revalidate();
            }
        }
    }
}

