/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataFormatListener;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.Visible;

public class ClassAssigner
extends JPanel
implements Visible,
DataSourceListener,
TrainingSetListener,
TestSetListener,
DataSource,
TrainingSetProducer,
TestSetProducer,
BeanCommon,
EventConstraints,
Serializable,
InstanceListener {
    private String m_classColumn = "last";
    private Instances m_connectedFormat;
    private Object m_trainingProvider;
    private Object m_testProvider;
    private Object m_dataProvider;
    private Object m_instanceProvider;
    private Vector m_trainingListeners = new Vector();
    private Vector m_testListeners = new Vector();
    private Vector m_dataListeners = new Vector();
    private Vector m_instanceListeners = new Vector();
    private Vector m_dataFormatListeners = new Vector();
    protected transient Logger m_logger = null;
    protected BeanVisual m_visual = new BeanVisual("ClassAssigner", "weka/gui/beans/icons/ClassAssigner.gif", "weka/gui/beans/icons/ClassAssigner_animated.gif");

    public String globalInfo() {
        return "Designate which column is to be considered the class column in incoming data.";
    }

    public ClassAssigner() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    public String classColumnTipText() {
        return "Specify the number of the column that contains the class attribute";
    }

    public Instances getConnectedFormat() {
        return this.m_connectedFormat;
    }

    public void setClassColumn(String string) {
        this.m_classColumn = string;
        if (this.m_connectedFormat != null) {
            this.assignClass(this.m_connectedFormat);
        }
    }

    public String getClassColumn() {
        return this.m_classColumn;
    }

    public void acceptDataSet(DataSetEvent dataSetEvent) {
        Instances instances = dataSetEvent.getDataSet();
        this.assignClass(instances);
        this.notifyDataListeners(dataSetEvent);
        if (dataSetEvent.isStructureOnly()) {
            this.m_connectedFormat = dataSetEvent.getDataSet();
            this.notifyDataFormatListeners();
        }
    }

    public void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        Instances instances = trainingSetEvent.getTrainingSet();
        this.assignClass(instances);
        this.notifyTrainingListeners(trainingSetEvent);
    }

    public void acceptTestSet(TestSetEvent testSetEvent) {
        Instances instances = testSetEvent.getTestSet();
        this.assignClass(instances);
        this.notifyTestListeners(testSetEvent);
    }

    public void acceptInstance(InstanceEvent instanceEvent) {
        if (instanceEvent.getStatus() == 0) {
            this.m_connectedFormat = instanceEvent.getStructure();
            this.assignClass(this.m_connectedFormat);
            this.notifyInstanceListeners(instanceEvent);
            System.err.println("Notifying customizer...");
            this.notifyDataFormatListeners();
        } else {
            this.notifyInstanceListeners(instanceEvent);
        }
    }

    private void assignClass(Instances instances) {
        int n = -1;
        if (this.m_classColumn.toLowerCase().compareTo("last") == 0) {
            instances.setClassIndex(instances.numAttributes() - 1);
        } else if (this.m_classColumn.toLowerCase().compareTo("first") == 0) {
            instances.setClassIndex(0);
        } else {
            n = Integer.parseInt(this.m_classColumn) - 1;
            if (n < 0 || n > instances.numAttributes() - 1) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("Class column outside range of data (ClassAssigner)");
                }
            } else {
                instances.setClassIndex(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestListeners(TestSetEvent testSetEvent) {
        Vector vector;
        ClassAssigner classAssigner = this;
        synchronized (classAssigner) {
            vector = (Vector)this.m_testListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                System.err.println("Notifying test listeners (ClassAssigner)");
                ((TestSetListener)vector.elementAt(i)).acceptTestSet(testSetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingListeners(TrainingSetEvent trainingSetEvent) {
        Vector vector;
        ClassAssigner classAssigner = this;
        synchronized (classAssigner) {
            vector = (Vector)this.m_trainingListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                System.err.println("Notifying training listeners (ClassAssigner)");
                ((TrainingSetListener)vector.elementAt(i)).acceptTrainingSet(trainingSetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataListeners(DataSetEvent dataSetEvent) {
        Vector vector;
        ClassAssigner classAssigner = this;
        synchronized (classAssigner) {
            vector = (Vector)this.m_dataListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                System.err.println("Notifying data listeners (ClassAssigner)");
                ((DataSourceListener)vector.elementAt(i)).acceptDataSet(dataSetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceListeners(InstanceEvent instanceEvent) {
        Vector vector;
        ClassAssigner classAssigner = this;
        synchronized (classAssigner) {
            vector = (Vector)this.m_instanceListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((InstanceListener)vector.elementAt(i)).acceptInstance(instanceEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataFormatListeners() {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.m_dataFormatListeners.clone();
        }
        if (vector.size() > 0) {
            serializable = new DataSetEvent(this, this.m_connectedFormat);
            for (int i = 0; i < vector.size(); ++i) {
                ((DataFormatListener)vector.elementAt(i)).newDataFormat((DataSetEvent)serializable);
            }
        }
    }

    public synchronized void addInstanceListener(InstanceListener instanceListener) {
        this.m_instanceListeners.addElement(instanceListener);
        if (this.m_connectedFormat != null) {
            InstanceEvent instanceEvent = new InstanceEvent(this, this.m_connectedFormat);
            instanceListener.acceptInstance(instanceEvent);
        }
    }

    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
        this.m_instanceListeners.removeElement(instanceListener);
    }

    public synchronized void addDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataListeners.addElement(dataSourceListener);
        if (this.m_connectedFormat != null) {
            DataSetEvent dataSetEvent = new DataSetEvent(this, this.m_connectedFormat);
            dataSourceListener.acceptDataSet(dataSetEvent);
        }
    }

    public synchronized void removeDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataListeners.removeElement(dataSourceListener);
    }

    public synchronized void addTrainingSetListener(TrainingSetListener trainingSetListener) {
        this.m_trainingListeners.addElement(trainingSetListener);
        if (this.m_connectedFormat != null) {
            TrainingSetEvent trainingSetEvent = new TrainingSetEvent(this, this.m_connectedFormat);
            trainingSetListener.acceptTrainingSet(trainingSetEvent);
        }
    }

    public synchronized void removeTrainingSetListener(TrainingSetListener trainingSetListener) {
        this.m_trainingListeners.removeElement(trainingSetListener);
    }

    public synchronized void addTestSetListener(TestSetListener testSetListener) {
        this.m_testListeners.addElement(testSetListener);
        if (this.m_connectedFormat != null) {
            TestSetEvent testSetEvent = new TestSetEvent(this, this.m_connectedFormat);
            testSetListener.acceptTestSet(testSetEvent);
        }
    }

    public synchronized void removeTestSetListener(TestSetListener testSetListener) {
        this.m_testListeners.removeElement(testSetListener);
    }

    public synchronized void addDataFormatListener(DataFormatListener dataFormatListener) {
        this.m_dataFormatListeners.addElement(dataFormatListener);
    }

    public synchronized void removeDataFormatListener(DataFormatListener dataFormatListener) {
        this.m_dataFormatListeners.removeElement(dataFormatListener);
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClassAssigner.gif", "weka/gui/beans/icons/ClassAssigner_animated.gif");
    }

    public boolean connectionAllowed(String string) {
        if (string.compareTo("trainingSet") == 0 && (this.m_trainingProvider != null || this.m_dataProvider != null || this.m_instanceProvider != null)) {
            return false;
        }
        if (string.compareTo("testSet") == 0 && this.m_testProvider != null) {
            return false;
        }
        return (string.compareTo("instance") != 0 || this.m_instanceProvider == null) && this.m_trainingProvider == null && this.m_dataProvider == null;
    }

    public synchronized void connectionNotification(String string, Object object) {
        if (this.connectionAllowed(string)) {
            if (string.compareTo("trainingSet") == 0) {
                this.m_trainingProvider = object;
            } else if (string.compareTo("testSet") == 0) {
                this.m_testProvider = object;
            } else if (string.compareTo("dataSet") == 0) {
                this.m_dataProvider = object;
            } else if (string.compareTo("instance") == 0) {
                this.m_instanceProvider = object;
            }
        }
    }

    public synchronized void disconnectionNotification(String string, Object object) {
        if (string.compareTo("trainingSet") == 0 && this.m_trainingProvider == object) {
            this.m_trainingProvider = null;
        }
        if (string.compareTo("testSet") == 0 && this.m_testProvider == object) {
            this.m_testProvider = null;
        }
        if (string.compareTo("dataSet") == 0 && this.m_dataProvider == object) {
            this.m_dataProvider = null;
        }
        if (string.compareTo("instance") == 0 && this.m_instanceProvider == object) {
            this.m_instanceProvider = null;
        }
    }

    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    public void stop() {
    }

    public boolean eventGeneratable(String string) {
        if (string.compareTo("trainingSet") == 0) {
            if (this.m_trainingProvider == null) {
                return false;
            }
            if (this.m_trainingProvider instanceof EventConstraints && !((EventConstraints)this.m_trainingProvider).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (string.compareTo("dataSet") == 0) {
            if (this.m_dataProvider == null) {
                if (this.m_instanceProvider == null) {
                    this.m_connectedFormat = null;
                    this.notifyDataFormatListeners();
                }
                return false;
            }
            if (this.m_dataProvider instanceof EventConstraints && !((EventConstraints)this.m_dataProvider).eventGeneratable("dataSet")) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
        }
        if (string.compareTo("instance") == 0) {
            if (this.m_instanceProvider == null) {
                if (this.m_dataProvider == null) {
                    this.m_connectedFormat = null;
                    this.notifyDataFormatListeners();
                }
                return false;
            }
            if (this.m_instanceProvider instanceof EventConstraints && !((EventConstraints)this.m_instanceProvider).eventGeneratable("instance")) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
        }
        if (string.compareTo("testSet") == 0) {
            if (this.m_testProvider == null) {
                return false;
            }
            if (this.m_testProvider instanceof EventConstraints && !((EventConstraints)this.m_testProvider).eventGeneratable("testSet")) {
                return false;
            }
        }
        return true;
    }
}

