/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.experiment.SplitEvaluator;

public class ClassifierSplitEvaluator
implements SplitEvaluator,
OptionHandler,
AdditionalMeasureProducer {
    protected Classifier m_Classifier = new ZeroR();
    protected String[] m_AdditionalMeasures = null;
    protected boolean[] m_doesProduce = null;
    protected int m_numberAdditionalMeasures = 0;
    protected String m_result = null;
    protected String m_ClassifierOptions = "";
    protected String m_ClassifierVersion = "";
    private static final int KEY_SIZE = 3;
    private static final int RESULT_SIZE = 25;
    private static final int NUM_IR_STATISTICS = 11;
    private int m_IRclass = 0;
    private boolean m_predTargetColumn = false;
    private int m_attID = -1;

    public ClassifierSplitEvaluator() {
        this.updateOptions();
    }

    public String globalInfo() {
        return " A SplitEvaluator that produces results for a classification scheme on a nominal class attribute.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tThe full class name of the classifier.\n\teg: weka.classifiers.bayes.NaiveBayes", "W", 1, "-W <class name>"));
        vector.addElement(new Option("\tThe index of the class for which IR statistics\n\tare to be output. (default 1)", "C", 1, "-C <index>"));
        vector.addElement(new Option("\tThe index of an attribute to output in the\n\tresults. This attribute should identify an\n\tinstance in order to know which instances are\n\tin the test set of a cross validation. if 0\n\tno output (default 0).", "I", 1, "-I <index>"));
        vector.addElement(new Option("\tAdd target and prediction columns to the result\n\tfor each fold.", "P", 0, "-P"));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Classifier.getClass().getName() + ":"));
            Enumeration enumeration = this.m_Classifier.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('W', stringArray);
        if (string2.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        this.setClassifier(Classifier.forName(string2, null));
        if (this.getClassifier() instanceof OptionHandler) {
            this.getClassifier().setOptions(Utils.partitionOptions(stringArray));
            this.updateOptions();
        }
        this.m_IRclass = (string = Utils.getOption('C', stringArray)).length() != 0 ? new Integer(string) - 1 : 0;
        String string3 = Utils.getOption('I', stringArray);
        this.m_attID = string3.length() != 0 ? new Integer(string3) - 1 : -1;
        this.m_predTargetColumn = Utils.getFlag('P', stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            stringArray = this.m_Classifier.getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 8];
        int n = 0;
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        stringArray2[n++] = "-I";
        stringArray2[n++] = "" + (this.m_attID + 1);
        if (this.getPredTargetColumn()) {
            stringArray2[n++] = "-P";
        }
        stringArray2[n++] = "-C";
        stringArray2[n++] = "" + (this.m_IRclass + 1);
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void setAdditionalMeasures(String[] stringArray) {
        this.m_AdditionalMeasures = stringArray;
        if (this.m_AdditionalMeasures != null && this.m_AdditionalMeasures.length > 0) {
            this.m_doesProduce = new boolean[this.m_AdditionalMeasures.length];
            if (this.m_Classifier instanceof AdditionalMeasureProducer) {
                Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).enumerateMeasures();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    for (int i = 0; i < this.m_AdditionalMeasures.length; ++i) {
                        if (string.compareToIgnoreCase(this.m_AdditionalMeasures[i]) != 0) continue;
                        this.m_doesProduce[i] = true;
                    }
                }
            }
        } else {
            this.m_doesProduce = null;
        }
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(string);
        }
        throw new IllegalArgumentException("ClassifierSplitEvaluator: Can't return value for : " + string + ". " + this.m_Classifier.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    public Object[] getKeyTypes() {
        Object[] objectArray = new Object[]{"", "", ""};
        return objectArray;
    }

    public String[] getKeyNames() {
        String[] stringArray = new String[]{"Scheme", "Scheme_options", "Scheme_version_ID"};
        return stringArray;
    }

    public Object[] getKey() {
        Object[] objectArray = new Object[]{this.m_Classifier.getClass().getName(), this.m_ClassifierOptions, this.m_ClassifierVersion};
        return objectArray;
    }

    public Object[] getResultTypes() {
        int n = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        int n2 = 25 + n;
        n2 += 11;
        if (this.getAttributeID() >= 0) {
            ++n2;
        }
        if (this.getPredTargetColumn()) {
            n2 += 2;
        }
        Object[] objectArray = new Object[n2];
        Double d = new Double(0.0);
        int n3 = 0;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        if (this.getAttributeID() >= 0) {
            objectArray[n3++] = "";
        }
        if (this.getPredTargetColumn()) {
            objectArray[n3++] = "";
            objectArray[n3++] = "";
        }
        objectArray[n3++] = "";
        for (int i = 0; i < n; ++i) {
            objectArray[n3++] = d;
        }
        if (n3 != n2) {
            throw new Error("ResultTypes didn't fit RESULT_SIZE");
        }
        return objectArray;
    }

    public String[] getResultNames() {
        int n = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        int n2 = 25 + n;
        n2 += 11;
        if (this.getAttributeID() >= 0) {
            ++n2;
        }
        if (this.getPredTargetColumn()) {
            n2 += 2;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        stringArray[n3++] = "Number_of_training_instances";
        stringArray[n3++] = "Number_of_testing_instances";
        stringArray[n3++] = "Number_correct";
        stringArray[n3++] = "Number_incorrect";
        stringArray[n3++] = "Number_unclassified";
        stringArray[n3++] = "Percent_correct";
        stringArray[n3++] = "Percent_incorrect";
        stringArray[n3++] = "Percent_unclassified";
        stringArray[n3++] = "Kappa_statistic";
        stringArray[n3++] = "Mean_absolute_error";
        stringArray[n3++] = "Root_mean_squared_error";
        stringArray[n3++] = "Relative_absolute_error";
        stringArray[n3++] = "Root_relative_squared_error";
        stringArray[n3++] = "SF_prior_entropy";
        stringArray[n3++] = "SF_scheme_entropy";
        stringArray[n3++] = "SF_entropy_gain";
        stringArray[n3++] = "SF_mean_prior_entropy";
        stringArray[n3++] = "SF_mean_scheme_entropy";
        stringArray[n3++] = "SF_mean_entropy_gain";
        stringArray[n3++] = "KB_information";
        stringArray[n3++] = "KB_mean_information";
        stringArray[n3++] = "KB_relative_information";
        stringArray[n3++] = "True_positive_rate";
        stringArray[n3++] = "Num_true_positives";
        stringArray[n3++] = "False_positive_rate";
        stringArray[n3++] = "Num_false_positives";
        stringArray[n3++] = "True_negative_rate";
        stringArray[n3++] = "Num_true_negatives";
        stringArray[n3++] = "False_negative_rate";
        stringArray[n3++] = "Num_false_negatives";
        stringArray[n3++] = "IR_precision";
        stringArray[n3++] = "IR_recall";
        stringArray[n3++] = "F_measure";
        stringArray[n3++] = "Time_training";
        stringArray[n3++] = "Time_testing";
        if (this.getAttributeID() >= 0) {
            stringArray[n3++] = "Instance_ID";
        }
        if (this.getPredTargetColumn()) {
            stringArray[n3++] = "Targets";
            stringArray[n3++] = "Predictions";
        }
        stringArray[n3++] = "Summary";
        for (int i = 0; i < n; ++i) {
            stringArray[n3++] = this.m_AdditionalMeasures[i];
        }
        if (n3 != n2) {
            throw new Error("ResultNames didn't fit RESULT_SIZE");
        }
        return stringArray;
    }

    public Object[] getResult(Instances instances, Instances instances2) throws Exception {
        int n;
        String string;
        if (instances.classAttribute().type() != 1) {
            throw new Exception("Class attribute is not nominal!");
        }
        if (this.m_Classifier == null) {
            throw new Exception("No classifier has been specified");
        }
        int n2 = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        int n3 = 25 + n2;
        n3 += 11;
        if (this.getAttributeID() >= 0) {
            ++n3;
        }
        if (this.getPredTargetColumn()) {
            n3 += 2;
        }
        Object[] objectArray = new Object[n3];
        Evaluation evaluation = new Evaluation(instances);
        long l = System.currentTimeMillis();
        this.m_Classifier.buildClassifier(instances);
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        double[] dArray = evaluation.evaluateModel(this.m_Classifier, instances2);
        long l4 = System.currentTimeMillis() - l3;
        this.m_result = evaluation.toSummaryString();
        int n4 = 0;
        objectArray[n4++] = new Double(instances.numInstances());
        objectArray[n4++] = new Double(evaluation.numInstances());
        objectArray[n4++] = new Double(evaluation.correct());
        objectArray[n4++] = new Double(evaluation.incorrect());
        objectArray[n4++] = new Double(evaluation.unclassified());
        objectArray[n4++] = new Double(evaluation.pctCorrect());
        objectArray[n4++] = new Double(evaluation.pctIncorrect());
        objectArray[n4++] = new Double(evaluation.pctUnclassified());
        objectArray[n4++] = new Double(evaluation.kappa());
        objectArray[n4++] = new Double(evaluation.meanAbsoluteError());
        objectArray[n4++] = new Double(evaluation.rootMeanSquaredError());
        objectArray[n4++] = new Double(evaluation.relativeAbsoluteError());
        objectArray[n4++] = new Double(evaluation.rootRelativeSquaredError());
        objectArray[n4++] = new Double(evaluation.SFPriorEntropy());
        objectArray[n4++] = new Double(evaluation.SFSchemeEntropy());
        objectArray[n4++] = new Double(evaluation.SFEntropyGain());
        objectArray[n4++] = new Double(evaluation.SFMeanPriorEntropy());
        objectArray[n4++] = new Double(evaluation.SFMeanSchemeEntropy());
        objectArray[n4++] = new Double(evaluation.SFMeanEntropyGain());
        objectArray[n4++] = new Double(evaluation.KBInformation());
        objectArray[n4++] = new Double(evaluation.KBMeanInformation());
        objectArray[n4++] = new Double(evaluation.KBRelativeInformation());
        objectArray[n4++] = new Double(evaluation.truePositiveRate(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.numTruePositives(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.falsePositiveRate(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.numFalsePositives(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.trueNegativeRate(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.numTrueNegatives(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.falseNegativeRate(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.numFalseNegatives(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.precision(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.recall(this.m_IRclass));
        objectArray[n4++] = new Double(evaluation.fMeasure(this.m_IRclass));
        objectArray[n4++] = new Double((double)l2 / 1000.0);
        objectArray[n4++] = new Double((double)l4 / 1000.0);
        if (this.getAttributeID() >= 0) {
            string = "";
            if (instances2.attribute(this.m_attID).isNumeric()) {
                if (instances2.numInstances() > 0) {
                    string = string + instances2.instance(0).value(this.m_attID);
                }
                for (n = 1; n < instances2.numInstances(); ++n) {
                    string = string + "|" + instances2.instance(n).value(this.m_attID);
                }
            } else {
                if (instances2.numInstances() > 0) {
                    string = string + instances2.instance(0).stringValue(this.m_attID);
                }
                for (n = 1; n < instances2.numInstances(); ++n) {
                    string = string + "|" + instances2.instance(n).stringValue(this.m_attID);
                }
            }
            objectArray[n4++] = string;
        }
        if (this.getPredTargetColumn()) {
            if (instances2.classAttribute().isNumeric()) {
                if (instances2.numInstances() > 0) {
                    string = "";
                    string = string + instances2.instance(0).value(instances2.classIndex());
                    for (n = 1; n < instances2.numInstances(); ++n) {
                        string = string + "|" + instances2.instance(n).value(instances2.classIndex());
                    }
                    objectArray[n4++] = string;
                }
                if (dArray.length > 0) {
                    string = "";
                    string = string + dArray[0];
                    for (n = 1; n < dArray.length; ++n) {
                        string = string + "|" + dArray[n];
                    }
                    objectArray[n4++] = string;
                }
            } else {
                if (instances2.numInstances() > 0) {
                    string = "";
                    string = string + instances2.instance(0).stringValue(instances2.classIndex());
                    for (n = 1; n < instances2.numInstances(); ++n) {
                        string = string + "|" + instances2.instance(n).stringValue(instances2.classIndex());
                    }
                    objectArray[n4++] = string;
                }
                if (dArray.length > 0) {
                    string = "";
                    string = string + instances2.classAttribute().value((int)dArray[0]);
                    for (n = 1; n < dArray.length; ++n) {
                        string = string + "|" + instances2.classAttribute().value((int)dArray[n]);
                    }
                    objectArray[n4++] = string;
                }
            }
        }
        objectArray[n4++] = this.m_Classifier instanceof Summarizable ? ((Summarizable)((Object)this.m_Classifier)).toSummaryString() : null;
        for (int i = 0; i < n2; ++i) {
            if (this.m_doesProduce[i]) {
                try {
                    double d = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                    Double d2 = new Double(d);
                    objectArray[n4++] = d2;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
                continue;
            }
            objectArray[n4++] = null;
        }
        if (n4 != n3) {
            throw new Error("Results didn't fit RESULT_SIZE");
        }
        return objectArray;
    }

    public String classifierTipText() {
        return "The classifier to use.";
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
        this.updateOptions();
    }

    public int getClassForIRStatistics() {
        return this.m_IRclass;
    }

    public void setClassForIRStatistics(int n) {
        this.m_IRclass = n;
    }

    public int getAttributeID() {
        return this.m_attID;
    }

    public void setAttributeID(int n) {
        this.m_attID = n;
    }

    public boolean getPredTargetColumn() {
        return this.m_predTargetColumn;
    }

    public void setPredTargetColumn(boolean bl) {
        this.m_predTargetColumn = bl;
    }

    protected void updateOptions() {
        this.m_ClassifierOptions = this.m_Classifier instanceof OptionHandler ? Utils.joinOptions(this.m_Classifier.getOptions()) : "";
        if (this.m_Classifier instanceof Serializable) {
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(this.m_Classifier.getClass());
            this.m_ClassifierVersion = "" + objectStreamClass.getSerialVersionUID();
        } else {
            this.m_ClassifierVersion = "";
        }
    }

    public void setClassifierName(String string) throws Exception {
        try {
            this.setClassifier((Classifier)Class.forName(string).newInstance());
        }
        catch (Exception exception) {
            throw new Exception("Can't find Classifier with class name: " + string);
        }
    }

    public String getRawResultOutput() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Classifier == null) {
            return "<null> classifier";
        }
        stringBuffer.append(this.toString());
        stringBuffer.append("Classifier model: \n" + this.m_Classifier.toString() + '\n');
        if (this.m_result != null) {
            stringBuffer.append(this.m_result);
            if (this.m_doesProduce != null) {
                for (int i = 0; i < this.m_doesProduce.length; ++i) {
                    if (!this.m_doesProduce[i]) continue;
                    try {
                        double d = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                        Double d2 = new Double(d);
                        stringBuffer.append(this.m_AdditionalMeasures[i] + " : " + d2 + '\n');
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "ClassifierSplitEvaluator: ";
        if (this.m_Classifier == null) {
            return string + "<null> classifier";
        }
        return string + this.m_Classifier.getClass().getName() + " " + this.m_ClassifierOptions + "(version " + this.m_ClassifierVersion + ")";
    }
}

