/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.NormalizedPolyKernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.functions.supportVector.SMOset;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.Tag;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class SMO
extends Classifier
implements WeightedInstancesHandler {
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    private BinarySMO[][] m_classifiers = null;
    private double m_exponent = 1.0;
    private boolean m_lowerOrder = false;
    private double m_gamma = 0.01;
    private double m_C = 1.0;
    private double m_eps = 1.0E-12;
    private double m_tol = 0.001;
    private int m_filterType = 0;
    private boolean m_featureSpaceNormalization = false;
    private boolean m_useRBF = false;
    private int m_cacheSize = 1000003;
    private NominalToBinary m_NominalToBinary;
    private Filter m_Filter = null;
    private ReplaceMissingValues m_Missing;
    private boolean m_onlyNumeric;
    private int m_classIndex = -1;
    private Attribute m_classAttribute;
    private boolean m_checksTurnedOff;
    private static double m_Del = 4.94E-321;
    private boolean m_fitLogisticModels = false;
    private int m_numFolds = -1;
    private int m_randomSeed = 1;

    public String globalInfo() {
        return "Implements John Platt's sequential minimal optimization algorithm for training a support vector classifier.\n\nThis implementation globally replaces all missing values and transforms nominal attributes into binary ones. It also normalizes all attributes by default. (In that case the coefficients in the output are based on the normalized data, not the original data --- this is important for interpreting the classifier.)\n\nMulti-class problems are solved using pairwise classification.\n\nTo obtain proper probability estimates, use the option that fits logistic regression models to the outputs of the support vector machine. In the multi-class case the predicted probabilities are coupled using Hastie and Tibshirani's pairwise coupling method.\n\nNote: for improved speed normalization should be turned off when operating on SparseInstances.\n\nFor more information on the SMO algorithm, see\n\nJ. Platt (1998). \"Fast Training of Support Vector Machines using Sequential Minimal Optimization\". Advances in Kernel Methods - Support Vector Learning, B. Sch\ufffdlkopf, C. Burges, and A. Smola, eds., MIT Press. \n\nS.S. Keerthi, S.K. Shevade, C. Bhattacharyya, K.R.K. Murthy,  \"Improvements to Platt's SMO Algorithm for SVM Classifier Design\".  Neural Computation, 13(3), pp 637-649, 2001.";
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        Instances[] instancesArray;
        if (!this.m_checksTurnedOff) {
            if (instances.checkForStringAttributes()) {
                throw new UnsupportedAttributeTypeException("Cannot handle string attributes!");
            }
            if (instances.classAttribute().isNumeric()) {
                throw new UnsupportedClassTypeException("SMO can't handle a numeric class! UseSMOreg for performing regression.");
            }
            instances = new Instances(instances);
            instances.deleteWithMissingClass();
            if (instances.numInstances() == 0) {
                throw new Exception("No training instances without a missing class!");
            }
            instancesArray = new Instances(instances, instances.numInstances());
            for (n = 0; n < instances.numInstances(); ++n) {
                if (!(instances.instance(n).weight() > 0.0)) continue;
                instancesArray.add(instances.instance(n));
            }
            if (instancesArray.numInstances() == 0) {
                throw new Exception("No training instances left after removing instance with either a weight null or a missing class!");
            }
            instances = instancesArray;
        }
        this.m_onlyNumeric = true;
        if (!this.m_checksTurnedOff) {
            for (int i = 0; i < instances.numAttributes(); ++i) {
                if (i == instances.classIndex() || instances.attribute(i).isNumeric()) continue;
                this.m_onlyNumeric = false;
                break;
            }
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary = new NominalToBinary();
            this.m_NominalToBinary.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_NominalToBinary);
        } else {
            this.m_NominalToBinary = null;
        }
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_classIndex = instances.classIndex();
        this.m_classAttribute = instances.classAttribute();
        instancesArray = new Instances[instances.numClasses()];
        for (n = 0; n < instances.numClasses(); ++n) {
            instancesArray[n] = new Instances(instances, instances.numInstances());
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            Instance instance = instances.instance(n);
            instancesArray[(int)instance.classValue()].add(instance);
        }
        for (n = 0; n < instances.numClasses(); ++n) {
            instancesArray[n].compactify();
        }
        Random random = new Random(this.m_randomSeed);
        this.m_classifiers = new BinarySMO[instances.numClasses()][instances.numClasses()];
        for (int i = 0; i < instances.numClasses(); ++i) {
            for (int j = i + 1; j < instances.numClasses(); ++j) {
                int n2;
                this.m_classifiers[i][j] = new BinarySMO();
                Instances instances2 = new Instances(instances, instances.numInstances());
                for (n2 = 0; n2 < instancesArray[i].numInstances(); ++n2) {
                    instances2.add(instancesArray[i].instance(n2));
                }
                for (n2 = 0; n2 < instancesArray[j].numInstances(); ++n2) {
                    instances2.add(instancesArray[j].instance(n2));
                }
                instances2.compactify();
                instances2.randomize(random);
                this.m_classifiers[i][j].buildClassifier(instances2, i, j, this.m_fitLogisticModels, this.m_numFolds, this.m_randomSeed);
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        if (!this.m_fitLogisticModels) {
            double[] dArray = new double[instance.numClasses()];
            for (int i = 0; i < instance.numClasses(); ++i) {
                for (int j = i + 1; j < instance.numClasses(); ++j) {
                    if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                    double d = this.m_classifiers[i][j].SVMOutput(-1, instance);
                    if (d > 0.0) {
                        int n = j;
                        dArray[n] = dArray[n] + 1.0;
                        continue;
                    }
                    int n = i;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            Utils.normalize(dArray);
            return dArray;
        }
        if (instance.numClasses() == 2) {
            double[] dArray = new double[]{this.m_classifiers[0][1].SVMOutput(-1, instance), Instance.missingValue()};
            return this.m_classifiers[0][1].m_logistic.distributionForInstance(new Instance(1.0, dArray));
        }
        double[][] dArray = new double[instance.numClasses()][instance.numClasses()];
        double[][] dArray2 = new double[instance.numClasses()][instance.numClasses()];
        for (int i = 0; i < instance.numClasses(); ++i) {
            for (int j = i + 1; j < instance.numClasses(); ++j) {
                if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                double[] dArray3 = new double[]{this.m_classifiers[i][j].SVMOutput(-1, instance), Instance.missingValue()};
                dArray[i][j] = this.m_classifiers[i][j].m_logistic.distributionForInstance(new Instance(1.0, dArray3))[0];
                dArray2[i][j] = this.m_classifiers[i][j].m_sumOfWeights;
            }
        }
        return this.pairwiseCoupling(dArray2, dArray);
    }

    public double[] pairwiseCoupling(double[][] dArray, double[][] dArray2) {
        int n;
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = 1.0 / (double)dArray3.length;
        }
        double[][] dArray4 = new double[dArray2.length][dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (n = i + 1; n < dArray2.length; ++n) {
                dArray4[i][n] = 0.5;
            }
        }
        double[] dArray5 = new double[dArray3.length];
        for (n = 0; n < dArray3.length; ++n) {
            for (int i = n + 1; i < dArray3.length; ++i) {
                int n2 = n;
                dArray5[n2] = dArray5[n2] + dArray[n][i] * dArray2[n][i];
                int n3 = i;
                dArray5[n3] = dArray5[n3] + dArray[n][i] * (1.0 - dArray2[n][i]);
            }
        }
        do {
            int n4;
            n = 0;
            double[] dArray6 = new double[dArray3.length];
            for (n4 = 0; n4 < dArray3.length; ++n4) {
                for (int i = n4 + 1; i < dArray3.length; ++i) {
                    int n5 = n4;
                    dArray6[n5] = dArray6[n5] + dArray[n4][i] * dArray4[n4][i];
                    int n6 = i;
                    dArray6[n6] = dArray6[n6] + dArray[n4][i] * (1.0 - dArray4[n4][i]);
                }
            }
            for (n4 = 0; n4 < dArray3.length; ++n4) {
                if (dArray5[n4] == 0.0 || dArray6[n4] == 0.0) {
                    if (dArray3[n4] > 0.0) {
                        n = 1;
                    }
                    dArray3[n4] = 0.0;
                    continue;
                }
                double d = dArray5[n4] / dArray6[n4];
                double d2 = dArray3[n4];
                int n7 = n4;
                dArray3[n7] = dArray3[n7] * d;
                if (!(Math.abs(d2 - dArray3[n4]) > 0.001)) continue;
                n = 1;
            }
            Utils.normalize(dArray3);
            for (n4 = 0; n4 < dArray2.length; ++n4) {
                for (int i = n4 + 1; i < dArray2.length; ++i) {
                    dArray4[n4][i] = dArray3[n4] / (dArray3[n4] + dArray3[i]);
                }
            }
        } while (n != 0);
        return dArray3;
    }

    public int[] obtainVotes(Instance instance) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        int[] nArray = new int[instance.numClasses()];
        for (int i = 0; i < instance.numClasses(); ++i) {
            for (int j = i + 1; j < instance.numClasses(); ++j) {
                double d = this.m_classifiers[i][j].SVMOutput(-1, instance);
                if (d > 0.0) {
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
        }
        return nArray;
    }

    public double[][][] sparseWeights() {
        int n = this.m_classAttribute.numValues();
        double[][][] dArray = new double[n][n][];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                dArray[i][j] = this.m_classifiers[i][j].m_sparseWeights;
            }
        }
        return dArray;
    }

    public int[][][] sparseIndices() {
        int n = this.m_classAttribute.numValues();
        int[][][] nArray = new int[n][n][];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                nArray[i][j] = this.m_classifiers[i][j].m_sparseIndices;
            }
        }
        return nArray;
    }

    public double[][] bias() {
        int n = this.m_classAttribute.numValues();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                dArray[i][j] = this.m_classifiers[i][j].m_b;
            }
        }
        return dArray;
    }

    public int numClassAttributeValues() {
        return this.m_classAttribute.numValues();
    }

    public String[] classAttributeNames() {
        int n = this.m_classAttribute.numValues();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_classAttribute.value(i);
        }
        return stringArray;
    }

    public String[][][] attributeNames() {
        int n = this.m_classAttribute.numValues();
        String[][][] stringArray = new String[n][n][];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n2 = this.m_classifiers[i][j].m_data.numAttributes();
                String[] stringArray2 = new String[n2];
                for (int k = 0; k < n2; ++k) {
                    stringArray2[k] = this.m_classifiers[i][j].m_data.attribute(k).name();
                }
                stringArray[i][j] = stringArray2;
            }
        }
        return stringArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(13);
        vector.addElement(new Option("\tThe complexity constant C. (default 1)", "C", 1, "-C <double>"));
        vector.addElement(new Option("\tThe exponent for the polynomial kernel. (default 1)", "E", 1, "-E <double>"));
        vector.addElement(new Option("\tGamma for the RBF kernel. (default 0.01)", "G", 1, "-G <double>"));
        vector.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither. (default 0=normalize)", "N", 1, "-N"));
        vector.addElement(new Option("\tFeature-space normalization (only for\n\tnon-linear polynomial kernels).", "F", 0, "-F"));
        vector.addElement(new Option("\tUse lower-order terms (only for non-linear\n\tpolynomial kernels).", "O", 0, "-O"));
        vector.addElement(new Option("\tUse RBF kernel. (default poly)", "R", 0, "-R"));
        vector.addElement(new Option("\tThe size of the kernel cache. (default 1000003)", "A", 1, "-A <int>"));
        vector.addElement(new Option("\tThe tolerance parameter. (default 1.0e-3)", "T", 1, "-T <double>"));
        vector.addElement(new Option("\tThe epsilon for round-off error. (default 1.0e-12)", "P", 1, "-P <double>"));
        vector.addElement(new Option("\tFit logistic models to SVM outputs. ", "M", 0, "-M"));
        vector.addElement(new Option("\tThe number of folds for the internal\n\tcross-validation. (default -1, use training data)", "V", 1, "-V <double>"));
        vector.addElement(new Option("\tThe random number seed. (default 1)", "W", 1, "-W <double>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        this.m_C = string.length() != 0 ? new Double(string) : 1.0;
        String string2 = Utils.getOption('E', stringArray);
        this.m_exponent = string2.length() != 0 ? new Double(string2) : 1.0;
        String string3 = Utils.getOption('G', stringArray);
        this.m_gamma = string3.length() != 0 ? new Double(string3) : 0.01;
        String string4 = Utils.getOption('A', stringArray);
        this.m_cacheSize = string4.length() != 0 ? Integer.parseInt(string4) : 1000003;
        String string5 = Utils.getOption('T', stringArray);
        this.m_tol = string5.length() != 0 ? new Double(string5) : 0.001;
        String string6 = Utils.getOption('P', stringArray);
        this.m_eps = string6.length() != 0 ? new Double(string6) : 1.0E-12;
        this.m_useRBF = Utils.getFlag('R', stringArray);
        String string7 = Utils.getOption('N', stringArray);
        if (string7.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(string7), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        this.m_featureSpaceNormalization = Utils.getFlag('F', stringArray);
        if (this.m_useRBF && this.m_featureSpaceNormalization) {
            throw new Exception("RBF machine doesn't require feature-space normalization.");
        }
        if (this.m_exponent == 1.0 && this.m_featureSpaceNormalization) {
            throw new Exception("Can't use feature-space normalization with linear machine.");
        }
        this.m_lowerOrder = Utils.getFlag('O', stringArray);
        if (this.m_useRBF && this.m_lowerOrder) {
            throw new Exception("Can't use lower-order terms with RBF machine.");
        }
        if (this.m_exponent == 1.0 && this.m_lowerOrder) {
            throw new Exception("Can't use lower-order terms with linear machine.");
        }
        this.m_fitLogisticModels = Utils.getFlag('M', stringArray);
        String string8 = Utils.getOption('V', stringArray);
        this.m_numFolds = string8.length() != 0 ? Integer.parseInt(string8) : -1;
        String string9 = Utils.getOption('W', stringArray);
        this.m_randomSeed = string9.length() != 0 ? Integer.parseInt(string9) : 1;
    }

    public String[] getOptions() {
        String[] stringArray = new String[21];
        int n = 0;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.m_C;
        stringArray[n++] = "-E";
        stringArray[n++] = "" + this.m_exponent;
        stringArray[n++] = "-G";
        stringArray[n++] = "" + this.m_gamma;
        stringArray[n++] = "-A";
        stringArray[n++] = "" + this.m_cacheSize;
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.m_tol;
        stringArray[n++] = "-P";
        stringArray[n++] = "" + this.m_eps;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_filterType;
        if (this.m_featureSpaceNormalization) {
            stringArray[n++] = "-F";
        }
        if (this.m_lowerOrder) {
            stringArray[n++] = "-O";
        }
        if (this.m_useRBF) {
            stringArray[n++] = "-R";
        }
        if (this.m_fitLogisticModels) {
            stringArray[n++] = "-M";
        }
        stringArray[n++] = "-V";
        stringArray[n++] = "" + this.m_numFolds;
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.m_randomSeed;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String exponentTipText() {
        return "The exponent for the polynomial kernel.";
    }

    public double getExponent() {
        return this.m_exponent;
    }

    public void setExponent(double d) {
        if (d == 1.0) {
            this.m_featureSpaceNormalization = false;
            this.m_lowerOrder = false;
        }
        this.m_exponent = d;
    }

    public String gammaTipText() {
        return "The value of the gamma parameter for RBF kernels.";
    }

    public double getGamma() {
        return this.m_gamma;
    }

    public void setGamma(double d) {
        this.m_gamma = d;
    }

    public String cTipText() {
        return "The complexity parameter C.";
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double d) {
        this.m_C = d;
    }

    public String toleranceParameterTipText() {
        return "The tolerance parameter (shouldn't be changed).";
    }

    public double getToleranceParameter() {
        return this.m_tol;
    }

    public void setToleranceParameter(double d) {
        this.m_tol = d;
    }

    public String epsilonTipText() {
        return "The epsilon for round-off error (shouldn't be changed).";
    }

    public double getEpsilon() {
        return this.m_eps;
    }

    public void setEpsilon(double d) {
        this.m_eps = d;
    }

    public String cacheSizeTipText() {
        return "The size of the kernel cache (should be a prime number).";
    }

    public int getCacheSize() {
        return this.m_cacheSize;
    }

    public void setCacheSize(int n) {
        this.m_cacheSize = n;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_FILTER) {
            this.m_filterType = selectedTag.getSelectedTag().getID();
        }
    }

    public String useRBFTipText() {
        return "Whether to use an RBF kernel instead of a polynomial one.";
    }

    public boolean getUseRBF() {
        return this.m_useRBF;
    }

    public void setUseRBF(boolean bl) {
        if (bl) {
            this.m_featureSpaceNormalization = false;
            this.m_lowerOrder = false;
        }
        this.m_useRBF = bl;
    }

    public String featureSpaceNormalizationTipText() {
        return "Whether feature-space normalization is performed (only available for non-linear polynomial kernels).";
    }

    public boolean getFeatureSpaceNormalization() throws Exception {
        return this.m_featureSpaceNormalization;
    }

    public void setFeatureSpaceNormalization(boolean bl) throws Exception {
        this.m_featureSpaceNormalization = this.m_useRBF || this.m_exponent == 1.0 ? false : bl;
    }

    public String lowerOrderTermsTipText() {
        return "Whether lower order polyomials are also used (only available for non-linear polynomial kernels).";
    }

    public boolean getLowerOrderTerms() {
        return this.m_lowerOrder;
    }

    public void setLowerOrderTerms(boolean bl) {
        this.m_lowerOrder = this.m_exponent == 1.0 || this.m_useRBF ? false : bl;
    }

    public String buildLogisticModelsTipText() {
        return "Whether to fit logistic models to the outputs (for proper probability estimates).";
    }

    public boolean getBuildLogisticModels() {
        return this.m_fitLogisticModels;
    }

    public void setBuildLogisticModels(boolean bl) {
        this.m_fitLogisticModels = bl;
    }

    public String numFoldsTipText() {
        return "The number of folds for cross-validation used to generate training data for logistic models (-1 means use training data).";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int n) {
        this.m_numFolds = n;
    }

    public String randomSeedTipText() {
        return "Random number seed for the cross-validation.";
    }

    public int getRandomSeed() {
        return this.m_randomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_randomSeed = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.m_classAttribute == null) {
            return "SMO: No model built yet.";
        }
        try {
            stringBuffer.append("SMO\n\n");
            for (int i = 0; i < this.m_classAttribute.numValues(); ++i) {
                for (int j = i + 1; j < this.m_classAttribute.numValues(); ++j) {
                    stringBuffer.append("Classifier for classes: " + this.m_classAttribute.value(i) + ", " + this.m_classAttribute.value(j) + "\n\n");
                    stringBuffer.append(this.m_classifiers[i][j]);
                    if (this.m_fitLogisticModels) {
                        stringBuffer.append("\n\n");
                        if (this.m_classifiers[i][j].m_logistic == null) {
                            stringBuffer.append("No logistic model has been fit.\n");
                        } else {
                            stringBuffer.append(this.m_classifiers[i][j].m_logistic);
                        }
                    }
                    stringBuffer.append("\n\n");
                }
            }
        }
        catch (Exception exception) {
            return "Can't print SMO classifier.";
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            SMO sMO = new SMO();
            System.out.println(Evaluation.evaluateModel(sMO, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    private class BinarySMO
    implements Serializable {
        private double[] m_alpha;
        private double m_b;
        private double m_bLow;
        private double m_bUp;
        private int m_iLow;
        private int m_iUp;
        private Instances m_data;
        private double[] m_weights;
        private double[] m_sparseWeights;
        private int[] m_sparseIndices;
        private Kernel m_kernel;
        private double[] m_class;
        private double[] m_errors;
        private SMOset m_I0;
        private SMOset m_I1;
        private SMOset m_I2;
        private SMOset m_I3;
        private SMOset m_I4;
        private SMOset m_supportVectors;
        private Logistic m_logistic = null;
        private double m_sumOfWeights = 0.0;

        private BinarySMO() {
        }

        private void fitLogistic(Instances instances, int n, int n2, int n3, Random random) throws Exception {
            FastVector fastVector = new FastVector(2);
            fastVector.addElement(new Attribute("pred"));
            FastVector fastVector2 = new FastVector(2);
            fastVector2.addElement(instances.classAttribute().value(n));
            fastVector2.addElement(instances.classAttribute().value(n2));
            fastVector.addElement(new Attribute("class", fastVector2));
            Instances instances2 = new Instances("data", fastVector, instances.numInstances());
            instances2.setClassIndex(1);
            if (n3 <= 0) {
                for (int i = 0; i < instances.numInstances(); ++i) {
                    Instance instance = instances.instance(i);
                    double[] dArray = new double[2];
                    dArray[0] = this.SVMOutput(-1, instance);
                    if (instance.classValue() == (double)n2) {
                        dArray[1] = 1.0;
                    }
                    instances2.add(new Instance(instance.weight(), dArray));
                }
            } else {
                if (n3 > instances.numInstances()) {
                    n3 = instances.numInstances();
                }
                instances = new Instances(instances);
                instances.randomize(random);
                instances.stratify(n3);
                for (int i = 0; i < n3; ++i) {
                    Instances instances3 = instances.trainCV(n3, i, random);
                    SerializedObject serializedObject = new SerializedObject(this);
                    BinarySMO binarySMO = (BinarySMO)serializedObject.getObject();
                    binarySMO.buildClassifier(instances3, n, n2, false, -1, -1);
                    Instances instances4 = instances.testCV(n3, i);
                    for (int j = 0; j < instances4.numInstances(); ++j) {
                        double[] dArray = new double[2];
                        dArray[0] = binarySMO.SVMOutput(-1, instances4.instance(j));
                        if (instances4.instance(j).classValue() == (double)n2) {
                            dArray[1] = 1.0;
                        }
                        instances2.add(new Instance(instances4.instance(j).weight(), dArray));
                    }
                }
            }
            this.m_logistic = new Logistic();
            this.m_logistic.buildClassifier(instances2);
        }

        private void buildClassifier(Instances instances, int n, int n2, boolean bl, int n3, int n4) throws Exception {
            int n5;
            this.m_bUp = -1.0;
            this.m_bLow = 1.0;
            this.m_b = 0.0;
            this.m_alpha = null;
            this.m_data = null;
            this.m_weights = null;
            this.m_errors = null;
            this.m_logistic = null;
            this.m_I0 = null;
            this.m_I1 = null;
            this.m_I2 = null;
            this.m_I3 = null;
            this.m_I4 = null;
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_sumOfWeights = instances.sumOfWeights();
            this.m_class = new double[instances.numInstances()];
            this.m_iUp = -1;
            this.m_iLow = -1;
            for (n5 = 0; n5 < this.m_class.length; ++n5) {
                if ((int)instances.instance(n5).classValue() == n) {
                    this.m_class[n5] = -1.0;
                    this.m_iLow = n5;
                    continue;
                }
                if ((int)instances.instance(n5).classValue() == n2) {
                    this.m_class[n5] = 1.0;
                    this.m_iUp = n5;
                    continue;
                }
                throw new Exception("This should never happen!");
            }
            if (this.m_iUp == -1 || this.m_iLow == -1) {
                if (this.m_iUp != -1) {
                    this.m_b = -1.0;
                } else if (this.m_iLow != -1) {
                    this.m_b = 1.0;
                } else {
                    this.m_class = null;
                    return;
                }
                if (!SMO.this.m_useRBF && SMO.this.m_exponent == 1.0) {
                    this.m_sparseWeights = new double[0];
                    this.m_sparseIndices = new int[0];
                    this.m_class = null;
                } else {
                    this.m_supportVectors = new SMOset(0);
                    this.m_alpha = new double[0];
                    this.m_class = new double[0];
                }
                if (bl) {
                    this.fitLogistic(instances, n, n2, n3, new Random(n4));
                }
                return;
            }
            this.m_data = instances;
            this.m_weights = (double[])(!SMO.this.m_useRBF && SMO.this.m_exponent == 1.0 ? new double[this.m_data.numAttributes()] : null);
            this.m_alpha = new double[this.m_data.numInstances()];
            this.m_supportVectors = new SMOset(this.m_data.numInstances());
            this.m_I0 = new SMOset(this.m_data.numInstances());
            this.m_I1 = new SMOset(this.m_data.numInstances());
            this.m_I2 = new SMOset(this.m_data.numInstances());
            this.m_I3 = new SMOset(this.m_data.numInstances());
            this.m_I4 = new SMOset(this.m_data.numInstances());
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_errors = new double[this.m_data.numInstances()];
            this.m_errors[this.m_iLow] = 1.0;
            this.m_errors[this.m_iUp] = -1.0;
            this.m_kernel = SMO.this.m_useRBF ? new RBFKernel(this.m_data, SMO.this.m_cacheSize, SMO.this.m_gamma) : (SMO.this.m_featureSpaceNormalization ? new NormalizedPolyKernel(this.m_data, SMO.this.m_cacheSize, SMO.this.m_exponent, SMO.this.m_lowerOrder) : new PolyKernel(this.m_data, SMO.this.m_cacheSize, SMO.this.m_exponent, SMO.this.m_lowerOrder));
            for (n5 = 0; n5 < this.m_class.length; ++n5) {
                if (this.m_class[n5] == 1.0) {
                    this.m_I1.insert(n5);
                    continue;
                }
                this.m_I4.insert(n5);
            }
            n5 = 0;
            boolean bl2 = true;
            while (n5 > 0 || bl2) {
                int n6;
                n5 = 0;
                if (bl2) {
                    for (n6 = 0; n6 < this.m_alpha.length; ++n6) {
                        if (!this.examineExample(n6)) continue;
                        ++n5;
                    }
                } else {
                    for (n6 = 0; n6 < this.m_alpha.length; ++n6) {
                        if (!(this.m_alpha[n6] > 0.0) || !(this.m_alpha[n6] < SMO.this.m_C * this.m_data.instance(n6).weight())) continue;
                        if (this.examineExample(n6)) {
                            ++n5;
                        }
                        if (!(this.m_bUp > this.m_bLow - 2.0 * SMO.this.m_tol)) continue;
                        n5 = 0;
                        break;
                    }
                }
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                if (n5 != 0) continue;
                bl2 = true;
            }
            this.m_b = (this.m_bLow + this.m_bUp) / 2.0;
            this.m_kernel.clean();
            this.m_errors = null;
            this.m_I4 = null;
            this.m_I3 = null;
            this.m_I2 = null;
            this.m_I1 = null;
            this.m_I0 = null;
            if (!SMO.this.m_useRBF && SMO.this.m_exponent == 1.0) {
                this.m_supportVectors = null;
                this.m_class = null;
                this.m_data = !SMO.this.m_checksTurnedOff ? new Instances(this.m_data, 0) : null;
                double[] dArray = new double[this.m_weights.length];
                int[] nArray = new int[this.m_weights.length];
                int n7 = 0;
                for (int i = 0; i < this.m_weights.length; ++i) {
                    if (this.m_weights[i] == 0.0) continue;
                    dArray[n7] = this.m_weights[i];
                    nArray[n7] = i;
                    ++n7;
                }
                this.m_sparseWeights = new double[n7];
                this.m_sparseIndices = new int[n7];
                System.arraycopy(dArray, 0, this.m_sparseWeights, 0, n7);
                System.arraycopy(nArray, 0, this.m_sparseIndices, 0, n7);
                this.m_weights = null;
                this.m_alpha = null;
            }
            if (bl) {
                this.fitLogistic(instances, n, n2, n3, new Random(n4));
            }
        }

        private double SVMOutput(int n, Instance instance) throws Exception {
            double d = 0.0;
            if (!SMO.this.m_useRBF && SMO.this.m_exponent == 1.0) {
                if (this.m_sparseWeights == null) {
                    int n2 = instance.numValues();
                    for (int i = 0; i < n2; ++i) {
                        if (instance.index(i) == SMO.this.m_classIndex) continue;
                        d += this.m_weights[instance.index(i)] * instance.valueSparse(i);
                    }
                } else {
                    int n3 = instance.numValues();
                    int n4 = this.m_sparseWeights.length;
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < n3 && n6 < n4) {
                        int n7;
                        int n8 = instance.index(n5);
                        if (n8 == (n7 = this.m_sparseIndices[n6])) {
                            if (n8 != SMO.this.m_classIndex) {
                                d += instance.valueSparse(n5) * this.m_sparseWeights[n6];
                            }
                            ++n5;
                            ++n6;
                            continue;
                        }
                        if (n8 > n7) {
                            ++n6;
                            continue;
                        }
                        ++n5;
                    }
                }
            } else {
                int n9 = this.m_supportVectors.getNext(-1);
                while (n9 != -1) {
                    d += this.m_class[n9] * this.m_alpha[n9] * this.m_kernel.eval(n, n9, instance);
                    n9 = this.m_supportVectors.getNext(n9);
                }
            }
            return d -= this.m_b;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            if (this.m_alpha == null && this.m_sparseWeights == null) {
                return "BinarySMO: No model built yet.\n";
            }
            try {
                int n2;
                stringBuffer.append("BinarySMO\n\n");
                if (!SMO.this.m_useRBF && SMO.this.m_exponent == 1.0) {
                    stringBuffer.append("Machine linear: showing attribute weights, ");
                    stringBuffer.append("not support vectors.\n\n");
                    for (n2 = 0; n2 < this.m_sparseWeights.length; ++n2) {
                        if (this.m_sparseIndices[n2] == SMO.this.m_classIndex) continue;
                        if (n > 0) {
                            stringBuffer.append(" + ");
                        } else {
                            stringBuffer.append("   ");
                        }
                        stringBuffer.append(Utils.doubleToString(this.m_sparseWeights[n2], 12, 4) + " * ");
                        if (SMO.this.m_filterType == 1) {
                            stringBuffer.append("(standardized) ");
                        } else if (SMO.this.m_filterType == 0) {
                            stringBuffer.append("(normalized) ");
                        }
                        if (!SMO.this.m_checksTurnedOff) {
                            stringBuffer.append(this.m_data.attribute(this.m_sparseIndices[n2]).name() + "\n");
                        } else {
                            stringBuffer.append("attribute with index " + this.m_sparseIndices[n2] + "\n");
                        }
                        ++n;
                    }
                } else {
                    for (n2 = 0; n2 < this.m_alpha.length; ++n2) {
                        if (!this.m_supportVectors.contains(n2)) continue;
                        double d = this.m_alpha[n2];
                        if (this.m_class[n2] == 1.0) {
                            if (n > 0) {
                                stringBuffer.append(" + ");
                            }
                        } else {
                            stringBuffer.append(" - ");
                        }
                        stringBuffer.append(Utils.doubleToString(d, 12, 4) + " * <");
                        for (int i = 0; i < this.m_data.numAttributes(); ++i) {
                            if (i != this.m_data.classIndex()) {
                                stringBuffer.append(this.m_data.instance(n2).toString(i));
                            }
                            if (i == this.m_data.numAttributes() - 1) continue;
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append("> * X]\n");
                        ++n;
                    }
                }
                if (this.m_b > 0.0) {
                    stringBuffer.append(" - " + Utils.doubleToString(this.m_b, 12, 4));
                } else {
                    stringBuffer.append(" + " + Utils.doubleToString(-this.m_b, 12, 4));
                }
                if (SMO.this.m_useRBF || SMO.this.m_exponent != 1.0) {
                    stringBuffer.append("\n\nNumber of support vectors: " + this.m_supportVectors.numElements());
                }
                n2 = 0;
                n2 = this.m_kernel != null ? this.m_kernel.numEvals() : 0;
                stringBuffer.append("\n\nNumber of kernel evaluations: " + n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "Can't print BinarySMO classifier.";
            }
            return stringBuffer.toString();
        }

        private boolean examineExample(int n) throws Exception {
            double d;
            int n2 = -1;
            double d2 = this.m_class[n];
            double d3 = this.m_alpha[n];
            if (this.m_I0.contains(n)) {
                d = this.m_errors[n];
            } else {
                this.m_errors[n] = d = this.SVMOutput(n, this.m_data.instance(n)) + this.m_b - d2;
                if ((this.m_I1.contains(n) || this.m_I2.contains(n)) && d < this.m_bUp) {
                    this.m_bUp = d;
                    this.m_iUp = n;
                } else if ((this.m_I3.contains(n) || this.m_I4.contains(n)) && d > this.m_bLow) {
                    this.m_bLow = d;
                    this.m_iLow = n;
                }
            }
            boolean bl = true;
            if ((this.m_I0.contains(n) || this.m_I1.contains(n) || this.m_I2.contains(n)) && this.m_bLow - d > 2.0 * SMO.this.m_tol) {
                bl = false;
                n2 = this.m_iLow;
            }
            if ((this.m_I0.contains(n) || this.m_I3.contains(n) || this.m_I4.contains(n)) && d - this.m_bUp > 2.0 * SMO.this.m_tol) {
                bl = false;
                n2 = this.m_iUp;
            }
            if (bl) {
                return false;
            }
            if (this.m_I0.contains(n)) {
                n2 = this.m_bLow - d > d - this.m_bUp ? this.m_iLow : this.m_iUp;
            }
            if (n2 == -1) {
                throw new Exception("This should never happen!");
            }
            return this.takeStep(n2, n, d);
        }

        private boolean takeStep(int n, int n2, double d) throws Exception {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6 = SMO.this.m_C * this.m_data.instance(n).weight();
            double d7 = SMO.this.m_C * this.m_data.instance(n2).weight();
            if (n == n2) {
                return false;
            }
            double d8 = this.m_alpha[n];
            double d9 = this.m_alpha[n2];
            double d10 = this.m_class[n];
            double d11 = this.m_class[n2];
            double d12 = this.m_errors[n];
            double d13 = d10 * d11;
            if (d10 != d11) {
                d5 = Math.max(0.0, d9 - d8);
                d4 = Math.min(d7, d6 + d9 - d8);
            } else {
                d5 = Math.max(0.0, d8 + d9 - d6);
                d4 = Math.min(d7, d8 + d9);
            }
            if (d5 >= d4) {
                return false;
            }
            double d14 = this.m_kernel.eval(n, n, this.m_data.instance(n));
            double d15 = this.m_kernel.eval(n, n2, this.m_data.instance(n));
            double d16 = 2.0 * d15 - d14 - (d3 = this.m_kernel.eval(n2, n2, this.m_data.instance(n2)));
            if (d16 < 0.0) {
                d2 = d9 - d11 * (d12 - d) / d16;
                if (d2 < d5) {
                    d2 = d5;
                } else if (d2 > d4) {
                    d2 = d4;
                }
            } else {
                double d17;
                double d18;
                double d19;
                double d20 = d8 + d13 * d9;
                double d21 = this.SVMOutput(n, this.m_data.instance(n));
                double d22 = d21 + this.m_b - d10 * d8 * d14 - d11 * d9 * d15;
                double d23 = d20 - d13 * d5 + d5 - 0.5 * d14 * (d20 - d13 * d5) * (d20 - d13 * d5) - 0.5 * d3 * d5 * d5 - d13 * d15 * (d20 - d13 * d5) * d5 - d10 * (d20 - d13 * d5) * d22 - d11 * d5 * (d19 = (d18 = this.SVMOutput(n2, this.m_data.instance(n2))) + this.m_b - d10 * d8 * d15 - d11 * d9 * d3);
                d2 = d23 > (d17 = d20 - d13 * d4 + d4 - 0.5 * d14 * (d20 - d13 * d4) * (d20 - d13 * d4) - 0.5 * d3 * d4 * d4 - d13 * d15 * (d20 - d13 * d4) * d4 - d10 * (d20 - d13 * d4) * d22 - d11 * d4 * d19) + SMO.this.m_eps ? d5 : (d23 < d17 - SMO.this.m_eps ? d4 : d9);
            }
            if (Math.abs(d2 - d9) < SMO.this.m_eps * (d2 + d9 + SMO.this.m_eps)) {
                return false;
            }
            if (d2 > d7 - m_Del * d7) {
                d2 = d7;
            } else if (d2 <= m_Del * d7) {
                d2 = 0.0;
            }
            double d24 = d8 + d13 * (d9 - d2);
            if (d24 > d6 - m_Del * d6) {
                d24 = d6;
            } else if (d24 <= m_Del * d6) {
                d24 = 0.0;
            }
            if (d24 > 0.0) {
                this.m_supportVectors.insert(n);
            } else {
                this.m_supportVectors.delete(n);
            }
            if (d24 > 0.0 && d24 < d6) {
                this.m_I0.insert(n);
            } else {
                this.m_I0.delete(n);
            }
            if (d10 == 1.0 && d24 == 0.0) {
                this.m_I1.insert(n);
            } else {
                this.m_I1.delete(n);
            }
            if (d10 == -1.0 && d24 == d6) {
                this.m_I2.insert(n);
            } else {
                this.m_I2.delete(n);
            }
            if (d10 == 1.0 && d24 == d6) {
                this.m_I3.insert(n);
            } else {
                this.m_I3.delete(n);
            }
            if (d10 == -1.0 && d24 == 0.0) {
                this.m_I4.insert(n);
            } else {
                this.m_I4.delete(n);
            }
            if (d2 > 0.0) {
                this.m_supportVectors.insert(n2);
            } else {
                this.m_supportVectors.delete(n2);
            }
            if (d2 > 0.0 && d2 < d7) {
                this.m_I0.insert(n2);
            } else {
                this.m_I0.delete(n2);
            }
            if (d11 == 1.0 && d2 == 0.0) {
                this.m_I1.insert(n2);
            } else {
                this.m_I1.delete(n2);
            }
            if (d11 == -1.0 && d2 == d7) {
                this.m_I2.insert(n2);
            } else {
                this.m_I2.delete(n2);
            }
            if (d11 == 1.0 && d2 == d7) {
                this.m_I3.insert(n2);
            } else {
                this.m_I3.delete(n2);
            }
            if (d11 == -1.0 && d2 == 0.0) {
                this.m_I4.insert(n2);
            } else {
                this.m_I4.delete(n2);
            }
            if (!SMO.this.m_useRBF && SMO.this.m_exponent == 1.0) {
                Instance instance = this.m_data.instance(n);
                for (int i = 0; i < instance.numValues(); ++i) {
                    if (instance.index(i) == this.m_data.classIndex()) continue;
                    int n3 = instance.index(i);
                    this.m_weights[n3] = this.m_weights[n3] + d10 * (d24 - d8) * instance.valueSparse(i);
                }
                Instance instance2 = this.m_data.instance(n2);
                for (int i = 0; i < instance2.numValues(); ++i) {
                    if (instance2.index(i) == this.m_data.classIndex()) continue;
                    int n4 = instance2.index(i);
                    this.m_weights[n4] = this.m_weights[n4] + d11 * (d2 - d9) * instance2.valueSparse(i);
                }
            }
            int n5 = this.m_I0.getNext(-1);
            while (n5 != -1) {
                if (n5 != n && n5 != n2) {
                    int n6 = n5;
                    this.m_errors[n6] = this.m_errors[n6] + (d10 * (d24 - d8) * this.m_kernel.eval(n, n5, this.m_data.instance(n)) + d11 * (d2 - d9) * this.m_kernel.eval(n2, n5, this.m_data.instance(n2)));
                }
                n5 = this.m_I0.getNext(n5);
            }
            int n7 = n;
            this.m_errors[n7] = this.m_errors[n7] + (d10 * (d24 - d8) * d14 + d11 * (d2 - d9) * d15);
            int n8 = n2;
            this.m_errors[n8] = this.m_errors[n8] + (d10 * (d24 - d8) * d15 + d11 * (d2 - d9) * d3);
            this.m_alpha[n] = d24;
            this.m_alpha[n2] = d2;
            this.m_bLow = -1.7976931348623157E308;
            this.m_bUp = Double.MAX_VALUE;
            this.m_iLow = -1;
            this.m_iUp = -1;
            n5 = this.m_I0.getNext(-1);
            while (n5 != -1) {
                if (this.m_errors[n5] < this.m_bUp) {
                    this.m_bUp = this.m_errors[n5];
                    this.m_iUp = n5;
                }
                if (this.m_errors[n5] > this.m_bLow) {
                    this.m_bLow = this.m_errors[n5];
                    this.m_iLow = n5;
                }
                n5 = this.m_I0.getNext(n5);
            }
            if (!this.m_I0.contains(n)) {
                if (this.m_I3.contains(n) || this.m_I4.contains(n)) {
                    if (this.m_errors[n] > this.m_bLow) {
                        this.m_bLow = this.m_errors[n];
                        this.m_iLow = n;
                    }
                } else if (this.m_errors[n] < this.m_bUp) {
                    this.m_bUp = this.m_errors[n];
                    this.m_iUp = n;
                }
            }
            if (!this.m_I0.contains(n2)) {
                if (this.m_I3.contains(n2) || this.m_I4.contains(n2)) {
                    if (this.m_errors[n2] > this.m_bLow) {
                        this.m_bLow = this.m_errors[n2];
                        this.m_iLow = n2;
                    }
                } else if (this.m_errors[n2] < this.m_bUp) {
                    this.m_bUp = this.m_errors[n2];
                    this.m_iUp = n2;
                }
            }
            if (this.m_iLow == -1 || this.m_iUp == -1) {
                throw new Exception("This should never happen!");
            }
            return true;
        }

        private void checkClassifier() throws Exception {
            int n;
            double d = 0.0;
            for (n = 0; n < this.m_alpha.length; ++n) {
                if (!(this.m_alpha[n] > 0.0)) continue;
                d += this.m_class[n] * this.m_alpha[n];
            }
            System.err.println("Sum of y(i) * alpha(i): " + d);
            for (n = 0; n < this.m_alpha.length; ++n) {
                double d2 = this.SVMOutput(n, this.m_data.instance(n));
                if (Utils.eq(this.m_alpha[n], 0.0) && Utils.sm(this.m_class[n] * d2, 1.0)) {
                    System.err.println("KKT condition 1 violated: " + this.m_class[n] * d2);
                }
                if (Utils.gr(this.m_alpha[n], 0.0) && Utils.sm(this.m_alpha[n], SMO.this.m_C * this.m_data.instance(n).weight()) && !Utils.eq(this.m_class[n] * d2, 1.0)) {
                    System.err.println("KKT condition 2 violated: " + this.m_class[n] * d2);
                }
                if (!Utils.eq(this.m_alpha[n], SMO.this.m_C * this.m_data.instance(n).weight()) || !Utils.gr(this.m_class[n] * d2, 1.0)) continue;
                System.err.println("KKT condition 3 violated: " + this.m_class[n] * d2);
            }
        }
    }
}

