/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class HillClimber
extends GlobalScoreSearchAlgorithm {
    boolean m_bUseArcReversal = false;

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        this.m_BayesNet = bayesNet;
        double d = this.calcScore(bayesNet);
        Operation operation = this.getOptimalOperation(bayesNet, instances);
        while (operation != null && operation.m_fScore > d) {
            this.performOperation(bayesNet, instances, operation);
            d = operation.m_fScore;
            operation = this.getOptimalOperation(bayesNet, instances);
        }
    }

    boolean isNotTabu(Operation operation) {
        return true;
    }

    Operation getOptimalOperation(BayesNet bayesNet, Instances instances) throws Exception {
        Operation operation = new Operation();
        operation = this.findBestArcToAdd(bayesNet, instances, operation);
        operation = this.findBestArcToDelete(bayesNet, instances, operation);
        if (this.getUseArcReversal()) {
            operation = this.findBestArcToReverse(bayesNet, instances, operation);
        }
        if (operation.m_fScore == -1.0E100) {
            return null;
        }
        return operation;
    }

    void performOperation(BayesNet bayesNet, Instances instances, Operation operation) throws Exception {
        switch (operation.m_nOperation) {
            case 0: {
                this.applyArcAddition(bayesNet, operation.m_nHead, operation.m_nTail, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print("Add " + operation.m_nHead + " -> " + operation.m_nTail);
                break;
            }
            case 1: {
                this.applyArcDeletion(bayesNet, operation.m_nHead, operation.m_nTail, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print("Del " + operation.m_nHead + " -> " + operation.m_nTail);
                break;
            }
            case 2: {
                this.applyArcDeletion(bayesNet, operation.m_nHead, operation.m_nTail, instances);
                this.applyArcAddition(bayesNet, operation.m_nTail, operation.m_nHead, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print("Rev " + operation.m_nHead + " -> " + operation.m_nTail);
            }
        }
    }

    void applyArcAddition(BayesNet bayesNet, int n, int n2, Instances instances) {
        ParentSet parentSet = bayesNet.getParentSet(n);
        parentSet.addParent(n2, instances);
    }

    void applyArcDeletion(BayesNet bayesNet, int n, int n2, Instances instances) {
        ParentSet parentSet = bayesNet.getParentSet(n);
        parentSet.deleteParent(n2, instances);
    }

    Operation findBestArcToAdd(BayesNet bayesNet, Instances instances, Operation operation) throws Exception {
        int n = instances.numAttributes();
        for (int i = 0; i < n; ++i) {
            if (bayesNet.getParentSet(i).getNrOfParents() >= this.m_nMaxNrOfParents) continue;
            for (int j = 0; j < n; ++j) {
                if (!this.addArcMakesSense(bayesNet, instances, i, j)) continue;
                Operation operation2 = new Operation(j, i, 0);
                double d = this.calcScoreWithExtraParent(operation2.m_nHead, operation2.m_nTail);
                if (!(d > operation.m_fScore) || !this.isNotTabu(operation2)) continue;
                operation = operation2;
                operation.m_fScore = d;
            }
        }
        return operation;
    }

    Operation findBestArcToDelete(BayesNet bayesNet, Instances instances, Operation operation) throws Exception {
        int n = instances.numAttributes();
        for (int i = 0; i < n; ++i) {
            ParentSet parentSet = bayesNet.getParentSet(i);
            for (int j = 0; j < parentSet.getNrOfParents(); ++j) {
                Operation operation2 = new Operation(parentSet.getParent(j), i, 1);
                double d = this.calcScoreWithMissingParent(operation2.m_nHead, operation2.m_nTail);
                if (!(d > operation.m_fScore) || !this.isNotTabu(operation2)) continue;
                operation = operation2;
                operation.m_fScore = d;
            }
        }
        return operation;
    }

    Operation findBestArcToReverse(BayesNet bayesNet, Instances instances, Operation operation) throws Exception {
        int n = instances.numAttributes();
        for (int i = 0; i < n; ++i) {
            ParentSet parentSet = bayesNet.getParentSet(i);
            for (int j = 0; j < parentSet.getNrOfParents(); ++j) {
                int n2 = parentSet.getParent(j);
                if (!this.reverseArcMakesSense(bayesNet, instances, i, n2) || bayesNet.getParentSet(n2).getNrOfParents() >= this.m_nMaxNrOfParents) continue;
                Operation operation2 = new Operation(parentSet.getParent(j), i, 2);
                double d = this.calcScoreWithReversedParent(operation2.m_nHead, operation2.m_nTail);
                if (!(d > operation.m_fScore) || !this.isNotTabu(operation2)) continue;
                operation = operation2;
                operation.m_fScore = d;
            }
        }
        return operation;
    }

    public void setMaxNrOfParents(int n) {
        this.m_nMaxNrOfParents = n;
    }

    public int getMaxNrOfParents() {
        return this.m_nMaxNrOfParents;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tMaximum number of parents\n", "P", 1, "-P <nr of parents>"));
        vector.addElement(new Option("\tUse arc reversal operation.\n\t(default false)", "R", 0, "-R"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setUseArcReversal(Utils.getFlag('R', stringArray));
        this.setInitAsNaiveBayes(Utils.getFlag('N', stringArray));
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setMaxNrOfParents(Integer.parseInt(string));
        } else {
            this.setMaxNrOfParents(100000);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[7 + stringArray.length];
        int n = 0;
        if (this.getUseArcReversal()) {
            stringArray2[n++] = "-R";
        }
        if (!this.getInitAsNaiveBayes()) {
            stringArray2[n++] = "-N";
        }
        if (this.m_nMaxNrOfParents != 10000) {
            stringArray2[n++] = "-P";
            stringArray2[n++] = "" + this.m_nMaxNrOfParents;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void setInitAsNaiveBayes(boolean bl) {
        this.m_bInitAsNaiveBayes = bl;
    }

    public boolean getInitAsNaiveBayes() {
        return this.m_bInitAsNaiveBayes;
    }

    public boolean getUseArcReversal() {
        return this.m_bUseArcReversal;
    }

    public void setUseArcReversal(boolean bl) {
        this.m_bUseArcReversal = bl;
    }

    public String globalInfo() {
        return "This Bayes Network learning algorithm uses a hill climbing algorithm adding, deleting and reversing arcs. The search is not restricted by an order on the variables (unlike K2). The difference with B and B2 is that this hill climber also considers arrows part of the naive Bayes structure for deletion.";
    }

    public String useArcReversalTipText() {
        return "When set to true, the arc reversal operation is used in the search.";
    }

    class Operation
    implements Serializable {
        static final int OPERATION_ADD = 0;
        static final int OPERATION_DEL = 1;
        static final int OPERATION_REVERSE = 2;
        public int m_nTail;
        public int m_nHead;
        public int m_nOperation;
        public double m_fScore = -1.0E100;

        public Operation() {
        }

        public Operation(int n, int n2, int n3) {
            this.m_nHead = n2;
            this.m_nTail = n;
            this.m_nOperation = n3;
        }

        public boolean equals(Operation operation) {
            if (operation == null) {
                return false;
            }
            return this.m_nOperation == operation.m_nOperation && this.m_nHead == operation.m_nHead && this.m_nTail == operation.m_nTail;
        }
    }
}

