/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.File;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.estimators.Estimator;

public class BIFReader
extends BayesNet {
    private int[] m_nPositionX;
    private int[] m_nPositionY;
    private int[] m_order;
    String m_sFile;

    public BIFReader processFile(String string) throws Exception {
        this.m_sFile = string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new File(string));
        this.buildInstances(document, string);
        this.buildStructure(document);
        return this;
    }

    public String getFileName() {
        return this.m_sFile;
    }

    void buildStructure(Document document) throws Exception {
        this.m_Distributions = new Estimator[this.m_Instances.numAttributes()][];
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            int n;
            CharSequence charSequence;
            int n2;
            String string = this.m_Instances.attribute(i).name();
            NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)("//DEFINITION[normalize-space(FOR/text())=\"" + string + "\"]"));
            if (nodeList.getLength() == 0) {
                throw new Exception("No definition found for node " + string);
            }
            if (nodeList.getLength() > 1) {
                System.err.println("More than one definition found for node " + string + ". Using first definition.");
            }
            Element element = (Element)nodeList.item(0);
            nodeList = XPathAPI.selectNodeList((Node)element, (String)"GIVEN");
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                Node node = nodeList.item(n2).getFirstChild();
                charSequence = ((CharacterData)node).getData();
                n = this.getNode((String)charSequence);
                this.m_ParentSets[i].addParent(n, this.m_Instances);
            }
            n2 = this.m_ParentSets[i].getCardinalityOfParents();
            int n3 = this.m_Instances.attribute(i).numValues();
            this.m_Distributions[i] = new Estimator[n2];
            for (int j = 0; j < n2; ++j) {
                this.m_Distributions[i][j] = new DiscreteEstimatorBayes(n3, 0.0);
            }
            nodeList = XPathAPI.selectNodeList((Node)element, (String)"TABLE/text()");
            charSequence = new StringBuffer();
            for (n = 0; n < nodeList.getLength(); ++n) {
                ((StringBuffer)charSequence).append(((CharacterData)nodeList.item(n)).getData());
                ((StringBuffer)charSequence).append(' ');
            }
            StringTokenizer stringTokenizer = new StringTokenizer(((StringBuffer)charSequence).toString());
            for (int j = 0; j < n2; ++j) {
                DiscreteEstimatorBayes discreteEstimatorBayes = (DiscreteEstimatorBayes)this.m_Distributions[i][j];
                for (int k = 0; k < n3; ++k) {
                    String string2 = stringTokenizer.nextToken();
                    discreteEstimatorBayes.addValue(k, new Double(string2));
                }
            }
        }
    }

    private void Sync(BayesNet bayesNet) throws Exception {
        int n = this.m_Instances.numAttributes();
        if (n != bayesNet.m_Instances.numAttributes()) {
            throw new Exception("Cannot synchronize networks: different number of attributes.");
        }
        this.m_order = new int[n];
        int n2 = 0;
        while (n2 < n) {
            String string = bayesNet.getNodeName(n2);
            this.m_order[this.getNode((String)string)] = n2++;
        }
    }

    public int getNode(String string) throws Exception {
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            if (!this.m_Instances.attribute(i).name().equals(string)) continue;
            return i;
        }
        throw new Exception("Could not find node [[" + string + "]]");
    }

    void buildInstances(Document document, String string) throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"//NAME");
        if (nodeList.getLength() > 0) {
            string = ((CharacterData)nodeList.item(0).getFirstChild()).getData();
        }
        nodeList = XPathAPI.selectNodeList((Node)document, (String)"//VARIABLE");
        int n = nodeList.getLength();
        FastVector fastVector = new FastVector(n);
        this.m_nPositionX = new int[nodeList.getLength()];
        this.m_nPositionY = new int[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            NodeList nodeList2 = XPathAPI.selectNodeList((Node)nodeList.item(i), (String)"OUTCOME");
            int n2 = nodeList2.getLength();
            FastVector fastVector2 = new FastVector(n2 + 1);
            for (int j = 0; j < n2; ++j) {
                object2 = nodeList2.item(j).getFirstChild();
                object = ((CharacterData)object2).getData();
                if (object == null) {
                    object = "Value" + (j + 1);
                }
                fastVector2.addElement(object);
            }
            NodeList nodeList3 = XPathAPI.selectNodeList((Node)nodeList.item(i), (String)"NAME");
            if (nodeList3.getLength() == 0) {
                throw new Exception("No name specified for variable");
            }
            object2 = ((CharacterData)nodeList3.item(0).getFirstChild()).getData();
            object = new Attribute((String)object2, fastVector2);
            fastVector.addElement(object);
            nodeList2 = XPathAPI.selectNodeList((Node)nodeList.item(i), (String)"PROPERTY");
            n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j).getFirstChild();
                String string2 = ((CharacterData)node).getData();
                if (!string2.startsWith("position")) continue;
                int n3 = string2.indexOf(40);
                int n4 = string2.indexOf(44);
                int n5 = string2.indexOf(41);
                String string3 = string2.substring(n3 + 1, n4).trim();
                String string4 = string2.substring(n4 + 1, n5).trim();
                try {
                    this.m_nPositionX[i] = Integer.parseInt(string3);
                    this.m_nPositionY[i] = Integer.parseInt(string4);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Wrong number format in position :(" + string3 + "," + string4 + ")");
                    this.m_nPositionX[i] = 0;
                    this.m_nPositionY[i] = 0;
                }
            }
        }
        this.m_Instances = new Instances(string, fastVector, 100);
        this.m_Instances.setClassIndex(n - 1);
        this.setUseADTree(false);
        this.initStructure();
    }

    public int missingArcs(BayesNet bayesNet) {
        try {
            this.Sync(bayesNet);
            int n = 0;
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                for (int j = 0; j < this.m_ParentSets[i].getNrOfParents(); ++j) {
                    int n2 = this.m_ParentSets[i].getParent(j);
                    if (bayesNet.getParentSet(this.m_order[i]).contains(this.m_order[n2]) || bayesNet.getParentSet(this.m_order[n2]).contains(this.m_order[i])) continue;
                    ++n;
                }
            }
            return n;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return 0;
        }
    }

    public int extraArcs(BayesNet bayesNet) {
        try {
            this.Sync(bayesNet);
            int n = 0;
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                for (int j = 0; j < bayesNet.getParentSet(this.m_order[i]).getNrOfParents(); ++j) {
                    int n2 = this.m_order[bayesNet.getParentSet(this.m_order[i]).getParent(j)];
                    if (this.m_ParentSets[i].contains(n2) || this.m_ParentSets[n2].contains(i)) continue;
                    ++n;
                }
            }
            return n;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return 0;
        }
    }

    public double divergence(BayesNet bayesNet) {
        try {
            this.Sync(bayesNet);
            double d = 0.0;
            int n = this.m_Instances.numAttributes();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.m_Instances.attribute(i).numValues();
            }
            int[] nArray2 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                int n5 = n2;
                nArray2[n5] = nArray2[n5] + 1;
                while (n2 < n && nArray2[n2] == this.m_Instances.attribute(n2).numValues()) {
                    nArray2[n2] = 0;
                    if (++n2 >= n) continue;
                    int n6 = n2;
                    nArray2[n6] = nArray2[n6] + 1;
                }
                if (n2 >= n) continue;
                n2 = 0;
                double d2 = 1.0;
                for (int i = 0; i < n; ++i) {
                    int n7 = 0;
                    for (n4 = 0; n4 < this.m_ParentSets[i].getNrOfParents(); ++n4) {
                        n3 = this.m_ParentSets[i].getParent(n4);
                        n7 = n7 * nArray[n3] + nArray2[n3];
                    }
                    d2 *= this.m_Distributions[i][n7].getProbability(nArray2[i]);
                }
                double d3 = 1.0;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = 0;
                    for (int i = 0; i < bayesNet.getParentSet(this.m_order[n4]).getNrOfParents(); ++i) {
                        int n8 = this.m_order[bayesNet.getParentSet(this.m_order[n4]).getParent(i)];
                        n3 = n3 * nArray[n8] + nArray2[n8];
                    }
                    d3 *= bayesNet.m_Distributions[this.m_order[n4]][n3].getProbability(nArray2[n4]);
                }
                if (!(d2 > 0.0) || !(d3 > 0.0)) continue;
                d += d2 * Math.log(d3 / d2);
            }
            return d;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return 0.0;
        }
    }

    public int reversedArcs(BayesNet bayesNet) {
        try {
            this.Sync(bayesNet);
            int n = 0;
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                for (int j = 0; j < this.m_ParentSets[i].getNrOfParents(); ++j) {
                    int n2 = this.m_ParentSets[i].getParent(j);
                    if (bayesNet.getParentSet(this.m_order[i]).contains(this.m_order[n2]) || !bayesNet.getParentSet(this.m_order[n2]).contains(this.m_order[i])) continue;
                    ++n;
                }
            }
            return n;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return 0;
        }
    }

    public static void main(String[] stringArray) {
        try {
            BIFReader bIFReader = new BIFReader();
            bIFReader.processFile(stringArray[0]);
            System.out.println(bIFReader.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

