/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;

public class ExhaustiveSearch
extends ASSearch
implements StartSetHandler,
OptionHandler {
    private int[] m_starting;
    private Range m_startRange;
    private BitSet m_bestGroup;
    private double m_bestMerit;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private boolean m_verbose;
    private boolean m_stopAfterFirst;
    private int m_evaluations;

    public String globalInfo() {
        return "ExhaustiveSearch : \n\nPerforms an exhaustive search through the space of attribute subsets starting from the empty set of attrubutes. Reports the best subset found. If a start set is supplied, the algorithm searches backward from the start point and reports the smallest subset with as good or better evaluation as the start point.\n";
    }

    public ExhaustiveSearch() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.\n\tIf a start point is supplied,\n\tExhaustive search stops after\n\tfinding the smallest possible subset\n\twith merit as good as or better than\n\tthe start set.", "P", 1, "-P <start set>"));
        vector.addElement(new Option("\tOutput subsets as the search progresses.\n\t(default = false).", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setStartSet(string);
        }
        this.setVerbose(Utils.getFlag('V', stringArray));
    }

    public String startSetTipText() {
        return "Set the start point for the search. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17.";
    }

    public void setStartSet(String string) throws Exception {
        this.m_startRange.setRanges(string);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String verboseTipText() {
        return "Print progress information. Sends progress info to the terminal as the search progresses.";
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String[] getOptions() {
        String[] stringArray = new String[3];
        int n = 0;
        if (!this.getStartSet().equals("")) {
            stringArray[n++] = "-P";
            stringArray[n++] = "" + this.startSetToString();
        }
        if (this.m_verbose) {
            stringArray[n++] = "-V";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    private String startSetToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean bl = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                stringBuffer.append(this.m_starting[i] + 1);
                bl = true;
            }
            if (i == this.m_starting.length - 1) {
                stringBuffer.append("");
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tExhaustive Search.\n\tStart set: ");
        if (this.m_starting == null) {
            stringBuffer.append("no attributes\n");
        } else {
            stringBuffer.append(this.startSetToString() + "\n");
        }
        stringBuffer.append("\tNumber of evaluations: " + this.m_evaluations + "\n");
        stringBuffer.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        return stringBuffer.toString();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        int n;
        boolean bl = false;
        this.m_numAttribs = instances.numAttributes();
        this.m_bestGroup = new BitSet(this.m_numAttribs);
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        if (aSEvaluation instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = instances.classIndex();
        }
        SubsetEvaluator subsetEvaluator = (SubsetEvaluator)aSEvaluation;
        this.m_numAttribs = instances.numAttributes();
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        if (this.m_starting != null) {
            this.m_stopAfterFirst = true;
            for (int i = 0; i < this.m_starting.length; ++i) {
                if (this.m_starting[i] == this.m_classIndex) continue;
                this.m_bestGroup.set(this.m_starting[i]);
            }
        }
        double d = subsetEvaluator.evaluateSubset(this.m_bestGroup);
        ++this.m_evaluations;
        int n2 = this.countFeatures(this.m_bestGroup);
        if (this.m_verbose && this.m_stopAfterFirst) {
            System.out.println("Initial subset (" + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup));
        }
        BitSet bitSet = new BitSet(this.m_numAttribs);
        double d2 = subsetEvaluator.evaluateSubset(bitSet);
        if (this.m_verbose) {
            System.out.println("Zero feature subset (" + Utils.doubleToString(Math.abs(d2), 8, 5) + ")");
        }
        if (d2 >= d) {
            n = this.countFeatures(bitSet);
            if (d2 > d || n < n2) {
                d = d2;
                this.m_bestGroup = (BitSet)bitSet.clone();
                n2 = n;
            }
            if (this.m_stopAfterFirst) {
                bl = true;
            }
        }
        if (!bl) {
            block1: for (int i = 1; i <= this.m_numAttribs; ++i) {
                int n3 = 0;
                bitSet = new BitSet(this.m_numAttribs);
                for (int j = 0; j < i; ++j) {
                    n3 ^= 1 << j;
                    bitSet.set(j);
                    if (!this.m_hasClass || j != this.m_classIndex) continue;
                    bitSet.clear(j);
                }
                d2 = subsetEvaluator.evaluateSubset(bitSet);
                ++this.m_evaluations;
                if (d2 >= d) {
                    n = this.countFeatures(bitSet);
                    if (d2 > d || n < n2) {
                        d = d2;
                        this.m_bestGroup = (BitSet)bitSet.clone();
                        n2 = n;
                        if (this.m_verbose) {
                            System.out.println("New best subset (" + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup));
                        }
                    }
                    if (this.m_stopAfterFirst) {
                        bl = true;
                        break;
                    }
                }
                while (n3 > 0) {
                    if ((n3 = this.generateNextSubset(n3, i, bitSet)) <= 0) continue;
                    d2 = subsetEvaluator.evaluateSubset(bitSet);
                    ++this.m_evaluations;
                    if (!(d2 >= d)) continue;
                    n = this.countFeatures(bitSet);
                    if (d2 > d || n < n2) {
                        d = d2;
                        this.m_bestGroup = (BitSet)bitSet.clone();
                        n2 = n;
                        if (this.m_verbose) {
                            System.out.println("New best subset (" + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup));
                        }
                    }
                    if (!this.m_stopAfterFirst) continue;
                    bl = true;
                    break block1;
                }
            }
        }
        this.m_bestMerit = d;
        return this.attributeList(this.m_bestGroup);
    }

    private int countFeatures(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        return n;
    }

    private String printSubset(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            stringBuffer.append(i + 1 + " ");
        }
        return stringBuffer.toString();
    }

    private int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    private int generateNextSubset(int n, int n2, BitSet bitSet) {
        int n3;
        int n4 = 0;
        boolean bl = false;
        for (n3 = 0; n3 < this.m_numAttribs; ++n3) {
            bitSet.clear(n3);
        }
        block1: while (!bl && n4 < n2) {
            for (n3 = this.m_numAttribs - 1 - n4; n3 >= 0; --n3) {
                if ((n & 1 << n3) == 0) continue;
                n ^= 1 << n3;
                if (n3 != this.m_numAttribs - 1 - n4) {
                    n ^= 1 << n3 + 1;
                    for (int i = 0; i < n4; ++i) {
                        n ^= 1 << n3 + 2 + i;
                    }
                    bl = true;
                    continue block1;
                }
                ++n4;
                continue block1;
            }
        }
        for (n3 = this.m_numAttribs - 1; n3 >= 0; --n3) {
            if ((n & 1 << n3) == 0 || n3 == this.m_classIndex) continue;
            bitSet.set(n3);
        }
        return n;
    }

    private void resetOptions() {
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_stopAfterFirst = false;
        this.m_verbose = false;
        this.m_evaluations = 0;
    }
}

