/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.spider;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class BioNLP {
    public static final String BIONLP_URI = new String("http://bionlp.stanford.edu/xmlrpc");
    public static final String SAMPLE_TEXT = new String("We observed an increase in mitogen-activated protein kinase (MAPK) activity.");

    public static void main(String[] args) {
        String text = new String();
        for (int i = 0; i < args.length; ++i) {
            text = text + " " + args[i];
        }
        if ((text = text.trim()).length() == 0) {
            text = SAMPLE_TEXT;
        }
        try {
            System.out.println("Searching text:");
            System.out.println(text);
            System.out.println();
            Vector abbreviations = BioNLP.findAbbreviations(text);
            System.out.println("I found " + abbreviations.size() + " possible abbreviation(s).");
            Enumeration e = abbreviations.elements();
            while (e.hasMoreElements()) {
                Vector data = (Vector)e.nextElement();
                System.out.println("ABBREVIATION=" + data.elementAt(1));
                System.out.println("LONG FORM=" + data.elementAt(0));
                System.out.println("SCORE=" + data.elementAt(2));
                System.out.println();
            }
            Vector names = BioNLP.findGeneAndProteinNames(text);
            System.out.println("I found " + names.size() + " possible gene or protein name(s).");
            Enumeration e2 = names.elements();
            while (e2.hasMoreElements()) {
                Vector data = (Vector)e2.nextElement();
                System.out.println("NAME=" + data.elementAt(0));
                System.out.println("SCORE=" + data.elementAt(3));
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Vector findAbbreviations(String text) throws XmlRpcException, IOException {
        XmlRpcClient server = new XmlRpcClient(BIONLP_URI);
        Vector<String> params = new Vector<String>();
        params.addElement(text);
        Vector abbreviations = (Vector)server.execute("find_abbreviations", params);
        return abbreviations;
    }

    public static Vector findGeneAndProteinNames(String text) throws XmlRpcException, IOException {
        XmlRpcClient server = new XmlRpcClient(BIONLP_URI);
        Vector<String> params = new Vector<String>();
        params.addElement(text);
        Vector names = (Vector)server.execute("find_gene_and_protein_names", params);
        return names;
    }
}

