/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.neoref.config.Config;
import org.neoref.core.DC;
import org.neoref.query.NRQuery;
import org.neoref.query.QueryArgs;
import org.neoref.query.QueryResults;

public class Meta {
    private static Logger log = Logger.getLogger((Class)(class$org$neoref$core$Meta == null ? (class$org$neoref$core$Meta = Meta.class$("org.neoref.core.Meta")) : class$org$neoref$core$Meta));
    private static Connection conn = null;
    private static Statement st = null;
    public static int STEP = 1000;
    private static ResultSet rs;
    static /* synthetic */ Class class$org$neoref$core$Meta;

    public static boolean getConnected() {
        if (st != null && conn != null) {
            return true;
        }
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            conn = DriverManager.getConnection(Config.SEARCHDB_STR);
            st = conn.createStatement();
        }
        catch (Exception e) {
            System.out.println("Error:" + e.getMessage());
            return false;
        }
        return true;
    }

    public static void close() {
        if (st == null && conn == null) {
            return;
        }
        try {
            st.close();
            conn.close();
        }
        catch (Exception e) {
            System.out.println("Error:" + e.getMessage());
        }
    }

    public static int getStarted() throws SQLException {
        if (Meta.getConnected() && (rs = st.executeQuery("select nextID from parsedTable where name='Metadata';")).next()) {
            return rs.getInt(1);
        }
        return -1;
    }

    public static boolean updateStart(int val) throws SQLException {
        int re;
        return Meta.getConnected() && (re = st.executeUpdate("update parsedTable set nextID=" + val + " where name='Metadata';")) == 1;
    }

    public static int getLast() throws SQLException {
        if (Meta.getConnected() && (rs = st.executeQuery("select max(id) from metadata;")).next()) {
            return rs.getInt(1);
        }
        return -1;
    }

    public static List getRecords(int start) throws SQLException {
        int end = start + DC.STEP;
        ArrayList<DC> meta = new ArrayList<DC>();
        if (Meta.getConnected()) {
            rs = st.executeQuery("select id,title,subject,creator,source,description,relation,contributor,format,identifier,language,coverage,rights,publisher,date,type from metadata where id>=" + start + " and id<" + end + ";");
            while (rs.next()) {
                DC dc = new DC();
                dc.value = new ArrayList();
                for (int i = 0; i < DC.DCN; ++i) {
                    dc.value.add(i, rs.getString(i + 1));
                }
                meta.add(dc);
            }
        }
        return meta;
    }

    public static List getRecordsFT(int start) throws SQLException {
        int end = start + DC.STEP;
        int j = 0;
        ArrayList<DC> meta = new ArrayList<DC>();
        System.out.println("billy: start is " + start);
        if (Meta.getConnected()) {
            rs = st.executeQuery("select id,title,subject,creator,source,description,relation,contributor,format,identifier,language,coverage,rights,publisher,date,type,fulltxt,mesh from metadata where id>=" + start + " and id<" + end + ";");
            while (rs.next()) {
                DC dc = new DC();
                dc.value = new ArrayList();
                for (int i = 0; i < DC.DCN_FT; ++i) {
                    dc.value.add(i, rs.getString(i + 1));
                }
                meta.add(dc);
                if (++j <= Config.GC_THRESHOLD) continue;
                System.gc();
                j = 0;
            }
        }
        return meta;
    }

    public static Hashtable meshView(List res, int cutoff) throws SQLException {
        int maxCnt = 0;
        Hashtable<String, Vector<String>> idTable = new Hashtable<String, Vector<String>>();
        int size = res.size();
        if (!Meta.getConnected()) {
            return null;
        }
        System.out.println("Total no. of hits: " + size);
        for (int i = 0; i < size; ++i) {
            String mesh;
            String idStr = (String)res.get(i);
            rs = st.executeQuery("select mesh from metadata where id=" + idStr + ";");
            if (!rs.next() || (mesh = rs.getString("mesh")) == null) continue;
            StringTokenizer st1 = new StringTokenizer(mesh, "|");
            while (st1.hasMoreTokens()) {
                Vector<String> idVec;
                StringTokenizer st2;
                String entry = st1.nextToken();
                if (entry.length() == 0 || !(st2 = new StringTokenizer(entry, "!")).hasMoreTokens()) continue;
                String term = st2.nextToken();
                term = term.substring(0, term.length() - 3);
                if (cutoff != 0) {
                    int j;
                    String path;
                    rs = st.executeQuery("select path from meshtree where term='" + term + "';");
                    if (!rs.next() || (path = rs.getString("path")) == null) continue;
                    int idx = 0;
                    int cnt = 0;
                    while ((idx = path.indexOf(".", idx)) != -1) {
                        ++cnt;
                        ++idx;
                    }
                    if (cnt > maxCnt) {
                        maxCnt = cnt;
                    }
                    if (cutoff > 0) {
                        idx = 0;
                        for (j = 0; j < cutoff && idx != -1; ++j) {
                            idx = path.indexOf(".", idx + 1);
                        }
                    } else {
                        idx = path.length();
                        for (j = 0; j > cutoff && idx != -1; --j) {
                            idx = path.lastIndexOf(".", idx - 1);
                        }
                    }
                    if (idx == -1) continue;
                    path = path.substring(0, idx);
                    rs = st.executeQuery("select term from meshtree where path='" + path + "';");
                    if (!rs.next()) continue;
                    term = rs.getString("term");
                }
                if (idTable.containsKey(term)) {
                    idVec = (Vector<String>)idTable.get(term);
                    if (!idVec.contains(idStr)) {
                        idVec.add(idStr);
                        idTable.put(term, idVec);
                    }
                } else {
                    idVec = new Vector<String>();
                    idVec.add(idStr);
                    idTable.put(term, idVec);
                }
                idVec = new Vector<String>();
                idVec.add((String)((Object)new Integer(maxCnt)));
                idTable.put("neoref", idVec);
            }
        }
        return idTable;
    }

    public static DC getRecord(int id) throws SQLException {
        DC dc = new DC();
        dc.value = new ArrayList();
        if (Meta.getConnected() && (rs = st.executeQuery("select id,title,subject,creator,source,description,relation,contributor,format,identifier,language,coverage,rights,publisher,date,type from metadata where id=" + id + ";")).next()) {
            for (int i = 0; i < DC.DCN; ++i) {
                dc.value.add(i, rs.getString(i + 1));
            }
        }
        return dc;
    }

    public static DC getRecordFT(int id) throws SQLException {
        DC dc = new DC();
        dc.value = new ArrayList();
        if (Meta.getConnected() && (rs = st.executeQuery("select id,title,subject,creator,source,description,relation,contributor,format,identifier,language,coverage,rights,publisher,date,type,fulltxt,mesh from metadata where id=" + id + ";")).next()) {
            for (int i = 0; i < DC.DCN_FT; ++i) {
                dc.value.add(i, rs.getString(i + 1));
            }
        }
        return dc;
    }

    public static void main(String[] args) throws Exception {
        QueryResults qResults = null;
        QueryArgs qArgs = new QueryArgs();
        String[] qArray = new String[DC.DCN_FT];
        DC.init();
        if (args.length < 2) {
            System.out.println("Usage: meta search_string level");
            System.out.println("level: cutoff level w/ directions indicated by signs");
            System.out.println("e.g., meta akt1 2");
            System.exit(-1);
        }
        int cutoff = Integer.valueOf(args[1]);
        qArray[0] = "((" + DC.dcName[0].toLowerCase() + ":" + args[0] + ")";
        for (int i = 1; i < DC.DCN_FT; ++i) {
            qArray[0] = qArray[0] + " OR (" + DC.dcName[i].toLowerCase() + ":" + args[0] + ")";
        }
        qArray[0] = qArray[0] + ")";
        qArgs.setQuery(qArray[0]);
        qArgs.setStart(0);
        qResults = NRQuery.doQuery(qArgs, false);
        List res = qResults.getAllHitIDs();
        Hashtable idTable = Meta.meshView(res, cutoff);
        System.out.println(idTable.toString());
        Enumeration cluster = idTable.keys();
        while (cluster.hasMoreElements()) {
            String name = (String)cluster.nextElement();
            int size = ((Vector)idTable.get(name)).size();
            System.out.println(name + " (" + size + ") ");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

