/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.core;

import java.util.List;
import java.util.StringTokenizer;

public class DC {
    public static int DCN = 16;
    public static int DCN_FT = 18;
    public static int DC_ID = 0;
    public static int DC_TITLE = 1;
    public static int DC_SUBJECT = 2;
    public static int DC_CREATOR = 3;
    public static int DC_SOURCE = 4;
    public static int DC_DESCRIPTION = 5;
    public static int DC_RELATION = 6;
    public static int DC_CONTRIBUTOR = 7;
    public static int DC_FORMAT = 8;
    public static int DC_IDENTIFIER = 9;
    public static int DC_LANGUAGE = 10;
    public static int DC_COVERAGE = 11;
    public static int DC_RIGHTS = 12;
    public static int DC_PUBLISHER = 13;
    public static int DC_DATE = 14;
    public static int DC_TYPE = 15;
    public static int DC_FULLTXT = 16;
    public static int DC_MESH = 17;
    public static int MAXLEN = 500;
    public static final String[] dcName = new String[DCN_FT];
    public static int STEP = 1000;
    public List value;

    public static void init() {
        DC.dcName[0] = "Id";
        DC.dcName[1] = "Title";
        DC.dcName[2] = "Subject";
        DC.dcName[3] = "Creator";
        DC.dcName[4] = "Source";
        DC.dcName[5] = "Description";
        DC.dcName[6] = "Relation";
        DC.dcName[7] = "Contributor";
        DC.dcName[8] = "Format";
        DC.dcName[9] = "Identifier";
        DC.dcName[10] = "Language";
        DC.dcName[11] = "Coverage";
        DC.dcName[12] = "Rights";
        DC.dcName[13] = "Publisher";
        DC.dcName[14] = "Date";
        DC.dcName[15] = "Type";
        DC.dcName[16] = "Fulltxt";
        DC.dcName[17] = "Mesh";
    }

    public String shrinkFullTxt(String queryStr) {
        int pos = 0;
        StringTokenizer st1 = null;
        String fulltxt = (String)this.value.get(DC_FULLTXT);
        if (fulltxt == null) {
            return "";
        }
        String fulltxt_lo = fulltxt.toLowerCase();
        int len = fulltxt.length();
        if (queryStr != null) {
            if ((queryStr = queryStr.toLowerCase()).startsWith("(") && queryStr.endsWith(")")) {
                queryStr = queryStr.substring(1, queryStr.length() - 1);
            }
            if (queryStr.indexOf(" or ") != -1) {
                st1 = new StringTokenizer(queryStr, " or ");
            } else if (queryStr.indexOf(" AND ") != -1) {
                st1 = new StringTokenizer(queryStr, " and ");
            } else if (queryStr.indexOf(" ") != -1) {
                st1 = new StringTokenizer(queryStr, " ");
            }
            if (st1 != null) {
                while (st1.hasMoreTokens()) {
                    StringTokenizer st2;
                    String temp = st1.nextToken();
                    if ((temp = temp.toLowerCase()).startsWith("+") || temp.startsWith("-")) {
                        temp = temp.substring(1, temp.length() - 1);
                    }
                    if ((st2 = new StringTokenizer(temp, "\"")).hasMoreTokens()) {
                        pos = fulltxt_lo.indexOf(st2.nextToken());
                    }
                    if (pos == -1) continue;
                    break;
                }
            } else {
                StringTokenizer st2 = new StringTokenizer(queryStr, "\"");
                if (st2.hasMoreTokens()) {
                    pos = fulltxt_lo.indexOf(st2.nextToken());
                }
            }
        }
        if (pos < 0 || pos > len) {
            pos = 0;
        }
        int last = Math.min(len, pos + MAXLEN);
        return fulltxt.substring(pos, last);
    }

    public String formatMesh(String meshStr, boolean majorOn) {
        String temp = "";
        StringTokenizer st1 = new StringTokenizer(meshStr, "|");
        while (st1.hasMoreTokens()) {
            String term;
            String entry = st1.nextToken();
            if (entry.length() == 0) continue;
            StringTokenizer st2 = new StringTokenizer(entry, "!");
            if (st2.hasMoreTokens()) {
                term = st2.nextToken();
                if (majorOn) {
                    term = term.substring(0, term.length() - 3);
                }
                temp = temp + " -- " + term;
            }
            if (st2.hasMoreTokens()) {
                term = st2.nextToken();
                StringTokenizer st3 = new StringTokenizer(term, ":");
                while (st3.hasMoreTokens()) {
                    term = st3.nextToken();
                    if (majorOn) {
                        term = term.substring(0, term.length() - 3);
                    }
                    temp = temp + " -- " + term;
                }
            }
            temp = temp + " ";
        }
        return temp;
    }
}

