/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.getopt.luke.Luke;
import org.getopt.luke.LukePlugin;

public class AnalyzerToolPlugin
extends LukePlugin {
    public String getXULName() {
        return "/xml/at-plugin.xml";
    }

    public String getPluginName() {
        return "AnalyzerTool";
    }

    public String getPluginInfo() {
        return "Tool for analyzing analyzers, by Mark Harwood";
    }

    public String getPluginHome() {
        return "mailto:mharwood@apache.org";
    }

    public void setMyUi(Object object) {
        super.setMyUi(object);
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean init() throws Exception {
        Object object = this.app.find(this.myUi, "analyzers");
        this.app.removeAll(object);
        String string = "";
        Class[] classArray = this.app.getAnalyzers();
        for (int i = 0; i < classArray.length; ++i) {
            Object object2 = Luke.create("choice");
            this.app.setString(object2, "text", classArray[i].getName());
            if (i == 0) {
                string = classArray[i].getName();
            }
            this.app.add(object, object2);
        }
        this.app.setInteger(object, "selected", 0);
        this.app.setString(object, "text", string);
        return true;
    }

    public void analyze() {
        this.showError("");
        try {
            Object object = this.app.find(this.myUi, "analyzers");
            Object object2 = this.app.find(this.myUi, "resultsList");
            Object object3 = this.app.find(this.myUi, "inputText");
            Object object4 = this.app.find(this.myUi, "outputText");
            String string = this.app.getString(object, "text");
            Class<?> clazz = Class.forName(string);
            Analyzer analyzer = null;
            try {
                analyzer = (Analyzer)clazz.newInstance();
            }
            catch (Throwable throwable) {
                this.showError("Couldn't instantiate analyzer - public zero-argument constructor required");
                return;
            }
            this.app.setString(object4, "text", this.app.getString(object3, "text"));
            TokenStream tokenStream = analyzer.tokenStream((Reader)new StringReader(this.app.getString(object3, "text")));
            Token token = tokenStream.next();
            this.app.removeAll(object2);
            while (token != null) {
                Object object5 = Luke.create("item");
                this.app.setString(object5, "text", token.termText());
                this.app.add(object2, object5);
                this.app.putProperty(object5, "data", token);
                token = tokenStream.next();
            }
        }
        catch (Throwable throwable) {
            this.showError("Error analyzing:" + throwable.getMessage());
        }
    }

    public void tokenChange() {
        Object object = this.app.find("resultsList");
        Object object2 = this.app.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        Token token = (Token)this.app.getProperty(object2, "data");
        Object object3 = this.app.find("outputText");
        this.app.setInteger(object3, "start", 0);
        this.app.setInteger(object3, "end", token.endOffset());
        this.app.setInteger(object3, "start", token.startOffset());
        this.app.requestFocus(object3);
    }

    public void showError(String string) {
        Object object = this.app.find("errorLabel");
        this.app.setString(object, "text", string);
    }
}

