/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.getopt.luke.BrowserLauncher;
import org.getopt.luke.ClassFinder;
import org.getopt.luke.GrowableStringArray;
import org.getopt.luke.HighFreqTerms;
import org.getopt.luke.IntPair;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.Prefs;
import org.getopt.luke.TermInfo;
import thinlet.FrameLauncher;
import thinlet.Thinlet;

public class Luke
extends Thinlet
implements ClipboardOwner {
    private FSDirectory dir = null;
    private String pName = null;
    private IndexReader ir = null;
    private Collection fn = null;
    private String[] idxFields = null;
    private List plugins = new ArrayList();
    private Object error = null;
    private Object statmsg = null;
    private Analyzer stdAnalyzer = new StandardAnalyzer();
    private Analyzer analyzer = null;
    private QueryParser qp = null;
    private boolean readOnly = false;
    private boolean useCompound = false;
    private int numTerms = 0;
    private Class[] analyzers = null;
    private Class[] defaultAnalyzers = new Class[]{class$org$apache$lucene$analysis$de$GermanAnalyzer == null ? (class$org$apache$lucene$analysis$de$GermanAnalyzer = Luke.class$("org.apache.lucene.analysis.de.GermanAnalyzer")) : class$org$apache$lucene$analysis$de$GermanAnalyzer, class$org$apache$lucene$analysis$ru$RussianAnalyzer == null ? (class$org$apache$lucene$analysis$ru$RussianAnalyzer = Luke.class$("org.apache.lucene.analysis.ru.RussianAnalyzer")) : class$org$apache$lucene$analysis$ru$RussianAnalyzer, class$org$apache$lucene$analysis$SimpleAnalyzer == null ? (class$org$apache$lucene$analysis$SimpleAnalyzer = Luke.class$("org.apache.lucene.analysis.SimpleAnalyzer")) : class$org$apache$lucene$analysis$SimpleAnalyzer, class$org$apache$lucene$analysis$standard$StandardAnalyzer == null ? (class$org$apache$lucene$analysis$standard$StandardAnalyzer = Luke.class$("org.apache.lucene.analysis.standard.StandardAnalyzer")) : class$org$apache$lucene$analysis$standard$StandardAnalyzer, class$org$apache$lucene$analysis$StopAnalyzer == null ? (class$org$apache$lucene$analysis$StopAnalyzer = Luke.class$("org.apache.lucene.analysis.StopAnalyzer")) : class$org$apache$lucene$analysis$StopAnalyzer, class$org$apache$lucene$analysis$WhitespaceAnalyzer == null ? (class$org$apache$lucene$analysis$WhitespaceAnalyzer = Luke.class$("org.apache.lucene.analysis.WhitespaceAnalyzer")) : class$org$apache$lucene$analysis$WhitespaceAnalyzer};
    private static final String MSG_NOINDEX = "FAILED: No index, or index is closed. Reopen it.";
    private static final String MSG_READONLY = "FAILED: Read-Only index.";
    private String SEP_CHAR = System.getProperty("file.separator");
    private DecimalFormat df = new DecimalFormat("0.0000");
    static /* synthetic */ Class class$org$apache$lucene$analysis$de$GermanAnalyzer;
    static /* synthetic */ Class class$org$apache$lucene$analysis$ru$RussianAnalyzer;
    static /* synthetic */ Class class$org$apache$lucene$analysis$SimpleAnalyzer;
    static /* synthetic */ Class class$org$apache$lucene$analysis$standard$StandardAnalyzer;
    static /* synthetic */ Class class$org$apache$lucene$analysis$StopAnalyzer;
    static /* synthetic */ Class class$org$apache$lucene$analysis$WhitespaceAnalyzer;
    static /* synthetic */ Class class$org$apache$lucene$analysis$Analyzer;
    static /* synthetic */ Class class$org$getopt$luke$LukePlugin;
    static /* synthetic */ Class class$thinlet$Thinlet;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$org$getopt$luke$Luke;

    public Luke() {
        Prefs.load();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setColors(15526360, 0, 16119024, 9542554, 0xB0B0B0, 0xEDEDED, 0xB9B9B9, 16746906, 0xC5C5DD);
        this.addComponent(this, "/xml/luke.xml", null, null);
        this.error = this.addComponent(null, "/xml/error.xml", null, null);
        this.statmsg = this.find("statmsg");
        try {
            this.analyzers = ClassFinder.getInstantiableSubclasses(class$org$apache$lucene$analysis$Analyzer == null ? (class$org$apache$lucene$analysis$Analyzer = Luke.class$("org.apache.lucene.analysis.Analyzer")) : class$org$apache$lucene$analysis$Analyzer);
            if (this.analyzers == null || this.analyzers.length == 0) {
                this.analyzers = this.defaultAnalyzers;
            }
            Object object = this.find("cbType");
            this.populateAnalyzers(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.loadPlugins();
        this.actionOpen();
    }

    public void populateAnalyzers(Object object) {
        int n;
        this.removeAll(object);
        Object[] objectArray = new String[this.analyzers.length];
        for (n = 0; n < this.analyzers.length; ++n) {
            objectArray[n] = this.analyzers[n].getName();
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            Object object2 = Luke.create("choice");
            this.setString(object2, "text", (String)objectArray[n]);
            this.add(object, object2);
        }
    }

    public Class[] getAnalyzers() {
        return this.analyzers;
    }

    private void loadPlugins() {
        Class<?> clazz;
        String string;
        Object object;
        Object object2;
        ArrayList arrayList = new ArrayList();
        try {
            object2 = ClassFinder.getInstantiableSubclasses(class$org$getopt$luke$LukePlugin == null ? (class$org$getopt$luke$LukePlugin = Luke.class$("org.getopt.luke.LukePlugin")) : class$org$getopt$luke$LukePlugin);
            if (object2 != null && ((Class[])object2).length > 0) {
                arrayList.addAll(Arrays.asList(object2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object2 = this.getClass().getResourceAsStream("/.plugins");
            if (object2 != null) {
                object = new BufferedReader(new InputStreamReader((InputStream)object2));
                string = null;
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    if (string.startsWith("#") || string.trim().equals("")) continue;
                    try {
                        clazz = Class.forName(string);
                        if (!clazz.getSuperclass().equals(class$org$getopt$luke$LukePlugin == null ? Luke.class$("org.getopt.luke.LukePlugin") : class$org$getopt$luke$LukePlugin) || arrayList.contains(clazz)) continue;
                        arrayList.add(clazz);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    object = (LukePlugin)((Class)arrayList.get(i)).getConstructor(new Class[0]).newInstance(new Object[0]);
                    string = ((LukePlugin)object).getXULName();
                    if (string == null) continue;
                    clazz = this.parse(string, object);
                    ((LukePlugin)object).setApplication(this);
                    ((LukePlugin)object).setMyUi(clazz);
                    this.plugins.add(object);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.plugins.size() == 0) {
            return;
        }
        this.initPlugins();
    }

    public void addPluginTab(Object object, LukePlugin lukePlugin) {
        Object object2 = Luke.create("tab");
        this.setColor(object2, "foreground", new Color(24576));
        this.setString(object2, "text", lukePlugin.getPluginName());
        this.setFont(object2, this.getFont().deriveFont(1));
        this.add(object, object2);
        Object object3 = Luke.create("panel");
        this.setInteger(object3, "gap", 2);
        this.setInteger(object3, "weightx", 1);
        this.setInteger(object3, "weighty", 1);
        this.setChoice(object3, "halign", "fill");
        this.setChoice(object3, "valign", "fill");
        this.setInteger(object3, "columns", 1);
        this.add(object2, object3);
        Object object4 = Luke.create("panel");
        this.setInteger(object4, "gap", 8);
        this.setInteger(object4, "top", 2);
        this.setInteger(object4, "bottom", 2);
        this.setInteger(object4, "weightx", 1);
        this.setChoice(object4, "halign", "fill");
        this.setColor(object4, "background", new Color(0xC0F0C0));
        this.add(object3, object4);
        Object object5 = Luke.create("label");
        this.setString(object5, "text", lukePlugin.getPluginInfo());
        this.add(object4, object5);
        Object object6 = Luke.create("button");
        this.setChoice(object6, "type", "link");
        this.setString(object6, "text", lukePlugin.getPluginHome());
        this.putProperty(object6, "url", lukePlugin.getPluginHome());
        this.setMethod(object6, "action", "goUrl(this)", object4, this);
        this.add(object4, object6);
        this.add(object3, Luke.create("separator"));
        this.add(object3, lukePlugin.getMyUi());
    }

    private void showStatus(final String string) {
        Thread thread = new Thread(){

            public void run() {
                Luke.this.setString(Luke.this.statmsg, "text", string);
                try {
                    1.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Luke.this.setString(Luke.this.statmsg, "text", "");
            }
        };
        thread.start();
    }

    public Object addComponent(Object object, String string, String string2, Object[] objectArray) {
        Object object2 = null;
        Object var6_6 = null;
        try {
            if (string2 != null) {
                var6_6 = objectArray == null ? Class.forName(string2).getConstructor(class$thinlet$Thinlet == null ? (class$thinlet$Thinlet = Luke.class$("thinlet.Thinlet")) : class$thinlet$Thinlet).newInstance(this) : Class.forName(string2).getConstructor(class$thinlet$Thinlet == null ? (class$thinlet$Thinlet = Luke.class$("thinlet.Thinlet")) : class$thinlet$Thinlet, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = Luke.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object).newInstance(this, objectArray);
            }
            object2 = var6_6 != null ? this.parse(string, var6_6) : this.parse(string);
            if (object != null) {
                if (object instanceof Thinlet) {
                    this.add(object2);
                } else {
                    this.add(object, object2);
                }
            }
            return object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
            return null;
        }
    }

    public void errorMsg(String string) {
        System.out.println(string);
        Object object = this.find(this.error, "msg");
        this.setString(object, "text", string);
        this.add(this.error);
    }

    public void actionOpen() {
        this.addComponent(this, "/xml/lukeinit.xml", null, null);
    }

    public void openBrowse(Object object) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle("Select Index directory");
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileHidingEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        File file = null;
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        if (file != null && file.exists()) {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            this.setString(object, "text", file.toString());
        }
    }

    public void setupInit(Object object) {
        Object object2 = this.find(object, "path");
        this.syncMRU(object2);
    }

    public void openOk(Object object) {
        Object object2 = this.find(object, "path");
        this.pName = this.getString(object2, "text").trim();
        boolean bl = this.getBoolean(this.find(object, "force"), "selected");
        if (this.pName == null || this.pName.trim().equals("") || !IndexReader.indexExists((String)this.pName)) {
            this.errorMsg("Invalid path, or not a Lucene index.");
            return;
        }
        this.readOnly = this.getBoolean(this.find(object, "ro"), "selected");
        this.remove(object);
        this.removeAll();
        this.addComponent(this, "/xml/luke.xml", null, null);
        if (this.dir != null) {
            try {
                if (this.ir != null) {
                    this.ir.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dir.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Prefs.addToMruList(this.pName);
            this.syncMRU(object2);
            this.dir = FSDirectory.getDirectory((String)this.pName, (boolean)false);
            if (IndexReader.isLocked((Directory)this.dir)) {
                if (this.readOnly) {
                    this.showStatus("Index is locked and Read-Only. Open for read-write and 'Force unlock'.");
                    this.dir.close();
                    return;
                }
                if (bl) {
                    IndexReader.unlock((Directory)this.dir);
                } else {
                    this.showStatus("Index is locked. Try 'Force unlock' when opening.");
                    this.dir.close();
                    return;
                }
            }
            this.showFiles(this.dir);
            Object object3 = this.find("iFileSize");
            BigInteger bigInteger = this.calcTotalFileSize(this.pName, this.dir);
            this.setString(object3, "text", this.normalizeSize(bigInteger) + this.normalizeUnit(bigInteger));
            System.out.println(this.dir);
            this.ir = IndexReader.open((Directory)this.dir);
            this.initOverview();
            this.initPlugins();
            this.showStatus("Index successfully open.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
            return;
        }
    }

    private void initPlugins() {
        Object object = this.find("pluginsTabs");
        this.removeAll(object);
        for (int i = 0; i < this.plugins.size(); ++i) {
            LukePlugin lukePlugin = (LukePlugin)this.plugins.get(i);
            this.addPluginTab(object, lukePlugin);
            lukePlugin.setDirectory((Directory)this.dir);
            lukePlugin.setIndexReader(this.ir);
            try {
                lukePlugin.init();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.showStatus("PLUGIN ERROR: " + exception.getMessage());
            }
        }
    }

    private void initOverview() {
        try {
            String string;
            Object object;
            Object object2 = this.find("cbType");
            this.populateAnalyzers(object2);
            Object object3 = this.find("cbUseCompound");
            this.setBoolean(object3, "selected", Prefs.getBoolean("luke.use_compound", true));
            Object object4 = this.find("pOver");
            Object object5 = this.find("idx");
            this.setString(object5, "text", this.pName + (this.readOnly ? " (R)" : ""));
            object5 = this.find(object4, "iName");
            this.setString(object5, "text", this.pName + (this.readOnly ? " (Read-Only)" : ""));
            Object object6 = this.find(object4, "iDocs");
            String string2 = String.valueOf(this.ir.numDocs());
            this.setString(object6, "text", string2);
            object6 = this.find("iDocs1");
            this.setString(object6, "text", String.valueOf(this.ir.numDocs() - 1));
            Object object7 = this.find(object4, "iFields");
            this.fn = this.ir.getFieldNames();
            this.idxFields = new String[this.fn.size()];
            this.setString(object7, "text", String.valueOf(this.fn.size()));
            Object object8 = this.find(object4, "fList");
            Object object9 = this.find("defFld");
            Object object10 = this.find("fCombo");
            Iterator iterator = this.fn.iterator();
            int n = 0;
            this.removeAll(object8);
            this.removeAll(object10);
            while (iterator.hasNext()) {
                object = Luke.create("item");
                this.add(object8, object);
                string = (String)iterator.next();
                this.setString(object, "text", "<" + string + ">");
                this.putProperty(object, "fName", string);
                object = Luke.create("choice");
                this.add(object9, object);
                this.setString(object, "text", string);
                object = Luke.create("choice");
                this.add(object10, object);
                this.setString(object, "text", string);
                this.putProperty(object, "fName", string);
                this.idxFields[n++] = string;
            }
            this.setString(object9, "text", this.idxFields[0]);
            object = this.find(object4, "iTerms");
            string = this.ir.terms();
            this.numTerms = 0;
            while (string.next()) {
                ++this.numTerms;
            }
            string.close();
            this.setString(object, "text", String.valueOf(this.numTerms));
            Object object11 = this.find(object4, "iMod");
            this.setString(object11, "text", new Date(IndexReader.lastModified((Directory)this.dir)).toString());
            Object object12 = this.find(object4, "iVer");
            this.setString(object12, "text", String.valueOf(IndexReader.getCurrentVersion((Directory)this.dir)));
            Object object13 = this.find(object4, "iDel");
            this.setString(object13, "text", this.ir.hasDeletions() ? "Yes" : "No");
            this.setString(this.find("defFld"), "text", this.idxFields[0]);
            Object object14 = Luke.get(this.find("sTable"), "header");
            Object object15 = Luke.get(object14, ":comp");
            Object object16 = object15 = Luke.get(object15, ":next");
            Object object17 = Luke.get(object15, ":next");
            while (object17 != null) {
                Luke.set(object15, ":next", null);
                object15 = object17;
                object17 = Luke.get(object15, ":next");
            }
            for (int i = 0; i < this.idxFields.length; ++i) {
                Object object18 = Luke.create("column");
                this.setString(object18, "text", this.idxFields[i]);
                Luke.set(object16, ":next", object18);
                object16 = object18;
            }
            this.actionTopTerms(this.find("nTerms"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
        }
    }

    public void showFiles(FSDirectory fSDirectory) throws Exception {
        String[] stringArray = fSDirectory.list();
        Object object = this.find("filesTable");
        this.removeAll(object);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.pName.endsWith(this.SEP_CHAR) ? this.pName : this.pName + this.SEP_CHAR;
            File file = new File(string + stringArray[i]);
            Object object2 = Luke.create("row");
            Object object3 = Luke.create("cell");
            this.setString(object3, "text", stringArray[i]);
            this.add(object2, object3);
            Object object4 = Luke.create("cell");
            this.setString(object4, "text", this.normalizeSize(file.length()));
            this.add(object2, object4);
            Object object5 = Luke.create("cell");
            this.setString(object5, "text", this.normalizeUnit(file.length()));
            this.add(object2, object5);
            this.add(object, object2);
        }
    }

    private void syncMRU(Object object) {
        this.removeAll(object);
        Iterator iterator = Prefs.getMruList().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object2 = Luke.create("choice");
            this.setString(object2, "text", string);
            this.add(object, object2);
        }
    }

    private String normalizeUnit(long l) {
        if (l == 1L) {
            return " byte";
        }
        if (l < 1024L) {
            return " bytes";
        }
        if (l < 51200000L) {
            return " kB";
        }
        return " MB";
    }

    private String normalizeUnit(BigInteger bigInteger) {
        if (bigInteger.compareTo(new BigInteger("1")) == 0) {
            return " byte";
        }
        if (bigInteger.compareTo(new BigInteger("1024")) == -1) {
            return " bytes";
        }
        if (bigInteger.compareTo(new BigInteger("51200000")) == -1) {
            return " kB";
        }
        return " MB";
    }

    private String normalizeSize(BigInteger bigInteger) {
        if (bigInteger.compareTo(new BigInteger("1")) == 0) {
            return bigInteger.toString();
        }
        if (bigInteger.compareTo(new BigInteger("1024")) == -1) {
            return bigInteger.toString();
        }
        if (bigInteger.compareTo(new BigInteger("51200000")) == -1) {
            return bigInteger.divide(new BigInteger("1024")).toString();
        }
        return bigInteger.divide(new BigInteger("102400")).toString();
    }

    private BigInteger calcTotalFileSize(String string, FSDirectory fSDirectory) {
        BigInteger bigInteger = new BigInteger("0");
        try {
            String[] stringArray = fSDirectory.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = this.pName.endsWith(this.SEP_CHAR) ? this.pName : this.pName + this.SEP_CHAR;
                File file = new File(string2 + stringArray[i]);
                bigInteger = bigInteger.add(new BigInteger(file.length() + ""));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bigInteger;
    }

    private String normalizeSize(long l) {
        if (l == 1L) {
            return l + "";
        }
        if (l < 1024L) {
            return l + "";
        }
        if (l < 51200000L) {
            return l / 1024L + "";
        }
        return l / 102400L + "";
    }

    public void actionTopTerms(Object object) {
        String string = this.getString(object, "text");
        int n = 50;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("nTerms=" + n);
        Object[] objectArray = this.getSelectedItems(this.find("fList"));
        String[] stringArray = null;
        if (objectArray == null || objectArray.length == 0) {
            stringArray = this.idxFields;
        } else {
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)this.getProperty(objectArray[i], "fName");
                System.out.println(" - " + stringArray[i]);
            }
        }
        try {
            TermInfo[] termInfoArray = HighFreqTerms.getHighFreqTerms((Directory)this.dir, null, n, stringArray);
            Object object2 = this.find("tTable");
            this.removeAll(object2);
            if (termInfoArray == null || termInfoArray.length == 0) {
                System.out.println("tis=" + termInfoArray + " (no results)");
                Object object3 = Luke.create("row");
                Object object4 = Luke.create("cell");
                this.add(object3, object4);
                object4 = Luke.create("cell");
                this.add(object3, object4);
                object4 = Luke.create("cell");
                this.add(object3, object4);
                object4 = Luke.create("cell");
                this.setBoolean(object4, "enabled", false);
                this.setString(object4, "text", "No Results");
                this.add(object3, object4);
                this.add(object2, object3);
                return;
            }
            for (int i = 0; i < termInfoArray.length; ++i) {
                Object object5 = Luke.create("row");
                this.add(object2, object5);
                this.putProperty(object5, "term", termInfoArray[i].term);
                Object object6 = Luke.create("cell");
                this.setChoice(object6, "alignment", "right");
                this.setString(object6, "text", String.valueOf(i + 1));
                this.add(object5, object6);
                object6 = Luke.create("cell");
                this.setChoice(object6, "alignment", "right");
                this.setString(object6, "text", String.valueOf(termInfoArray[i].docFreq) + "  ");
                this.add(object5, object6);
                object6 = Luke.create("cell");
                this.setString(object6, "text", " <" + termInfoArray[i].term.field() + "> ");
                this.add(object5, object6);
                object6 = Luke.create("cell");
                this.setString(object6, "text", "  " + termInfoArray[i].term.text());
                this.add(object5, object6);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
        }
    }

    public void browseTermDocs(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        Term term = (Term)this.getProperty(object2, "term");
        if (term == null) {
            return;
        }
        Object object3 = this.find("maintpane");
        this.setInteger(object3, "selected", 1);
        this._showTerm(this.find("fCombo"), this.find("fText"), term);
        this.repaint();
    }

    public void showTermDocs(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        Term term = (Term)this.getProperty(object2, "term");
        if (term == null) {
            return;
        }
        Object object3 = this.find("maintpane");
        this.setInteger(object3, "selected", 2);
        Object object4 = this.find("qField");
        this.setString(object4, "text", term.field() + ":" + term.text());
        this.search(object4);
        this.repaint();
    }

    public void actionUseCompound(Object object) {
        this.useCompound = this.getBoolean(object, "selected");
        Prefs.setProperty("luke.use_compound", Boolean.toString(this.useCompound));
    }

    public void actionUndelete() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            this.ir.undeleteAll();
            this.initOverview();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
        }
    }

    public void actionOptimize() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            this.ir.close();
            IndexWriter indexWriter = new IndexWriter((Directory)this.dir, (Analyzer)new WhitespaceAnalyzer(), false);
            indexWriter.setUseCompoundFile(this.useCompound);
            BigInteger bigInteger = this.calcTotalFileSize(this.pName, this.dir);
            long l = System.currentTimeMillis();
            indexWriter.optimize();
            long l2 = System.currentTimeMillis();
            BigInteger bigInteger2 = this.calcTotalFileSize(this.pName, this.dir);
            BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
            String string = bigInteger3.compareTo(new BigInteger("0")) < 0 ? " Increased " : " Reduced ";
            String string2 = string + this.normalizeSize(bigInteger3.abs()) + this.normalizeUnit(bigInteger3.abs());
            String string3 = String.valueOf(l2 - l) + " ms";
            this.showStatus(string2 + " in " + string3);
            this.showFiles(this.dir);
            indexWriter.close();
            this.ir = IndexReader.open((Directory)this.dir);
            this.initOverview();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void showPrevDoc(Object object) {
        this._showDoc(object, -1);
    }

    public void showNextDoc(Object object) {
        this._showDoc(object, 1);
    }

    public void showDoc(Object object) {
        this._showDoc(object, 0);
    }

    private void _showDoc(Object object, int n) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        String string = this.getString(object, "text");
        if (string.trim().equals("")) {
            string = String.valueOf(-n);
        }
        try {
            int n2 = Integer.parseInt(string);
            if ((n2 += n) < 0 || n2 >= this.ir.numDocs()) {
                this.showStatus("Document number outside valid range.");
                return;
            }
            Document document = null;
            if (!this.ir.isDeleted(n2)) {
                document = this.ir.document(n2);
            } else {
                this.showStatus("This document has been deleted and is not available.");
            }
            this._showDocFields(n2, document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void actionReconstruct(Object object) {
        final Integer n = (Integer)this.getProperty(object, "docNum");
        if (n == null) {
            this.showStatus("FAILED: need to select doc. first!");
            return;
        }
        final Document document = (Document)this.getProperty(object, "doc");
        final Object object2 = this.addComponent(this, "/xml/progress.xml", null, null);
        this.setString(this.find(object2, "msg"), "text", "Collecting terms...");
        this.setInteger(this.find(object2, "bar"), "maximum", 100);
        Thread thread = new Thread(){

            public void run() {
                Object object;
                int n7 = n;
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < Luke.this.idxFields.length; ++i) {
                    object = document.getFields(Luke.this.idxFields[i]);
                    if (object == null || !object[0].isStored()) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < ((Field[])object).length; ++j) {
                        if (j > 0) {
                            stringBuffer.append('\n');
                        }
                        stringBuffer.append(object[j].stringValue());
                    }
                    Field field = new Field(Luke.this.idxFields[i], stringBuffer.toString(), object[0].isStored(), object[0].isIndexed(), object[0].isTokenized(), object[0].isTermVectorStored());
                    field.setBoost(object[0].getBoost());
                    treeMap.put(Luke.this.idxFields[i], field);
                    vector.add(Luke.this.idxFields[i]);
                }
                String string = null;
                object = null;
                try {
                    int n2 = 0;
                    int n3 = Luke.this.numTerms / 100;
                    Object object22 = Luke.this.find(object2, "bar");
                    TermEnum termEnum = Luke.this.ir.terms();
                    TermPositions termPositions = Luke.this.ir.termPositions();
                    while (termEnum.next()) {
                        if (n2++ % n3 == 0) {
                            Luke.this.setInteger(object22, "value", n2 / n3);
                        }
                        if (vector.contains(termEnum.term().field())) continue;
                        termPositions.seek(termEnum.term());
                        if (!termPositions.skipTo(n7) || termPositions.doc() != n7) continue;
                        string = termEnum.term().text();
                        object = (GrowableStringArray)treeMap.get(termEnum.term().field());
                        if (object == null) {
                            object = new GrowableStringArray();
                            treeMap.put(termEnum.term().field(), object);
                        }
                        for (int i = 0; i < termPositions.freq(); ++i) {
                            int n4 = termPositions.nextPosition();
                            ((GrowableStringArray)object).set(n4, string);
                        }
                    }
                    Object object3 = Luke.this.addComponent(null, "/xml/editdoc.xml", null, null);
                    Luke.this.putProperty(object3, "docNum", new Integer(n7));
                    Object object4 = Luke.this.find(object3, "cbAnalyzers");
                    Luke.this.populateAnalyzers(object4);
                    Luke.this.setInteger(object4, "selected", 0);
                    Object object5 = Luke.this.find(object3, "editTabs");
                    Luke.this.setString(Luke.this.find(object3, "docNum"), "text", "Fields of Doc #: " + n7);
                    Iterator iterator = treeMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object object6;
                        String string2 = (String)iterator.next();
                        Object object7 = Thinlet.create("tab");
                        Luke.this.setString(object7, "text", string2);
                        Luke.this.setFont(object7, Luke.this.getFont().deriveFont(1));
                        Luke.this.add(object5, object7);
                        Object object8 = Luke.this.addComponent(object7, "/xml/editfield.xml", null, null);
                        Object v = treeMap.get(string2);
                        Object object9 = Luke.this.find(object8, "fType");
                        Object object10 = Luke.this.find(object8, "fText");
                        Object object11 = Luke.this.find(object8, "fBoost");
                        Object object12 = Luke.this.find(object8, "cbStored");
                        Object object13 = Luke.this.find(object8, "cbIndexed");
                        Object object14 = Luke.this.find(object8, "cbTokenized");
                        Object object15 = Luke.this.find(object8, "cbTVF");
                        if (v instanceof Field) {
                            object6 = (Field)v;
                            Luke.this.setString(object9, "text", "Original stored field content");
                            Luke.this.setString(object10, "text", object6.stringValue());
                            Luke.this.setString(object11, "text", String.valueOf(object6.getBoost()));
                            Luke.this.setBoolean(object12, "selected", object6.isStored());
                            Luke.this.setBoolean(object13, "selected", object6.isIndexed());
                            Luke.this.setBoolean(object14, "selected", object6.isTokenized());
                            Luke.this.setBoolean(object15, "selected", object6.isTermVectorStored());
                            continue;
                        }
                        Luke.this.setString(object9, "text", "RESTORED content - check for errors!");
                        Luke.this.setColor(object9, "foreground", Color.red);
                        Luke.this.setBoolean(object13, "selected", true);
                        Luke.this.setString(object11, "text", String.valueOf(document.getBoost()));
                        object = (GrowableStringArray)treeMap.get(string2);
                        if (object == null) continue;
                        object6 = new StringBuffer();
                        String string3 = "null";
                        int n5 = 0;
                        int n6 = 0;
                        for (int i = 0; i < ((GrowableStringArray)object).size(); ++i) {
                            if (((GrowableStringArray)object).get(i) == null) {
                                ++n5;
                                continue;
                            }
                            if (((StringBuffer)object6).length() > 0) {
                                ((StringBuffer)object6).append(' ');
                            }
                            if (n5 > 0) {
                                ((StringBuffer)object6).append(string3 + "_" + n5 + " ");
                                n5 = 0;
                                ++n6;
                            }
                            ((StringBuffer)object6).append(((GrowableStringArray)object).get(i));
                            if (++n6 % 10 != 0) continue;
                            ((StringBuffer)object6).append('\n');
                        }
                        Luke.this.setString(object10, "text", ((StringBuffer)object6).toString());
                    }
                    Luke.this.add(object3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Luke.this.showStatus(exception.getMessage());
                }
                Luke.this.remove(object2);
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void actionEditAdd(Object object) {
        block23: {
            Object object2;
            Document document = new Document();
            Object object3 = this.find(object, "cbAnalyzers");
            StandardAnalyzer standardAnalyzer = new StandardAnalyzer();
            try {
                object2 = this.getString(object3, "text");
                standardAnalyzer = (Analyzer)Class.forName((String)object2).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.showStatus("FAILED: using StandardAnalyzer");
            }
            object2 = this.find(object, "editTabs");
            Object[] objectArray = this.getItems(object2);
            for (int i = 0; i < objectArray.length; ++i) {
                String string = this.getString(objectArray[i], "text");
                if (string.trim().equals("")) continue;
                Object object4 = this.find(objectArray[i], "fBoost");
                Object object5 = this.find(objectArray[i], "fText");
                Object object6 = this.find(objectArray[i], "cbStored");
                Object object7 = this.find(objectArray[i], "cbIndexed");
                Object object8 = this.find(objectArray[i], "cbTokenized");
                Object object9 = this.find(objectArray[i], "cbTVF");
                String string2 = this.getString(object5, "text");
                Field field = new Field(string, string2, this.getBoolean(object6, "selected"), this.getBoolean(object7, "selected"), this.getBoolean(object8, "selected"), this.getBoolean(object9, "selected"));
                String string3 = this.getString(object4, "text").trim();
                if (!string3.equals("") && !string3.equals("1.0")) {
                    float f = 1.0f;
                    try {
                        f = Float.parseFloat(string3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    field.setBoost(f);
                }
                document.add(field);
            }
            IndexWriter indexWriter = null;
            this.ir.close();
            indexWriter = new IndexWriter((Directory)this.dir, (Analyzer)standardAnalyzer, false);
            indexWriter.addDocument(document);
            Object var21_23 = null;
            try {
                if (indexWriter != null) {
                    indexWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.ir = IndexReader.open((Directory)this.dir);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.remove(object);
            this.initOverview();
            this.initPlugins();
            {
                break block23;
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.errorMsg("FAILED: " + exception.getMessage());
                    Object var21_24 = null;
                    try {
                        if (indexWriter != null) {
                            indexWriter.close();
                        }
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    try {
                        this.ir = IndexReader.open((Directory)this.dir);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    this.remove(object);
                    this.initOverview();
                    this.initPlugins();
                }
            }
            catch (Throwable throwable) {
                Object var21_25 = null;
                try {
                    if (indexWriter != null) {
                        indexWriter.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    this.ir = IndexReader.open((Directory)this.dir);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.remove(object);
                this.initOverview();
                this.initPlugins();
                throw throwable;
            }
        }
    }

    public void actionEditReplace(Object object) {
        this.actionEditAdd(object);
        Integer n = (Integer)this.getProperty(object, "docNum");
        if (n == null) {
            return;
        }
        try {
            this.ir.delete(n.intValue());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus("ERROR deleting: " + exception.getMessage());
            return;
        }
    }

    public void actionEditAddField(Object object) {
        String string = this.getString(this.find(object, "fNewName"), "text");
        if (string.trim().equals("")) {
            this.showStatus("FAILED: Field name is required.");
            return;
        }
        string = string.trim();
        Object object2 = this.find(object, "editTabs");
        Object object3 = Luke.create("tab");
        this.setString(object3, "text", string);
        this.setFont(object3, this.getFont().deriveFont(1));
        this.add(object2, object3);
        Object object4 = this.addComponent(object3, "/xml/editfield.xml", null, null);
        this.repaint(object2);
    }

    public void actionEditDeleteField(Object object) {
        Object object2 = this.getParent(object);
        this.remove(object2);
    }

    private void _showDocFields(int n, Document document) {
        Object object = this.find("docTable");
        this.setString(this.find("docNum"), "text", String.valueOf(n));
        this.setString(this.find("docNum1"), "text", String.valueOf(n));
        this.removeAll(object);
        this.putProperty(object, "doc", document);
        this.putProperty(object, "docNum", new Integer(n));
        if (document == null) {
            return;
        }
        for (int i = 0; i < this.idxFields.length; ++i) {
            Field[] fieldArray = document.getFields(this.idxFields[i]);
            if (fieldArray == null) {
                this.addFieldRow(object, this.idxFields[i], null);
                continue;
            }
            for (int j = 0; j < fieldArray.length; ++j) {
                this.addFieldRow(object, this.idxFields[i], fieldArray[j]);
            }
        }
        this.doLayout(object);
    }

    private void addFieldRow(Object object, String string, Field field) {
        Object object2 = Luke.create("row");
        this.add(object, object2);
        this.putProperty(object2, "field", field);
        this.putProperty(object2, "fName", string);
        Object object3 = Luke.create("cell");
        this.setString(object3, "text", "<" + string + ">");
        this.add(object2, object3);
        object3 = Luke.create("cell");
        if (field != null && field.isIndexed()) {
            this.setString(object3, "text", "+");
        }
        this.add(object2, object3);
        object3 = Luke.create("cell");
        if (field != null && field.isTokenized()) {
            this.setString(object3, "text", "+");
        }
        this.add(object2, object3);
        object3 = Luke.create("cell");
        if (field != null && field.isStored()) {
            this.setString(object3, "text", "+");
        }
        this.add(object2, object3);
        object3 = Luke.create("cell");
        if (field != null && field.isTermVectorStored()) {
            this.setString(object3, "text", "+");
        }
        this.add(object2, object3);
        object3 = Luke.create("cell");
        if (field != null) {
            this.setString(object3, "text", String.valueOf(field.getBoost()));
        }
        this.add(object2, object3);
        object3 = Luke.create("cell");
        if (field != null) {
            this.setString(object3, "text", field.stringValue());
        } else {
            this.setString(object3, "text", "<not available>");
            this.setBoolean(object3, "enabled", false);
        }
        this.add(object2, object3);
    }

    public void showTV(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Integer n = (Integer)this.getProperty(object, "docNum");
        if (n == null) {
            this.showStatus("Missing Doc. Id.");
            return;
        }
        try {
            Object object3;
            int n2;
            String string = (String)this.getProperty(object2, "fName");
            TermFreqVector termFreqVector = this.ir.getTermFreqVector(n.intValue(), string);
            if (termFreqVector == null) {
                this.showStatus("Term Vector not available.");
                return;
            }
            Object object4 = this.addComponent(null, "/xml/vector.xml", null, null);
            this.setString(this.find(object4, "fld"), "text", string);
            Object object5 = this.find(object4, "vTable");
            IntPair[] intPairArray = new IntPair[termFreqVector.size()];
            String[] stringArray = termFreqVector.getTerms();
            int[] nArray = termFreqVector.getTermFrequencies();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object3 = new IntPair(nArray[n2], stringArray[n2]);
                intPairArray[n2] = object3;
            }
            Arrays.sort(intPairArray, new IntPair.PairComparator(false, true));
            for (n2 = 0; n2 < intPairArray.length; ++n2) {
                object3 = Luke.create("row");
                this.add(object5, object3);
                Object object6 = Luke.create("cell");
                this.setString(object6, "text", String.valueOf(intPairArray[n2].cnt));
                this.add(object3, object6);
                object6 = Luke.create("cell");
                this.setString(object6, "text", intPairArray[n2].text);
                this.add(object3, object6);
            }
            this.add(object4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void clipCopyFields(Object object) {
        Object[] objectArray = this.getSelectedItems(object);
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        Document document = (Document)this.getProperty(object, "doc");
        if (document == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            Field field = (Field)this.getProperty(objectArray[i], "field");
            if (field == null) continue;
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(field.toString());
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, this);
    }

    public void clipCopyDoc(Object object) {
        Document document = (Document)this.getProperty(object, "doc");
        if (document == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.getItems(object);
        for (int i = 0; i < objectArray.length; ++i) {
            Field field = (Field)this.getProperty(objectArray[i], "field");
            if (field == null) continue;
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(field.toString());
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, this);
    }

    public void showFirstTerm(Object object, Object object2) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            TermEnum termEnum = this.ir.terms();
            termEnum.next();
            Term term = termEnum.term();
            this._showTerm(object, object2, term);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void showNextTerm(Object object, Object object2) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            String string = this.getString(object2, "text");
            String string2 = this.getString(object, "text");
            TermEnum termEnum = null;
            termEnum = string == null || string.trim().equals("") ? this.ir.terms() : this.ir.terms(new Term(string2, string));
            termEnum.next();
            Term term = termEnum.term();
            this._showTerm(object, object2, term);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void showTerm(Object object, Object object2) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            String string = this.getString(object2, "text");
            String string2 = this.getString(object, "text");
            if (string == null || string.trim().equals("")) {
                return;
            }
            Term term = new Term(string2, string);
            this._showTerm(object, object2, term);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    private void _showTerm(Object object, Object object2, Term term) {
        if (term == null) {
            this.showStatus("No terms?!");
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Object[] objectArray = this.getItems(object);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!term.field().equals(this.getString(objectArray[i], "text"))) continue;
            this.setInteger(object, "selected", i);
            break;
        }
        this.setString(object2, "text", term.text());
        this.putProperty(object2, "term", term);
        this.putProperty(object2, "td", null);
        this.setString(this.find("tdNum"), "text", "?");
        this.setString(this.find("tFreq"), "text", "?");
        Object object3 = this.find("dFreq");
        try {
            int n = this.ir.docFreq(term);
            this.setString(object3, "text", String.valueOf(n));
            object3 = this.find("tdMax");
            this.setString(object3, "text", String.valueOf(n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
            this.setString(object3, "text", "?");
        }
    }

    public void showFirstTermDoc(Object object) {
        Term term = (Term)this.getProperty(object, "term");
        if (term == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            TermDocs termDocs = this.ir.termDocs(term);
            termDocs.next();
            this.setString(this.find("tdNum"), "text", "1");
            this.putProperty(object, "td", termDocs);
            this._showTermDoc(object, termDocs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void showNextTermDoc(Object object) {
        Term term = (Term)this.getProperty(object, "term");
        if (term == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            TermDocs termDocs = (TermDocs)this.getProperty(object, "td");
            if (termDocs == null) {
                this.showFirstTermDoc(object);
                return;
            }
            if (!termDocs.next()) {
                return;
            }
            Object object2 = this.find("tdNum");
            String string = this.getString(object2, "text");
            int n = 1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setString(object2, "text", String.valueOf(n + 1));
            this._showTermDoc(object, termDocs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showAllTermDoc(Object object) {
        Term term = (Term)this.getProperty(object, "term");
        if (term == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus("MSG_NOINDEX");
            return;
        }
        Object object2 = this.find("maintpane");
        this.setInteger(object2, "selected", 2);
        Object object3 = this.find("qField");
        this.setString(object3, "text", term.field() + ":" + term.text());
        Object object4 = this.find("qFieldParsed");
        TermQuery termQuery = new TermQuery(term);
        this.setString(object4, "text", termQuery.toString());
        IndexSearcher indexSearcher = null;
        indexSearcher = new IndexSearcher((Directory)this.dir);
        Object object5 = this.find("sTable");
        this.removeAll(object5);
        this._search((Query)termQuery, indexSearcher, object5);
        Object var10_10 = null;
        if (indexSearcher == null) return;
        try {
            indexSearcher.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                this.errorMsg(exception.getMessage());
                Object var10_11 = null;
                if (indexSearcher == null) return;
                try {
                    indexSearcher.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (indexSearcher == null) throw throwable;
            try {
                indexSearcher.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private QueryParser createQueryParser() {
        String string = this.getString(this.find("cbType"), "text");
        if (string.trim().equals("")) {
            string = "org.apache.lucene.analysis.standard.StandardAnalyzer";
            this.setString(this.find("cbType"), "text", string);
        }
        try {
            this.analyzer = (Analyzer)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg("Analyzer '" + string + "' error: " + exception.getMessage() + ". Using StandardAnalyzer.");
            this.analyzer = this.stdAnalyzer;
        }
        String string2 = this.getString(this.find("defFld"), "text");
        if (string2 == null || string2.trim().equals("")) {
            string2 = this.idxFields[0];
            this.setString(this.find("defFld"), "text", string2);
        }
        return new QueryParser(string2, this.analyzer);
    }

    public void showParsed() {
        QueryParser queryParser = this.createQueryParser();
        Object object = this.find("qField");
        Object object2 = this.find("qFieldParsed");
        String string = this.getString(object, "text");
        if (string.trim().equals("")) {
            this.setBoolean(object2, "enabled", false);
            this.setString(object2, "text", "<Empty query>");
            return;
        }
        this.setBoolean(object2, "enabled", true);
        try {
            Query query = queryParser.parse(string);
            this.setString(object2, "text", query.toString());
        }
        catch (Throwable throwable) {
            this.setString(object2, "text", throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void search(Object object) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        String string = this.getString(object, "text");
        if (string.trim().equals("")) {
            this.showStatus("FAILED: Empty query.");
            return;
        }
        this.qp = this.createQueryParser();
        Object object2 = this.find("sTable");
        this.removeAll(object2);
        IndexSearcher indexSearcher = null;
        Query query = this.qp.parse(string);
        indexSearcher = new IndexSearcher((Directory)this.dir);
        Object object3 = this.find("qFieldParsed");
        this.setString(object3, "text", query.toString());
        this._search(query, indexSearcher, object2);
        Object var8_8 = null;
        if (indexSearcher == null) return;
        try {
            indexSearcher.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.errorMsg(throwable.getMessage());
                Object var8_9 = null;
                if (indexSearcher == null) return;
                try {
                    indexSearcher.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (indexSearcher == null) throw throwable;
            try {
                indexSearcher.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void _search(Query query, IndexSearcher indexSearcher, Object object) throws Exception {
        long l = System.currentTimeMillis();
        Hits hits = indexSearcher.search(query);
        long l2 = System.currentTimeMillis();
        this.showStatus(l2 - l + " ms");
        if (hits == null || hits.length() == 0) {
            Object object2 = Luke.create("row");
            Object object3 = Luke.create("cell");
            this.add(object, object2);
            this.add(object2, object3);
            object3 = Luke.create("cell");
            this.add(object2, object3);
            object3 = Luke.create("cell");
            this.setString(object3, "text", "No Results");
            this.setBoolean(object3, "enabled", false);
            this.add(object2, object3);
            this.setString(this.find("resNum"), "text", "0");
            return;
        }
        this.setString(this.find("resNum"), "text", String.valueOf(hits.length()));
        for (int i = 0; i < hits.length(); ++i) {
            Object object4 = Luke.create("row");
            Object object5 = Luke.create("cell");
            this.add(object, object4);
            this.setString(object5, "text", String.valueOf((double)Math.round(1000.0f * hits.score(i)) / 10.0));
            this.add(object4, object5);
            object5 = Luke.create("cell");
            this.setString(object5, "text", String.valueOf(hits.id(i)));
            this.add(object4, object5);
            Document document = hits.doc(i);
            this.putProperty(object4, "docid", new Integer(hits.id(i)));
            for (int j = 0; j < this.idxFields.length; ++j) {
                object5 = Luke.create("cell");
                this.setString(object5, "text", document.get(this.idxFields[j]));
                this.add(object4, object5);
            }
        }
        this.putProperty(object, "query", query);
    }

    public void explainResult(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        Integer n = (Integer)this.getProperty(object2, "docid");
        if (n == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Query query = (Query)this.getProperty(object, "query");
        if (query == null) {
            return;
        }
        try {
            IndexSearcher indexSearcher = new IndexSearcher((Directory)this.dir);
            Explanation explanation = indexSearcher.explain(query, n.intValue());
            Object object3 = this.addComponent(null, "/xml/explain.xml", null, null);
            Object object4 = this.find(object3, "eTree");
            this.addNode(object4, explanation);
            this.add(object3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
        }
    }

    private void addNode(Object object, Explanation explanation) {
        Explanation[] explanationArray;
        Object object2 = Luke.create("node");
        this.setString(object2, "text", this.df.format(explanation.getValue()) + "  " + explanation.getDescription());
        this.add(object, object2);
        if (Luke.getClass(object) == "tree") {
            this.setFont(object2, this.getFont().deriveFont(1));
        }
        if ((explanationArray = explanation.getDetails()) != null && explanationArray.length > 0) {
            for (int i = 0; i < explanationArray.length; ++i) {
                this.addNode(object2, explanationArray[i]);
            }
        }
    }

    public void gotoDoc(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        Integer n = (Integer)this.getProperty(object2, "docid");
        if (n == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Document document = null;
        try {
            document = this.ir.document(n.intValue());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
            return;
        }
        this._showDocFields(n, document);
        Object object3 = this.find("maintpane");
        this.setInteger(object3, "selected", 1);
        this.repaint();
    }

    private void _showTermDoc(Object object, TermDocs termDocs) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            Document document = this.ir.document(termDocs.doc());
            this.setString(this.find("docNum"), "text", String.valueOf(termDocs.doc()));
            this.setString(this.find("tFreq"), "text", String.valueOf(termDocs.freq()));
            this._showDocFields(termDocs.doc(), document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void deleteTermDoc(Object object) {
        Term term = (Term)this.getProperty(object, "term");
        if (term == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            this.showNextTerm(this.find("fCombo"), object);
            this.ir.delete(term);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
        this.initOverview();
    }

    public void deleteDoc(Object object) {
        int n = 0;
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            n = Integer.parseInt(this.getString(object, "text"));
            this.showNextDoc(object);
            this.ir.delete(n);
            this.initOverview();
        }
        catch (Exception exception) {
            this.showStatus(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void deleteDocList(Object object) {
        Object[] objectArray = this.getSelectedItems(object);
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Integer n = (Integer)this.getProperty(objectArray[i], "docid");
            if (n == null) continue;
            try {
                this.ir.delete(n.intValue());
            }
            catch (Exception exception) {
                continue;
            }
            this.remove(objectArray[i]);
        }
        this.initOverview();
    }

    public void actionAbout() {
        Object object = this.addComponent(this, "/xml/about.xml", null, null);
        this.requestFocus(this.find(object, "bOk"));
    }

    public boolean destroy() {
        if (this.ir != null) {
            try {
                this.ir.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dir != null) {
            try {
                this.dir.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Prefs.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.destroy();
    }

    public void actionExit() {
        this.destroy();
        System.exit(0);
    }

    public void goUrl(Object object) {
        String string = (String)this.getProperty(object, "url");
        if (string == null) {
            return;
        }
        try {
            BrowserLauncher.openURL(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        FrameLauncher frameLauncher = new FrameLauncher("Luke - Lucene Index Toolbox, v 0.5 (2004-06-25)", new Luke(), 650, 450);
        frameLauncher.setIconImage(Toolkit.getDefaultToolkit().createImage((class$org$getopt$luke$Luke == null ? (class$org$getopt$luke$Luke = Luke.class$("org.getopt.luke.Luke")) : class$org$getopt$luke$Luke).getResource("/img/luke.gif")));
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

