/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ClassFinder {
    private ClassFinder() {
    }

    public static List findClassesThatExtend(String[] stringArray, Class[] classArray) throws IOException, ClassNotFoundException {
        return ClassFinder.findClassesThatExtend(stringArray, classArray, false);
    }

    public static List findClassesThatExtend(Class[] classArray) throws IOException, ClassNotFoundException {
        String string = System.getProperty("java.class.path");
        String[] stringArray = string.split(File.pathSeparator);
        return ClassFinder.findClassesThatExtend(stringArray, classArray);
    }

    public static List findClassesThatExtend(Class clazz) throws IOException, ClassNotFoundException {
        String string = System.getProperty("java.class.path");
        String[] stringArray = string.split("" + File.pathSeparatorChar);
        Class[] classArray = new Class[]{clazz};
        return ClassFinder.findClassesThatExtend(stringArray, classArray);
    }

    public static Class[] getInstantiableSubclasses(Class clazz) throws IOException, ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        List list = ClassFinder.findClassesThatExtend(clazz);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class<?> clazz2 = Class.forName(string);
                int n = clazz2.getModifiers();
                if (Modifier.isAbstract(n)) continue;
                arrayList.add(clazz2);
            }
            catch (Throwable throwable) {}
        }
        return arrayList.toArray(new Class[0]);
    }

    private static String[] addJarsInPath(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            hashSet.add(stringArray[i]);
            if (stringArray[i].endsWith(".jar") || !(file = new File(stringArray[i])).exists() || !file.isDirectory()) continue;
            String[] stringArray2 = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".jar");
                }
            });
            for (int j = 0; j < stringArray2.length; ++j) {
                hashSet.add(stringArray2[j]);
            }
        }
        return hashSet.toArray(new String[0]);
    }

    public static List findClassesThatExtend(String[] stringArray, Class[] classArray, boolean bl) throws IOException, ClassNotFoundException {
        List list = null;
        ArrayList arrayList = null;
        ArrayList<String> arrayList2 = null;
        stringArray = ClassFinder.addJarsInPath(stringArray);
        list = ClassFinder.getClasspathMatches(stringArray);
        arrayList = new ArrayList();
        arrayList2 = new ArrayList<String>();
        for (int i = 0; i < classArray.length; ++i) {
            arrayList2.add(classArray[i].getName());
        }
        ClassFinder.findClassesInPaths(list, arrayList);
        ArrayList arrayList3 = ClassFinder.findAllSubclasses(arrayList2, arrayList, bl);
        return arrayList3;
    }

    private static List getClasspathMatches(String[] stringArray) {
        ArrayList<String> arrayList = null;
        StringTokenizer stringTokenizer = null;
        String string = null;
        arrayList = new ArrayList<String>();
        stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        if (stringArray != null) {
            stringArray = ClassFinder.fixDotDirs(stringArray);
            stringArray = ClassFinder.fixSlashes(stringArray);
            stringArray = ClassFinder.fixEndingSlashes(stringArray);
        }
        while (stringTokenizer.hasMoreTokens()) {
            string = ClassFinder.fixDotDir(stringTokenizer.nextToken());
            string = ClassFinder.fixSlashes(string);
            string = ClassFinder.fixEndingSlashes(string);
            if (stringArray == null) {
                arrayList.add(string);
                continue;
            }
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.endsWith(stringArray[i])) continue;
                bl = true;
                arrayList.add(string);
                break;
            }
            if (bl) continue;
        }
        return arrayList;
    }

    private static String[] fixDotDirs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ClassFinder.fixDotDir(stringArray[i]);
        }
        return stringArray;
    }

    private static String fixDotDir(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(".")) {
            return System.getProperty("user.dir");
        }
        return string.trim();
    }

    private static String[] fixEndingSlashes(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = ClassFinder.fixEndingSlashes(stringArray[i]);
        }
        return stringArray2;
    }

    private static String fixEndingSlashes(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
            string = ClassFinder.fixEndingSlashes(string);
        }
        return string;
    }

    private static String[] fixSlashes(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = ClassFinder.fixSlashes(stringArray[i]);
        }
        return stringArray2;
    }

    private static String fixSlashes(String string) {
        string = string.replace('\\', '/');
        string = ClassFinder.replaceString(string, "//", "_____");
        string = ClassFinder.replaceString(string, "_____", "/");
        return string;
    }

    private static String replaceString(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = null;
        if (string.indexOf(string2) == -1) {
            return string;
        }
        int n2 = 0;
        stringBuffer = new StringBuffer();
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static ArrayList findAllSubclasses(List list, List list2, boolean bl) {
        Iterator iterator = null;
        ArrayList arrayList = null;
        String string = null;
        Class<?> clazz = null;
        arrayList = new ArrayList();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.indexOf("$") != -1 && !bl) continue;
            try {
                clazz = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
                ClassFinder.findAllSubclassesOneClass(clazz, list2, arrayList, bl);
            }
            catch (Throwable throwable) {}
        }
        return arrayList;
    }

    private static void findAllSubclassesOneClass(Class clazz, List list, List list2, boolean bl) {
        Iterator iterator = null;
        String string = null;
        Class<?> clazz2 = null;
        boolean bl2 = false;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.indexOf("$") != -1 && !bl) continue;
            try {
                clazz2 = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
                bl2 = !clazz2.isInterface() && !Modifier.isAbstract(clazz2.getModifiers()) ? clazz.isAssignableFrom(clazz2) : false;
                if (!bl2) continue;
                list2.add(string);
            }
            catch (Throwable throwable) {}
        }
    }

    private static String fixClassName(String string) {
        string = string.replace('\\', '.');
        string = string.replace('/', '.');
        string = string.substring(0, string.length() - 6);
        return string;
    }

    private static void findClassesInOnePath(String string, List list) throws IOException {
        File file = null;
        ZipFile zipFile = null;
        Enumeration<? extends ZipEntry> enumeration = null;
        String string2 = null;
        file = new File(string);
        if (file.isDirectory()) {
            ClassFinder.findClassesInPathsDir(string, file, list);
        } else if (file.exists()) {
            zipFile = new ZipFile(file);
            enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                string2 = ((Object)enumeration.nextElement()).toString();
                if (!string2.endsWith(".class")) continue;
                list.add(ClassFinder.fixClassName(string2));
            }
        }
    }

    private static void findClassesInPaths(List list, List list2) throws IOException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClassFinder.findClassesInOnePath((String)iterator.next(), list2);
        }
    }

    private static void findClassesInPathsDir(String string, File file, List list) throws IOException {
        File file2 = null;
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                ClassFinder.findClassesInPathsDir(string, file2, list);
                continue;
            }
            if (!file2.exists() || file2.length() == 0L || !stringArray[i].endsWith(".class")) continue;
            list.add(file2.getPath().substring(string.length() + 1, file2.getPath().lastIndexOf(".")).replace(File.separator.charAt(0), '.'));
        }
    }
}

