/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.expr;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.expr.ParseException;
import com.sun.tools.example.debug.expr.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

abstract class LValue {
    static final int STATIC = 0;
    static final int INSTANCE = 1;
    static List primitiveTypeNames = new ArrayList();

    LValue() {
    }

    abstract Value getValue() throws InvocationException, IncompatibleThreadStateException, InvalidTypeException, ClassNotLoadedException, ParseException;

    abstract void setValue0(Value var1) throws ParseException, InvalidTypeException, ClassNotLoadedException;

    abstract void invokeWith(List var1) throws ParseException;

    void setValue(Value value) throws ParseException {
        try {
            this.setValue0(value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new ParseException("Attempt to set value of incorrect type" + invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new ParseException("Attempt to set value before " + classNotLoadedException.className() + " was loaded" + classNotLoadedException);
        }
    }

    void setValue(LValue lValue) throws ParseException {
        this.setValue(lValue.interiorGetValue());
    }

    LValue memberLValue(ExpressionParser.GetFrame getFrame, String string) throws ParseException {
        try {
            return this.memberLValue(string, getFrame.get().thread());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new ParseException("Thread not suspended");
        }
    }

    LValue memberLValue(String string, ThreadReference threadReference) throws ParseException {
        return new LValueInstanceMember(this.interiorGetValue(), string, threadReference);
    }

    Value interiorGetValue() throws ParseException {
        Value value;
        try {
            value = this.getValue();
        }
        catch (InvocationException invocationException) {
            throw new ParseException("Unable to complete expression. Exception " + invocationException.exception() + " thrown");
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new ParseException("Unable to complete expression. Thread not suspended for method invoke");
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new ParseException("Unable to complete expression. Method argument type mismatch");
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new ParseException("Unable to complete expression. Method argument type " + classNotLoadedException.className() + " not yet loaded");
        }
        return value;
    }

    LValue arrayElementLValue(LValue lValue) throws ParseException {
        Value value = lValue.interiorGetValue();
        if (!(value instanceof IntegerValue || value instanceof ShortValue || value instanceof ByteValue || value instanceof CharValue)) {
            throw new ParseException("Array index must be a integer type");
        }
        int n = ((PrimitiveValue)value).intValue();
        return new LValueArrayElement(this.interiorGetValue(), n);
    }

    public String toString() {
        try {
            return this.interiorGetValue().toString();
        }
        catch (ParseException parseException) {
            return "<Parse Exception>";
        }
    }

    static Field fieldByName(ReferenceType referenceType, String string, int n) {
        Field field = referenceType.fieldByName(string);
        if (field != null) {
            boolean bl = field.isStatic();
            if (n == 0 && !bl || n == 1 && bl) {
                field = null;
            }
        }
        return field;
    }

    static List methodsByName(ReferenceType referenceType, String string, int n) {
        List list = referenceType.methodsByName(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            boolean bl = method.isStatic();
            if ((n != 0 || bl) && (n != 1 || !bl)) continue;
            iterator.remove();
        }
        return list;
    }

    static boolean argumentsMatch(List list, List list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Value value = (Value)iterator2.next();
            if (!(value == null ? primitiveTypeNames.contains(string) : !string.equals(value.type().name()))) continue;
            return false;
        }
        return true;
    }

    static Method resolveOverload(List list, List list2) throws ParseException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            List list3 = method.argumentTypeNames();
            if (!LValue.argumentsMatch(list3, list2)) continue;
            return method;
        }
        throw new ParseException("Arguments match no method");
    }

    static LValue make(VirtualMachine virtualMachine, boolean bl) {
        return new LValueConstant(virtualMachine.mirrorOf(bl));
    }

    static LValue make(VirtualMachine virtualMachine, byte by) {
        return new LValueConstant(virtualMachine.mirrorOf(by));
    }

    static LValue make(VirtualMachine virtualMachine, char c) {
        return new LValueConstant(virtualMachine.mirrorOf(c));
    }

    static LValue make(VirtualMachine virtualMachine, short s) {
        return new LValueConstant(virtualMachine.mirrorOf(s));
    }

    static LValue make(VirtualMachine virtualMachine, int n) {
        return new LValueConstant(virtualMachine.mirrorOf(n));
    }

    static LValue make(VirtualMachine virtualMachine, long l) {
        return new LValueConstant(virtualMachine.mirrorOf(l));
    }

    static LValue make(VirtualMachine virtualMachine, float f) {
        return new LValueConstant(virtualMachine.mirrorOf(f));
    }

    static LValue make(VirtualMachine virtualMachine, double d) {
        return new LValueConstant(virtualMachine.mirrorOf(d));
    }

    static LValue make(VirtualMachine virtualMachine, String string) throws ParseException {
        return new LValueConstant(virtualMachine.mirrorOf(string));
    }

    static LValue makeBoolean(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, token.image.charAt(0) == 't');
    }

    static LValue makeCharacter(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, token.image.charAt(1));
    }

    static LValue makeFloat(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Float.valueOf(token.image).floatValue());
    }

    static LValue makeDouble(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Double.valueOf(token.image));
    }

    static LValue makeInteger(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Integer.parseInt(token.image));
    }

    static LValue makeShort(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Short.parseShort(token.image));
    }

    static LValue makeLong(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Long.parseLong(token.image));
    }

    static LValue makeByte(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Byte.parseByte(token.image));
    }

    static LValue makeString(VirtualMachine virtualMachine, Token token) throws ParseException {
        int n = token.image.length();
        return LValue.make(virtualMachine, token.image.substring(1, n - 1));
    }

    static LValue makeNull(VirtualMachine virtualMachine, Token token) throws ParseException {
        return new LValueConstant(null);
    }

    static LValue makeThisObject(VirtualMachine virtualMachine, ExpressionParser.GetFrame getFrame, Token token) throws ParseException {
        if (getFrame == null) {
            throw new ParseException("No current thread");
        }
        try {
            StackFrame stackFrame = getFrame.get();
            ObjectReference objectReference = stackFrame.thisObject();
            if (objectReference == null) {
                throw new ParseException("No 'this'.  In native or static method");
            }
            return new LValueConstant(objectReference);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new ParseException("Thread not suspended");
        }
    }

    static LValue makeNewObject(VirtualMachine virtualMachine, ExpressionParser.GetFrame getFrame, String string, List list) throws ParseException {
        ObjectReference objectReference;
        Method method;
        List list2 = virtualMachine.classesByName(string);
        if (list2.size() == 0) {
            throw new ParseException("No class named: " + string);
        }
        if (list2.size() > 1) {
            throw new ParseException("More than one class named: " + string);
        }
        ReferenceType referenceType = (ReferenceType)list2.get(0);
        if (!(referenceType instanceof ClassType)) {
            throw new ParseException("Cannot create instance of interface " + string);
        }
        ClassType classType = (ClassType)referenceType;
        ArrayList arrayList = new ArrayList(classType.methods());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            method = (Method)iterator.next();
            if (method.isConstructor()) continue;
            iterator.remove();
        }
        method = LValue.resolveOverload(arrayList, list);
        try {
            ThreadReference threadReference = getFrame.get().thread();
            objectReference = classType.newInstance(threadReference, method, list, 0);
        }
        catch (InvocationException invocationException) {
            throw new ParseException("Exception in " + string + " constructor: " + invocationException.exception().referenceType().name());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new ParseException("Thread not suspended");
        }
        catch (Exception exception) {
            throw new ParseException("Unable to create " + string + " instance");
        }
        return new LValueConstant(objectReference);
    }

    private static LValue nFields(LValue lValue, StringTokenizer stringTokenizer, ThreadReference threadReference) throws ParseException {
        if (!stringTokenizer.hasMoreTokens()) {
            return lValue;
        }
        return LValue.nFields(lValue.memberLValue(stringTokenizer.nextToken(), threadReference), stringTokenizer, threadReference);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LValue makeName(VirtualMachine virtualMachine, ExpressionParser.GetFrame getFrame, String string) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        if (getFrame == null) throw new ParseException("Name unknown: " + string);
        try {
            LValue lValue;
            Object object;
            LocalVariable localVariable;
            StackFrame stackFrame = getFrame.get();
            ThreadReference threadReference = stackFrame.thread();
            try {
                localVariable = stackFrame.visibleVariableByName(string2);
            }
            catch (AbsentInformationException absentInformationException) {
                localVariable = null;
            }
            if (localVariable != null) {
                return LValue.nFields(new LValueLocal(stackFrame, localVariable), stringTokenizer, threadReference);
            }
            Object object2 = stackFrame.thisObject();
            if (object2 != null) {
                object = new LValueConstant((Value)object2);
                try {
                    lValue = ((LValue)object).memberLValue(string2, threadReference);
                }
                catch (ParseException parseException) {
                    lValue = null;
                }
                if (lValue != null) {
                    return LValue.nFields(lValue, stringTokenizer, threadReference);
                }
            }
            while (true) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new ParseException("Name unknown: " + string);
                }
                object2 = virtualMachine.classesByName(string2);
                if (object2.size() > 0) {
                    if (object2.size() > 1) {
                        throw new ParseException("More than one class named: " + string2);
                    }
                    object = (ReferenceType)object2.get(0);
                    lValue = new LValueStaticMember((ReferenceType)object, stringTokenizer.nextToken(), threadReference);
                    return LValue.nFields(lValue, stringTokenizer, threadReference);
                }
                string2 = string2 + '.' + stringTokenizer.nextToken();
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new ParseException("Thread not suspended");
        }
    }

    static String stringValue(Value value) {
        if (value instanceof StringReference) {
            return ((StringReference)value).value();
        }
        if (value instanceof ObjectReference) {
            return ((ObjectReference)value).toString();
        }
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    static LValue booleanOperation(VirtualMachine virtualMachine, Token token, LValue lValue, LValue lValue2) throws ParseException {
        boolean bl;
        String string = token.image;
        Value value = lValue.interiorGetValue();
        Value value2 = lValue2.interiorGetValue();
        if (!(value instanceof PrimitiveValue) || !(value2 instanceof PrimitiveValue)) {
            if (string.equals("==")) {
                return LValue.make(virtualMachine, value.equals(value2));
            }
            if (string.equals("!=")) {
                return LValue.make(virtualMachine, !value.equals(value2));
            }
            throw new ParseException("Operands or '" + string + "' must be primitive");
        }
        double d = ((PrimitiveValue)value).doubleValue();
        double d2 = ((PrimitiveValue)value2).doubleValue();
        if (string.equals("<")) {
            bl = d < d2;
        } else if (string.equals(">")) {
            bl = d > d2;
        } else if (string.equals("<=")) {
            bl = d <= d2;
        } else if (string.equals(">=")) {
            bl = d >= d2;
        } else if (string.equals("==")) {
            bl = d == d2;
        } else if (string.equals("!=")) {
            bl = d != d2;
        } else {
            throw new ParseException("Unknown operation: " + string);
        }
        return LValue.make(virtualMachine, bl);
    }

    static LValue operation(VirtualMachine virtualMachine, Token token, LValue lValue, LValue lValue2) throws ParseException {
        int n;
        String string = token.image;
        Value value = lValue.interiorGetValue();
        Value value2 = lValue2.interiorGetValue();
        if ((value instanceof StringReference || value2 instanceof StringReference) && string.equals("+")) {
            return LValue.make(virtualMachine, LValue.stringValue(value) + LValue.stringValue(value2));
        }
        if (value instanceof ObjectReference || value2 instanceof ObjectReference) {
            if (string.equals("==")) {
                return LValue.make(virtualMachine, value.equals(value2));
            }
            if (string.equals("!=")) {
                return LValue.make(virtualMachine, !value.equals(value2));
            }
            throw new ParseException("Invalid operation '" + string + "' on an Object");
        }
        if (value instanceof BooleanValue || value2 instanceof BooleanValue) {
            throw new ParseException("Invalid operation '" + string + "' on a Boolean");
        }
        PrimitiveValue primitiveValue = (PrimitiveValue)value;
        PrimitiveValue primitiveValue2 = (PrimitiveValue)value2;
        if (primitiveValue instanceof DoubleValue || primitiveValue2 instanceof DoubleValue) {
            double d;
            double d2 = primitiveValue.doubleValue();
            double d3 = primitiveValue2.doubleValue();
            if (string.equals("+")) {
                d = d2 + d3;
            } else if (string.equals("-")) {
                d = d2 - d3;
            } else if (string.equals("*")) {
                d = d2 * d3;
            } else if (string.equals("/")) {
                d = d2 / d3;
            } else {
                throw new ParseException("Unknown operation: " + string);
            }
            return LValue.make(virtualMachine, d);
        }
        if (primitiveValue instanceof FloatValue || primitiveValue2 instanceof FloatValue) {
            float f;
            float f2 = primitiveValue.floatValue();
            float f3 = primitiveValue2.floatValue();
            if (string.equals("+")) {
                f = f2 + f3;
            } else if (string.equals("-")) {
                f = f2 - f3;
            } else if (string.equals("*")) {
                f = f2 * f3;
            } else if (string.equals("/")) {
                f = f2 / f3;
            } else {
                throw new ParseException("Unknown operation: " + string);
            }
            return LValue.make(virtualMachine, f);
        }
        if (primitiveValue instanceof LongValue || primitiveValue2 instanceof LongValue) {
            long l;
            long l2 = primitiveValue.longValue();
            long l3 = primitiveValue2.longValue();
            if (string.equals("+")) {
                l = l2 + l3;
            } else if (string.equals("-")) {
                l = l2 - l3;
            } else if (string.equals("*")) {
                l = l2 * l3;
            } else if (string.equals("/")) {
                l = l2 / l3;
            } else {
                throw new ParseException("Unknown operation: " + string);
            }
            return LValue.make(virtualMachine, l);
        }
        int n2 = primitiveValue.intValue();
        int n3 = primitiveValue2.intValue();
        if (string.equals("+")) {
            n = n2 + n3;
        } else if (string.equals("-")) {
            n = n2 - n3;
        } else if (string.equals("*")) {
            n = n2 * n3;
        } else if (string.equals("/")) {
            n = n2 / n3;
        } else {
            throw new ParseException("Unknown operation: " + string);
        }
        return LValue.make(virtualMachine, n);
    }

    static {
        primitiveTypeNames.add("boolean");
        primitiveTypeNames.add("byte");
        primitiveTypeNames.add("char");
        primitiveTypeNames.add("short");
        primitiveTypeNames.add("int");
        primitiveTypeNames.add("long");
        primitiveTypeNames.add("float");
        primitiveTypeNames.add("double");
    }

    private static class LValueConstant
    extends LValue {
        final Value value;

        LValueConstant(Value value) {
            this.value = value;
        }

        Value getValue() {
            return this.value;
        }

        void setValue0(Value value) throws ParseException {
            throw new ParseException("Cannot set constant: " + this.value);
        }

        void invokeWith(List list) throws ParseException {
            throw new ParseException("Constant is not a method");
        }
    }

    private static class LValueArrayElement
    extends LValue {
        final ArrayReference array;
        final int index;

        LValueArrayElement(Value value, int n) throws ParseException {
            if (!(value instanceof ArrayReference)) {
                throw new ParseException("Must be array type: " + value);
            }
            this.array = (ArrayReference)value;
            this.index = n;
        }

        Value getValue() {
            return this.array.getValue(this.index);
        }

        void setValue0(Value value) throws InvalidTypeException, ClassNotLoadedException {
            this.array.setValue(this.index, value);
        }

        void invokeWith(List list) throws ParseException {
            throw new ParseException("Array element is not a method");
        }
    }

    private static class LValueStaticMember
    extends LValue {
        final ReferenceType refType;
        final ThreadReference thread;
        final Field matchingField;
        final List overloads;
        Method matchingMethod = null;
        List methodArguments = null;

        LValueStaticMember(ReferenceType referenceType, String string, ThreadReference threadReference) throws ParseException {
            this.refType = referenceType;
            this.thread = threadReference;
            this.matchingField = LValue.fieldByName(referenceType, string, 0);
            this.overloads = LValue.methodsByName(referenceType, string, 0);
            if (this.matchingField == null && this.overloads.size() == 0) {
                throw new ParseException("No static field or method with the name " + string + " in " + referenceType.name());
            }
        }

        Value getValue() throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, ParseException {
            if (this.matchingMethod == null) {
                return this.refType.getValue(this.matchingField);
            }
            if (this.refType instanceof ClassType) {
                ClassType classType = (ClassType)this.refType;
                return classType.invokeMethod(this.thread, this.matchingMethod, this.methodArguments, 0);
            }
            throw new InvalidTypeException("Cannot invoke static method on " + this.refType.name());
        }

        void setValue0(Value value) throws ParseException, InvalidTypeException, ClassNotLoadedException {
            if (this.matchingMethod != null) {
                throw new ParseException("Cannot assign to a method invocation");
            }
            if (!(this.refType instanceof ClassType)) {
                throw new ParseException("Cannot set interface field: " + this.refType);
            }
            ((ClassType)this.refType).setValue(this.matchingField, value);
        }

        void invokeWith(List list) throws ParseException {
            if (this.matchingMethod != null) {
                throw new ParseException("Invalid consecutive invocations");
            }
            this.methodArguments = list;
            this.matchingMethod = LValue.resolveOverload(this.overloads, list);
        }
    }

    private static class LValueInstanceMember
    extends LValue {
        final ObjectReference obj;
        final ThreadReference thread;
        final Field matchingField;
        final List overloads;
        Method matchingMethod = null;
        List methodArguments = null;

        LValueInstanceMember(Value value, String string, ThreadReference threadReference) throws ParseException {
            if (!(value instanceof ObjectReference)) {
                throw new ParseException("Cannot access field of primitive type: " + value);
            }
            this.obj = (ObjectReference)value;
            this.thread = threadReference;
            ReferenceType referenceType = this.obj.referenceType();
            this.matchingField = LValue.fieldByName(referenceType, string, 1);
            this.overloads = LValue.methodsByName(referenceType, string, 1);
            if (this.matchingField == null && this.overloads.size() == 0) {
                throw new ParseException("No instance field or method with the name " + string + " in " + referenceType.name());
            }
        }

        Value getValue() throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, ParseException {
            if (this.matchingMethod == null) {
                if (this.matchingField == null) {
                    throw new ParseException("No such field in " + this.obj.referenceType().name());
                }
                return this.obj.getValue(this.matchingField);
            }
            return this.obj.invokeMethod(this.thread, this.matchingMethod, this.methodArguments, 0);
        }

        void setValue0(Value value) throws ParseException, InvalidTypeException, ClassNotLoadedException {
            if (this.matchingMethod != null) {
                throw new ParseException("Cannot assign to a method invocation");
            }
            this.obj.setValue(this.matchingField, value);
        }

        void invokeWith(List list) throws ParseException {
            if (this.matchingMethod != null) {
                throw new ParseException("Invalid consecutive invocations");
            }
            this.methodArguments = list;
            this.matchingMethod = LValue.resolveOverload(this.overloads, list);
        }
    }

    private static class LValueLocal
    extends LValue {
        final StackFrame frame;
        final LocalVariable var;

        LValueLocal(StackFrame stackFrame, LocalVariable localVariable) {
            this.frame = stackFrame;
            this.var = localVariable;
        }

        Value getValue() {
            return this.frame.getValue(this.var);
        }

        void setValue0(Value value) throws InvalidTypeException, ClassNotLoadedException {
            this.frame.setValue(this.var, value);
        }

        void invokeWith(List list) throws ParseException {
            throw new ParseException(this.var.name() + " is not a method");
        }
    }
}

