/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.AttributeEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.se.idl.toJavaPortable.AuxGen;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.MethodGen;
import com.sun.tools.corba.se.idl.toJavaPortable.NameModifier;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Skeleton
implements AuxGen {
    private NameModifier skeletonNameModifier;
    private NameModifier tieNameModifier;
    protected Hashtable symbolTable = null;
    protected InterfaceEntry i = null;
    protected PrintWriter stream = null;
    protected String tieClassName = null;
    protected String skeletonClassName = null;
    protected boolean tie = false;
    protected boolean poa = false;
    protected Vector methodList = null;
    protected String intfName = "";

    public void generate(Hashtable hashtable, SymtabEntry symtabEntry) {
        ValueEntry valueEntry;
        if (symtabEntry instanceof ValueEntry && ((valueEntry = (ValueEntry)symtabEntry).supports().size() == 0 || ((InterfaceEntry)valueEntry.supports().elementAt(0)).isAbstract())) {
            return;
        }
        if (((InterfaceEntry)symtabEntry).isAbstract()) {
            return;
        }
        this.symbolTable = hashtable;
        this.i = (InterfaceEntry)symtabEntry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.tie = ((Arguments)Compile.compiler.arguments).TIEServer;
        this.poa = ((Arguments)Compile.compiler.arguments).POAServer;
        this.skeletonNameModifier = ((Arguments)Compile.compiler.arguments).skeletonNameModifier;
        this.tieNameModifier = ((Arguments)Compile.compiler.arguments).tieNameModifier;
        this.tieClassName = this.tieNameModifier.makeName(this.i.name());
        this.skeletonClassName = this.skeletonNameModifier.makeName(this.i.name());
        this.intfName = Util.javaName(this.i);
        if (this.i instanceof ValueEntry) {
            ValueEntry valueEntry = (ValueEntry)this.i;
            InterfaceEntry interfaceEntry = (InterfaceEntry)valueEntry.supports().elementAt(0);
            this.intfName = Util.javaName(interfaceEntry);
        }
    }

    protected void openStream() {
        this.stream = this.tie ? Util.stream(this.i, this.tieNameModifier, ".java") : Util.stream(this.i, this.skeletonNameModifier, ".java");
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.i, (short)1);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.i.comment() != null) {
            this.i.comment().generate("", this.stream);
        }
        this.writeClassDeclaration();
        this.stream.println('{');
        this.stream.println();
    }

    protected void writeClassDeclaration() {
        if (this.tie) {
            this.stream.println("public class " + this.tieClassName + " extends " + this.skeletonClassName);
        } else if (this.poa) {
            this.stream.println("public abstract class " + this.skeletonClassName + " extends org.omg.PortableServer.Servant");
            this.stream.print(" implements " + this.intfName + "Operations, ");
            this.stream.println("org.omg.CORBA.portable.InvokeHandler");
        } else {
            this.stream.println("public abstract class " + this.skeletonClassName + " extends org.omg.CORBA.portable.ObjectImpl");
            this.stream.print("                implements " + this.intfName + ", ");
            this.stream.println("org.omg.CORBA.portable.InvokeHandler");
        }
    }

    protected void writeBody() {
        this.writeCtors();
        if (this.i instanceof ValueEntry) {
            ValueEntry valueEntry = (ValueEntry)this.i;
            this.i = (InterfaceEntry)valueEntry.supports().elementAt(0);
        }
        this.buildMethodList();
        if (this.tie) {
            if (this.poa) {
                this.writeMethods();
                this.stream.println("  private " + this.intfName + "Operations _impl;");
                this.stream.println("  private org.omg.PortableServer.POA _poa;");
            } else {
                this.writeMethods();
                this.stream.println("  private " + this.intfName + "Operations _impl;");
            }
        } else if (this.poa) {
            this.writeMethodTable();
            this.writeDispatchMethod();
            this.writeCORBAOperations();
        } else {
            this.writeMethodTable();
            this.writeDispatchMethod();
            this.writeCORBAOperations();
        }
        this.writeOperations();
    }

    protected void writeClosing() {
        this.stream.println();
        if (this.tie) {
            this.stream.println("} // class " + this.tieClassName);
        } else {
            this.stream.println("} // class " + this.skeletonClassName);
        }
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeCtors() {
        this.stream.println("  // Constructors");
        if (!this.poa) {
            if (this.tie) {
                this.stream.println("  public " + this.tieClassName + " ()");
                this.stream.println("  {");
                this.stream.println("  }");
            } else {
                this.stream.println("  public " + this.skeletonClassName + " ()");
                this.stream.println("  {");
                this.stream.println("  }");
            }
        }
        this.stream.println();
        if (this.tie) {
            if (this.poa) {
                this.writePOATieCtors();
                this.writePOATieFieldAccessMethods();
            } else {
                this.stream.println("  public " + this.tieClassName + " (" + this.intfName + "Operations impl)");
                this.stream.println("  {");
                if (((InterfaceEntry)this.i.derivedFrom().firstElement()).state() != null) {
                    this.stream.println("    super (impl);");
                } else {
                    this.stream.println("    super ();");
                }
                this.stream.println("    _impl = impl;");
                this.stream.println("  }");
                this.stream.println();
            }
        } else if (this.poa) {
            // empty if block
        }
    }

    private void writePOATieCtors() {
        this.stream.println("  public " + this.tieClassName + " ( " + this.intfName + "Operations delegate ) {");
        this.stream.println("      this._impl = delegate;");
        this.stream.println("  }");
        this.stream.println("  public " + this.tieClassName + " ( " + this.intfName + "Operations delegate , org.omg.PortableServer.POA poa ) {");
        this.stream.println("      this._impl = delegate;");
        this.stream.println("      this._poa      = poa;");
        this.stream.println("  }");
    }

    private void writePOATieFieldAccessMethods() {
        this.stream.println("  public " + this.intfName + "Operations _delegate() {");
        this.stream.println("      return this._impl;");
        this.stream.println("  }");
        this.stream.println("  public void _delegate (" + this.intfName + "Operations delegate ) {");
        this.stream.println("      this._impl = delegate;");
        this.stream.println("  }");
        this.stream.println("  public org.omg.PortableServer.POA _default_POA() {");
        this.stream.println("      if(_poa != null) {");
        this.stream.println("          return _poa;");
        this.stream.println("      }");
        this.stream.println("      else {");
        this.stream.println("          return super._default_POA();");
        this.stream.println("      }");
        this.stream.println("  }");
    }

    protected void buildMethodList() {
        this.methodList = new Vector();
        this.buildMethodList(this.i);
    }

    private void buildMethodList(InterfaceEntry interfaceEntry) {
        Enumeration enumeration = interfaceEntry.methods().elements();
        while (enumeration.hasMoreElements()) {
            this.addMethod((MethodEntry)enumeration.nextElement());
        }
        Enumeration enumeration2 = interfaceEntry.derivedFrom().elements();
        while (enumeration2.hasMoreElements()) {
            InterfaceEntry interfaceEntry2 = (InterfaceEntry)enumeration2.nextElement();
            if (interfaceEntry2.name().equals("Object")) continue;
            this.buildMethodList(interfaceEntry2);
        }
    }

    private void addMethod(MethodEntry methodEntry) {
        if (!this.methodList.contains(methodEntry)) {
            this.methodList.addElement(methodEntry);
        }
    }

    protected void writeDispatchMethod() {
        String string = "                                ";
        this.stream.println("  public org.omg.CORBA.portable.OutputStream _invoke (String $method,");
        this.stream.println(string + "org.omg.CORBA.portable.InputStream in,");
        this.stream.println(string + "org.omg.CORBA.portable.ResponseHandler $rh)");
        this.stream.println("  {");
        boolean bl = false;
        if (this.i instanceof InterfaceEntry) {
            bl = this.i.isLocalServant();
        }
        if (!bl) {
            this.stream.println("    org.omg.CORBA.portable.OutputStream out = null;");
            this.stream.println("    java.lang.Integer __method = (java.lang.Integer)_methods.get ($method);");
            this.stream.println("    if (__method == null)");
            this.stream.println("      throw new org.omg.CORBA.BAD_OPERATION (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
            this.stream.println();
            if (this.methodList.size() > 0) {
                this.stream.println("    switch (__method.intValue ())");
                this.stream.println("    {");
                int n = 0;
                int n2 = 0;
                while (n2 < this.methodList.size()) {
                    MethodEntry methodEntry = (MethodEntry)this.methodList.elementAt(n2);
                    ((MethodGen)methodEntry.generator()).dispatchSkeleton(this.symbolTable, methodEntry, this.stream, n);
                    n = methodEntry instanceof AttributeEntry && !((AttributeEntry)methodEntry).readOnly() ? (n += 2) : ++n;
                    ++n2;
                }
                string = "       ";
                this.stream.println(string + "default:");
                this.stream.println(string + "  throw new org.omg.CORBA.BAD_OPERATION (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
                this.stream.println("    }");
                this.stream.println();
            }
            this.stream.println("    return out;");
        } else {
            this.stream.println("    throw new org.omg.CORBA.BAD_OPERATION();");
        }
        this.stream.println("  } // _invoke");
        this.stream.println();
    }

    protected void writeMethodTable() {
        this.stream.println("  private static java.util.Hashtable _methods = new java.util.Hashtable ();");
        this.stream.println("  static");
        this.stream.println("  {");
        int n = -1;
        Enumeration enumeration = this.methodList.elements();
        while (enumeration.hasMoreElements()) {
            MethodEntry methodEntry = (MethodEntry)enumeration.nextElement();
            if (methodEntry instanceof AttributeEntry) {
                this.stream.println("    _methods.put (\"_get_" + Util.stripLeadingUnderscores(methodEntry.name()) + "\", new java.lang.Integer (" + ++n + "));");
                if (((AttributeEntry)methodEntry).readOnly()) continue;
                this.stream.println("    _methods.put (\"_set_" + Util.stripLeadingUnderscores(methodEntry.name()) + "\", new java.lang.Integer (" + ++n + "));");
                continue;
            }
            this.stream.println("    _methods.put (\"" + Util.stripLeadingUnderscores(methodEntry.name()) + "\", new java.lang.Integer (" + ++n + "));");
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeMethods() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.methodList.size()) {
            MethodEntry methodEntry = (MethodEntry)this.methodList.elementAt(n2);
            ((MethodGen)methodEntry.generator()).skeleton(this.symbolTable, methodEntry, this.stream, n);
            n = methodEntry instanceof AttributeEntry && !((AttributeEntry)methodEntry).readOnly() ? (n += 2) : ++n;
            this.stream.println();
            ++n2;
        }
    }

    private void writeIDs() {
        Vector vector = new Vector();
        this.buildIDList(this.i, vector);
        Enumeration enumeration = vector.elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                this.stream.println(", ");
            }
            this.stream.print("    \"" + (String)enumeration.nextElement() + '\"');
        }
    }

    private void buildIDList(InterfaceEntry interfaceEntry, Vector vector) {
        if (!interfaceEntry.fullName().equals("org/omg/CORBA/Object")) {
            String string = Util.stripLeadingUnderscoresFromID(interfaceEntry.repositoryID().ID());
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
            Enumeration enumeration = interfaceEntry.derivedFrom().elements();
            while (enumeration.hasMoreElements()) {
                this.buildIDList((InterfaceEntry)enumeration.nextElement(), vector);
            }
        }
    }

    protected void writeCORBAOperations() {
        this.stream.println("  // Type-specific CORBA::Object operations");
        this.stream.println("  private static String[] __ids = {");
        this.writeIDs();
        this.stream.println("};");
        this.stream.println();
        if (this.poa) {
            this.writePOACORBAOperations();
        } else {
            this.writeNonPOACORBAOperations();
        }
    }

    protected void writePOACORBAOperations() {
        this.stream.println("  public String[] _all_interfaces (org.omg.PortableServer.POA poa, byte[] objectId)");
        this.stream.println("  {");
        this.stream.println("    return (String[])__ids.clone ();");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public " + this.i.name() + " _this() ");
        this.stream.println("  {");
        this.stream.println("    return " + this.i.name() + "Helper.narrow(");
        this.stream.println("    super._this_object());");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public " + this.i.name() + " _this(org.omg.CORBA.ORB orb) ");
        this.stream.println("  {");
        this.stream.println("    return " + this.i.name() + "Helper.narrow(");
        this.stream.println("    super._this_object(orb));");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeNonPOACORBAOperations() {
        this.stream.println("  public String[] _ids ()");
        this.stream.println("  {");
        this.stream.println("    return (String[])__ids.clone ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeOperations() {
    }
}

