/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SingleByteCharsetConverter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtils {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes;
    private static char[] byteToChars;

    public static final byte[] getBytes(String s, String encoding, boolean parserKnowsUnicode) throws UnsupportedEncodingException {
        SingleByteCharsetConverter converter = SingleByteCharsetConverter.getInstance(encoding);
        return StringUtils.getBytes(s, converter, encoding, parserKnowsUnicode);
    }

    public static final byte[] getBytes(String s, SingleByteCharsetConverter converter, String encoding, boolean parserKnowsUnicode) throws UnsupportedEncodingException {
        byte[] b = null;
        if (converter != null) {
            b = converter.toBytes(s);
        } else if (encoding == null) {
            b = s.getBytes();
        } else {
            b = s.getBytes(encoding);
            if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK"))) {
                b = StringUtils.escapeEasternUnicodeByteStream(b, s, 0, s.length());
            }
        }
        return b;
    }

    public static final byte[] getBytes(String s, SingleByteCharsetConverter converter, String encoding, int offset, int length, boolean parserKnowsUnicode) throws UnsupportedEncodingException {
        byte[] b = null;
        if (converter != null) {
            b = converter.toBytes(s, offset, length);
        } else if (encoding == null) {
            byte[] temp = s.getBytes();
            b = new byte[length];
            System.arraycopy(temp, offset, b, 0, length);
        } else {
            byte[] temp = s.getBytes(encoding);
            b = new byte[length];
            System.arraycopy(temp, offset, b, 0, length);
            if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK"))) {
                b = StringUtils.escapeEasternUnicodeByteStream(b, s, offset, length);
            }
        }
        return b;
    }

    public static final void dumpAsHex(byte[] byteBuffer, int length) {
        int p = 0;
        int rows = length / 8;
        int i = 0;
        while (i < rows) {
            int ptemp = p;
            int j = 0;
            while (j < 8) {
                String hexVal = Integer.toHexString(byteBuffer[ptemp] & 0xFF);
                if (hexVal.length() == 1) {
                    hexVal = "0" + hexVal;
                }
                System.out.print(hexVal + " ");
                ++ptemp;
                ++j;
            }
            System.out.print("    ");
            int j2 = 0;
            while (j2 < 8) {
                if (byteBuffer[p] > 32 && byteBuffer[p] < 127) {
                    System.out.print((char)byteBuffer[p] + " ");
                } else {
                    System.out.print(". ");
                }
                ++p;
                ++j2;
            }
            System.out.println();
            ++i;
        }
        int n = 0;
        int i2 = p;
        while (i2 < length) {
            String hexVal = Integer.toHexString(byteBuffer[i2] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(hexVal + " ");
            ++n;
            ++i2;
        }
        int i3 = n;
        while (i3 < 8) {
            System.out.print("   ");
            ++i3;
        }
        System.out.print("    ");
        int i4 = p;
        while (i4 < length) {
            if (byteBuffer[i4] > 32 && byteBuffer[i4] < 127) {
                System.out.print((char)byteBuffer[i4] + " ");
            } else {
                System.out.print(". ");
            }
            ++i4;
        }
        System.out.println();
    }

    public static final String toAsciiString(byte[] buffer) {
        return StringUtils.toAsciiString(buffer, 0, buffer.length);
    }

    public static final String toAsciiString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        int i = 0;
        while (i < length) {
            charArray[i] = (char)buffer[readpoint];
            ++readpoint;
            ++i;
        }
        return new String(charArray);
    }

    public static byte[] escapeEasternUnicodeByteStream(byte[] origBytes, String origString, int offset, int length) {
        if (origBytes == null || origBytes.length == 0) {
            return origBytes;
        }
        int bytesLen = origBytes.length;
        int bufIndex = 0;
        int strIndex = 0;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(bytesLen);
        while (true) {
            if (origString.charAt(strIndex) == '\\') {
                bytesOut.write(origBytes[bufIndex++]);
            } else {
                int hiByte;
                int loByte = origBytes[bufIndex];
                if (loByte < 0) {
                    loByte += 256;
                }
                bytesOut.write(loByte);
                if (loByte >= 128) {
                    if (bufIndex < bytesLen - 1) {
                        hiByte = origBytes[bufIndex + 1];
                        if (hiByte < 0) {
                            hiByte += 256;
                        }
                        bytesOut.write(hiByte);
                        ++bufIndex;
                        if (hiByte == 92) {
                            bytesOut.write(hiByte);
                        }
                    }
                } else if (loByte == 92 && bufIndex < bytesLen - 1) {
                    hiByte = origBytes[bufIndex + 1];
                    if (hiByte < 0) {
                        hiByte += 256;
                    }
                    if (hiByte == 98) {
                        bytesOut.write(92);
                        bytesOut.write(98);
                        ++bufIndex;
                    }
                }
                ++bufIndex;
            }
            if (bufIndex >= bytesLen) break;
            ++strIndex;
        }
        return bytesOut.toByteArray();
    }

    public static char firstNonWsCharUc(String searchIn) {
        if (searchIn == null) {
            return '\u0000';
        }
        int length = searchIn.length();
        int i = 0;
        while (i < length) {
            char c = searchIn.charAt(i);
            if (!Character.isWhitespace(c)) {
                return Character.toUpperCase(c);
            }
            ++i;
        }
        return '\u0000';
    }

    public static final List split(String stringToSplit, String delimitter, boolean trim) {
        if (stringToSplit == null) {
            return new ArrayList();
        }
        if (delimitter == null) {
            throw new IllegalArgumentException();
        }
        StringTokenizer tokenizer = new StringTokenizer(stringToSplit, delimitter, false);
        ArrayList<String> splitTokens = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
        }
        return splitTokens;
    }

    public static boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return StringUtils.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, 0, searchFor, startAt, searchFor.length());
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        int beginPos = 0;
        int inLength = searchIn.length();
        beginPos = 0;
        while (beginPos < inLength) {
            if (!Character.isWhitespace(searchIn.charAt(beginPos))) break;
            ++beginPos;
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    static {
        BYTE_RANGE = 256;
        allBytes = new byte[256];
        byteToChars = new char[256];
        int i = -128;
        while (i <= 127) {
            StringUtils.allBytes[i - -128] = (byte)i;
            ++i;
        }
        String allBytesString = new String(allBytes, 0, 255);
        int allBytesStringLen = allBytesString.length();
        int i2 = 0;
        while (i2 < 255 && i2 < allBytesStringLen) {
            StringUtils.byteToChars[i2] = allBytesString.charAt(i2);
            ++i2;
        }
    }
}

