/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;

public abstract class Query
implements Serializable {
    protected float boost = 1.0f;

    abstract float sumOfSquaredWeights(Searcher var1) throws IOException;

    abstract void normalize(float var1);

    abstract Scorer scorer(IndexReader var1) throws IOException;

    void prepare(IndexReader indexReader) {
    }

    static Scorer scorer(Query query, Searcher searcher, IndexReader indexReader) throws IOException {
        query.prepare(indexReader);
        float f = query.sumOfSquaredWeights(searcher);
        float f2 = 1.0f / (float)Math.sqrt(f);
        query.normalize(f2);
        return query.scorer(indexReader);
    }

    public void setBoost(float f) {
        this.boost = f;
    }

    public float getBoost() {
        return this.boost;
    }

    public abstract String toString(String var1);
}

