/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.OutputStream;

final class TermInfosWriter {
    private FieldInfos fieldInfos;
    private OutputStream output;
    private Term lastTerm = new Term("", "");
    private TermInfo lastTi = new TermInfo();
    private int size = 0;
    static final int INDEX_INTERVAL = 128;
    private long lastIndexPointer = 0L;
    private boolean isIndex = false;
    private TermInfosWriter other = null;

    TermInfosWriter(Directory directory, String string, FieldInfos fieldInfos) throws IOException, SecurityException {
        this.initialize(directory, string, fieldInfos, false);
        this.other = new TermInfosWriter(directory, string, fieldInfos, true);
        this.other.other = this;
    }

    private TermInfosWriter(Directory directory, String string, FieldInfos fieldInfos, boolean bl) throws IOException {
        this.initialize(directory, string, fieldInfos, bl);
    }

    private void initialize(Directory directory, String string, FieldInfos fieldInfos, boolean bl) throws IOException {
        this.fieldInfos = fieldInfos;
        this.isIndex = bl;
        this.output = directory.createFile(string + (this.isIndex ? ".tii" : ".tis"));
        this.output.writeInt(0);
    }

    final void add(Term term, TermInfo termInfo) throws IOException, SecurityException {
        if (!this.isIndex && term.compareTo(this.lastTerm) <= 0) {
            throw new IOException("term out of order");
        }
        if (termInfo.freqPointer < this.lastTi.freqPointer) {
            throw new IOException("freqPointer out of order");
        }
        if (termInfo.proxPointer < this.lastTi.proxPointer) {
            throw new IOException("proxPointer out of order");
        }
        if (!this.isIndex && this.size % 128 == 0) {
            this.other.add(this.lastTerm, this.lastTi);
        }
        this.writeTerm(term);
        this.output.writeVInt(termInfo.docFreq);
        this.output.writeVLong(termInfo.freqPointer - this.lastTi.freqPointer);
        this.output.writeVLong(termInfo.proxPointer - this.lastTi.proxPointer);
        if (this.isIndex) {
            this.output.writeVLong(this.other.output.getFilePointer() - this.lastIndexPointer);
            this.lastIndexPointer = this.other.output.getFilePointer();
        }
        this.lastTi.set(termInfo);
        ++this.size;
    }

    private final void writeTerm(Term term) throws IOException {
        int n = TermInfosWriter.stringDifference(this.lastTerm.text, term.text);
        int n2 = term.text.length() - n;
        this.output.writeVInt(n);
        this.output.writeVInt(n2);
        this.output.writeChars(term.text, n, n2);
        this.output.writeVInt(this.fieldInfos.fieldNumber(term.field));
        this.lastTerm = term;
    }

    private static final int stringDifference(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = n2 < (n = string2.length()) ? n2 : n;
        int n4 = 0;
        while (n4 < n3) {
            if (string.charAt(n4) != string2.charAt(n4)) {
                return n4;
            }
            ++n4;
        }
        return n3;
    }

    final void close() throws IOException, SecurityException {
        this.output.seek(0L);
        this.output.writeInt(this.size);
        this.output.close();
        if (!this.isIndex) {
            this.other.close();
        }
    }
}

