/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.InputStream;

final class SegmentTermEnum
extends TermEnum
implements Cloneable {
    private InputStream input;
    private FieldInfos fieldInfos;
    int size;
    int position = -1;
    private Term term = new Term("", "");
    private TermInfo termInfo = new TermInfo();
    boolean isIndex = false;
    long indexPointer = 0L;
    Term prev;
    private char[] buffer = new char[0];

    SegmentTermEnum(InputStream inputStream, FieldInfos fieldInfos, boolean bl) throws IOException {
        this.input = inputStream;
        this.fieldInfos = fieldInfos;
        this.size = this.input.readInt();
        this.isIndex = bl;
    }

    protected Object clone() {
        SegmentTermEnum segmentTermEnum = null;
        try {
            segmentTermEnum = (SegmentTermEnum)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        segmentTermEnum.input = (InputStream)this.input.clone();
        segmentTermEnum.termInfo = new TermInfo(this.termInfo);
        if (this.term != null) {
            segmentTermEnum.growBuffer(this.term.text.length());
        }
        return segmentTermEnum;
    }

    final void seek(long l, int n, Term term, TermInfo termInfo) throws IOException {
        this.input.seek(l);
        this.position = n;
        this.term = term;
        this.prev = null;
        this.termInfo.set(termInfo);
        this.growBuffer(this.term.text.length());
    }

    public final boolean next() throws IOException {
        if (this.position++ >= this.size - 1) {
            this.term = null;
            return false;
        }
        this.prev = this.term;
        this.term = this.readTerm();
        this.termInfo.docFreq = this.input.readVInt();
        this.termInfo.freqPointer += this.input.readVLong();
        this.termInfo.proxPointer += this.input.readVLong();
        if (this.isIndex) {
            this.indexPointer += this.input.readVLong();
        }
        return true;
    }

    private final Term readTerm() throws IOException {
        int n;
        int n2 = this.input.readVInt();
        int n3 = n2 + (n = this.input.readVInt());
        if (this.buffer.length < n3) {
            this.growBuffer(n3);
        }
        this.input.readChars(this.buffer, n2, n);
        return new Term(this.fieldInfos.fieldName(this.input.readVInt()), new String(this.buffer, 0, n3), false);
    }

    private final void growBuffer(int n) {
        this.buffer = new char[n];
        int n2 = 0;
        while (n2 < this.term.text.length()) {
            this.buffer[n2] = this.term.text.charAt(n2);
            ++n2;
        }
    }

    public final Term term() {
        return this.term;
    }

    final TermInfo termInfo() {
        return new TermInfo(this.termInfo);
    }

    final void termInfo(TermInfo termInfo) {
        termInfo.set(this.termInfo);
    }

    public final int docFreq() {
        return this.termInfo.docFreq;
    }

    final long freqPointer() {
        return this.termInfo.freqPointer;
    }

    final long proxPointer() {
        return this.termInfo.proxPointer;
    }

    public final void close() throws IOException {
        this.input.close();
    }
}

