/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

public class GermanStemmer {
    private StringBuffer sb = new StringBuffer();
    private boolean uppercase = false;
    private int substCount = 0;

    protected String stem(String string) {
        if (!this.isStemmable(string)) {
            return string;
        }
        this.uppercase = Character.isUpperCase(string.charAt(0));
        string = string.toLowerCase();
        this.sb.delete(0, this.sb.length());
        this.sb.insert(0, string);
        this.sb = this.substitute(this.sb);
        if (this.uppercase && this.sb.length() > 3) {
            if (this.sb.substring(this.sb.length() - 3, this.sb.length()).equals("ern")) {
                this.sb.delete(this.sb.length() - 3, this.sb.length());
            } else if (this.sb.substring(this.sb.length() - 2, this.sb.length()).equals("en")) {
                this.sb.delete(this.sb.length() - 2, this.sb.length());
            } else if (this.sb.substring(this.sb.length() - 2, this.sb.length()).equals("er")) {
                this.sb.delete(this.sb.length() - 2, this.sb.length());
            } else if (this.sb.substring(this.sb.length() - 2, this.sb.length()).equals("es")) {
                this.sb.delete(this.sb.length() - 2, this.sb.length());
            } else if (this.sb.charAt(this.sb.length() - 1) == 'e') {
                this.sb.deleteCharAt(this.sb.length() - 1);
            } else if (this.sb.charAt(this.sb.length() - 1) == 'n') {
                this.sb.deleteCharAt(this.sb.length() - 1);
            } else if (this.sb.charAt(this.sb.length() - 1) == 's') {
                this.sb.deleteCharAt(this.sb.length() - 1);
            }
            if (this.sb.length() > 5 && this.sb.substring(this.sb.length() - 3, this.sb.length()).equals("erin*")) {
                this.sb.deleteCharAt(this.sb.length() - 1);
            }
            if (this.sb.charAt(this.sb.length() - 1) == 'z') {
                this.sb.setCharAt(this.sb.length() - 1, 'x');
            }
        } else {
            boolean bl = true;
            while (this.sb.length() > 3 && bl) {
                if (this.sb.length() + this.substCount > 5 && this.sb.substring(this.sb.length() - 2, this.sb.length()).equals("nd")) {
                    this.sb.delete(this.sb.length() - 2, this.sb.length());
                    continue;
                }
                if (this.sb.length() + this.substCount > 4 && this.sb.substring(this.sb.length() - 2, this.sb.length()).equals("er")) {
                    this.sb.delete(this.sb.length() - 2, this.sb.length());
                    continue;
                }
                if (this.sb.length() + this.substCount > 4 && this.sb.substring(this.sb.length() - 2, this.sb.length()).equals("em")) {
                    this.sb.delete(this.sb.length() - 2, this.sb.length());
                    continue;
                }
                if (this.sb.charAt(this.sb.length() - 1) == 't') {
                    this.sb.deleteCharAt(this.sb.length() - 1);
                    continue;
                }
                if (this.sb.charAt(this.sb.length() - 1) == 'n') {
                    this.sb.deleteCharAt(this.sb.length() - 1);
                    continue;
                }
                if (this.sb.charAt(this.sb.length() - 1) == 's') {
                    this.sb.deleteCharAt(this.sb.length() - 1);
                    continue;
                }
                if (this.sb.charAt(this.sb.length() - 1) == 'e') {
                    this.sb.deleteCharAt(this.sb.length() - 1);
                    continue;
                }
                bl = false;
            }
        }
        this.sb = this.resubstitute(this.sb);
        if (!this.uppercase) {
            this.sb = this.removeParticleDenotion(this.sb);
        }
        return this.sb.toString();
    }

    private StringBuffer removeParticleDenotion(StringBuffer stringBuffer) {
        int n = 0;
        while (n < stringBuffer.length()) {
            if (n < stringBuffer.length() - 4 && stringBuffer.charAt(n) == 'g' && stringBuffer.charAt(n + 1) == 'e') {
                stringBuffer.delete(0, n + 2);
            }
            ++n;
        }
        return this.sb;
    }

    private StringBuffer substitute(StringBuffer stringBuffer) {
        this.substCount = 0;
        int n = 0;
        while (n < stringBuffer.length()) {
            if (n > 0 && stringBuffer.charAt(n) == stringBuffer.charAt(n - 1)) {
                stringBuffer.setCharAt(n, '*');
            } else if (stringBuffer.charAt(n) == '\u00e4') {
                stringBuffer.setCharAt(n, 'a');
            } else if (stringBuffer.charAt(n) == '\u00f6') {
                stringBuffer.setCharAt(n, 'o');
            } else if (stringBuffer.charAt(n) == '\u00fc') {
                stringBuffer.setCharAt(n, 'u');
            }
            if (n < stringBuffer.length() - 1) {
                if (stringBuffer.charAt(n) == '\u00df') {
                    stringBuffer.setCharAt(n, 's');
                    stringBuffer.insert(n + 1, 's');
                    ++this.substCount;
                } else if (n < stringBuffer.length() - 2 && stringBuffer.charAt(n) == 's' && stringBuffer.charAt(n + 1) == 'c' && stringBuffer.charAt(n + 2) == 'h') {
                    stringBuffer.setCharAt(n, '$');
                    stringBuffer.delete(n + 1, n + 3);
                    this.substCount = 2;
                } else if (stringBuffer.charAt(n) == 'c' && stringBuffer.charAt(n + 1) == 'h') {
                    stringBuffer.setCharAt(n, '\u00a7');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                } else if (stringBuffer.charAt(n) == 'e' && stringBuffer.charAt(n + 1) == 'i') {
                    stringBuffer.setCharAt(n, '%');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                } else if (stringBuffer.charAt(n) == 'i' && stringBuffer.charAt(n + 1) == 'e') {
                    stringBuffer.setCharAt(n, '&');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                } else if (stringBuffer.charAt(n) == 'i' && stringBuffer.charAt(n + 1) == 'g') {
                    stringBuffer.setCharAt(n, '#');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                } else if (stringBuffer.charAt(n) == 's' && stringBuffer.charAt(n + 1) == 't') {
                    stringBuffer.setCharAt(n, '!');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                }
            }
            ++n;
        }
        return stringBuffer;
    }

    private boolean isStemmable(String string) {
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (!Character.isLetter(string.charAt(n2))) {
                return false;
            }
            if (Character.isUpperCase(string.charAt(n2))) {
                if (bl) {
                    return false;
                }
                n = n2;
                bl = true;
            }
            ++n2;
        }
        return n <= 0;
    }

    private StringBuffer resubstitute(StringBuffer stringBuffer) {
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '*') {
                char c = stringBuffer.charAt(n - 1);
                stringBuffer.setCharAt(n, c);
            } else if (stringBuffer.charAt(n) == '$') {
                stringBuffer.setCharAt(n, 's');
                stringBuffer.insert(n + 1, new char[]{'c', 'h'}, 0, 2);
            } else if (stringBuffer.charAt(n) == '\u00a7') {
                stringBuffer.setCharAt(n, 'c');
                stringBuffer.insert(n + 1, 'h');
            } else if (stringBuffer.charAt(n) == '%') {
                stringBuffer.setCharAt(n, 'e');
                stringBuffer.insert(n + 1, 'i');
            } else if (stringBuffer.charAt(n) == '&') {
                stringBuffer.setCharAt(n, 'i');
                stringBuffer.insert(n + 1, 'e');
            } else if (stringBuffer.charAt(n) == '#') {
                stringBuffer.setCharAt(n, 'i');
                stringBuffer.insert(n + 1, 'g');
            } else if (stringBuffer.charAt(n) == '!') {
                stringBuffer.setCharAt(n, 's');
                stringBuffer.insert(n + 1, 't');
            }
            ++n;
        }
        return stringBuffer;
    }
}

