/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import java.io.File;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Rmic;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.JavaEnvUtils;

public abstract class DefaultRmicAdapter
implements RmicAdapter {
    private Rmic attributes;
    private FileNameMapper mapper;
    private static final Random rand = new Random();

    public void setRmic(Rmic attributes) {
        this.attributes = attributes;
        this.mapper = new RmicFileNameMapper();
    }

    public Rmic getRmic() {
        return this.attributes;
    }

    protected String getStubClassSuffix() {
        return "_Stub";
    }

    protected String getSkelClassSuffix() {
        return "_Skel";
    }

    protected String getTieClassSuffix() {
        return "_Tie";
    }

    public FileNameMapper getMapper() {
        return this.mapper;
    }

    public Path getClasspath() {
        return this.getCompileClasspath();
    }

    protected Path getCompileClasspath() {
        Path classpath = new Path(this.attributes.getProject());
        classpath.setLocation(this.attributes.getBase());
        if (this.attributes.getClasspath() == null) {
            if (this.attributes.getIncludeantruntime()) {
                classpath.addExisting(Path.systemClasspath);
            }
        } else if (this.attributes.getIncludeantruntime()) {
            classpath.addExisting(this.attributes.getClasspath().concatSystemClasspath("last"));
        } else {
            classpath.addExisting(this.attributes.getClasspath().concatSystemClasspath("ignore"));
        }
        if (this.attributes.getIncludejavaruntime()) {
            classpath.addJavaRuntime();
        }
        return classpath;
    }

    protected Commandline setupRmicCommand() {
        return this.setupRmicCommand(null);
    }

    protected Commandline setupRmicCommand(String[] options) {
        Commandline cmd = new Commandline();
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                cmd.createArgument().setValue(options[i]);
                ++i;
            }
        }
        Path classpath = this.getCompileClasspath();
        cmd.createArgument().setValue("-d");
        cmd.createArgument().setFile(this.attributes.getBase());
        if (this.attributes.getExtdirs() != null) {
            if (JavaEnvUtils.isJavaVersion("1.1")) {
                classpath.addExtdirs(this.attributes.getExtdirs());
            } else {
                cmd.createArgument().setValue("-extdirs");
                cmd.createArgument().setPath(this.attributes.getExtdirs());
            }
        }
        cmd.createArgument().setValue("-classpath");
        cmd.createArgument().setPath(classpath);
        String stubVersion = this.attributes.getStubVersion();
        if (null != stubVersion) {
            if ("1.1".equals(stubVersion)) {
                cmd.createArgument().setValue("-v1.1");
            } else if ("1.2".equals(stubVersion)) {
                cmd.createArgument().setValue("-v1.2");
            } else {
                cmd.createArgument().setValue("-vcompat");
            }
        }
        if (null != this.attributes.getSourceBase()) {
            cmd.createArgument().setValue("-keepgenerated");
        }
        if (this.attributes.getIiop()) {
            this.attributes.log("IIOP has been turned on.", 2);
            cmd.createArgument().setValue("-iiop");
            if (this.attributes.getIiopopts() != null) {
                this.attributes.log("IIOP Options: " + this.attributes.getIiopopts(), 2);
                cmd.createArgument().setValue(this.attributes.getIiopopts());
            }
        }
        if (this.attributes.getIdl()) {
            cmd.createArgument().setValue("-idl");
            this.attributes.log("IDL has been turned on.", 2);
            if (this.attributes.getIdlopts() != null) {
                cmd.createArgument().setValue(this.attributes.getIdlopts());
                this.attributes.log("IDL Options: " + this.attributes.getIdlopts(), 2);
            }
        }
        if (this.attributes.getDebug()) {
            cmd.createArgument().setValue("-g");
        }
        cmd.addArguments(this.attributes.getCurrentCompilerArgs());
        this.logAndAddFilesToCompile(cmd);
        return cmd;
    }

    protected void logAndAddFilesToCompile(Commandline cmd) {
        Vector compileList = this.attributes.getCompileList();
        this.attributes.log("Compilation " + cmd.describeArguments(), 3);
        StringBuffer niceSourceList = new StringBuffer("File");
        if (compileList.size() != 1) {
            niceSourceList.append("s");
        }
        niceSourceList.append(" to be compiled:");
        int i = 0;
        while (i < compileList.size()) {
            String arg = (String)compileList.elementAt(i);
            cmd.createArgument().setValue(arg);
            niceSourceList.append("    " + arg);
            ++i;
        }
        this.attributes.log(niceSourceList.toString(), 3);
    }

    public abstract boolean execute() throws BuildException;

    private class RmicFileNameMapper
    implements FileNameMapper {
        RmicFileNameMapper() {
        }

        public void setFrom(String s) {
        }

        public void setTo(String s) {
        }

        public String[] mapFileName(String name) {
            if (name == null || !name.endsWith(".class") || name.endsWith(DefaultRmicAdapter.this.getStubClassSuffix() + ".class") || name.endsWith(DefaultRmicAdapter.this.getSkelClassSuffix() + ".class") || name.endsWith(DefaultRmicAdapter.this.getTieClassSuffix() + ".class")) {
                return null;
            }
            String base = name.substring(0, name.length() - 6);
            String classname = base.replace(File.separatorChar, '.');
            if (DefaultRmicAdapter.this.attributes.getVerify() && !DefaultRmicAdapter.this.attributes.isValidRmiRemote(classname)) {
                return null;
            }
            String[] target = new String[]{name + ".tmp." + rand.nextLong()};
            if (!DefaultRmicAdapter.this.attributes.getIiop() && !DefaultRmicAdapter.this.attributes.getIdl()) {
                target = "1.2".equals(DefaultRmicAdapter.this.attributes.getStubVersion()) ? new String[]{base + DefaultRmicAdapter.this.getStubClassSuffix() + ".class"} : new String[]{base + DefaultRmicAdapter.this.getStubClassSuffix() + ".class", base + DefaultRmicAdapter.this.getSkelClassSuffix() + ".class"};
            } else if (!DefaultRmicAdapter.this.attributes.getIdl()) {
                int lastSlash = base.lastIndexOf(File.separatorChar);
                String dirname = "";
                int index = -1;
                if (lastSlash == -1) {
                    index = 0;
                } else {
                    index = lastSlash + 1;
                    dirname = base.substring(0, index);
                }
                String filename = base.substring(index);
                try {
                    Class<?> c = DefaultRmicAdapter.this.attributes.getLoader().loadClass(classname);
                    if (c.isInterface()) {
                        target = new String[]{dirname + "_" + filename + DefaultRmicAdapter.this.getStubClassSuffix() + ".class"};
                    } else {
                        Class interf = DefaultRmicAdapter.this.attributes.getRemoteInterface(c);
                        String iName = interf.getName();
                        String iDir = "";
                        int iIndex = -1;
                        int lastDot = iName.lastIndexOf(".");
                        if (lastDot == -1) {
                            iIndex = 0;
                        } else {
                            iIndex = lastDot + 1;
                            iDir = iName.substring(0, iIndex);
                            iDir = iDir.replace('.', File.separatorChar);
                        }
                        target = new String[]{dirname + "_" + filename + DefaultRmicAdapter.this.getTieClassSuffix() + ".class", iDir + "_" + iName.substring(iIndex) + DefaultRmicAdapter.this.getStubClassSuffix() + ".class"};
                    }
                }
                catch (ClassNotFoundException e) {
                    DefaultRmicAdapter.this.attributes.log("Unable to verify class " + classname + ". It could not be found.", 1);
                }
                catch (NoClassDefFoundError e) {
                    DefaultRmicAdapter.this.attributes.log("Unable to verify class " + classname + ". It is not defined.", 1);
                }
                catch (Throwable t) {
                    DefaultRmicAdapter.this.attributes.log("Unable to verify class " + classname + ". Loading caused Exception: " + t.getMessage(), 1);
                }
            }
            return target;
        }
    }
}

