/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.fdf;

import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.fdf.FDFPageInfo;
import org.pdfbox.pdmodel.fdf.FDFTemplate;

public class FDFPage
implements COSObjectable {
    private COSDictionary page;

    public FDFPage() {
        this.page = new COSDictionary();
    }

    public FDFPage(COSDictionary p) {
        this.page = p;
    }

    public COSBase getCOSObject() {
        return this.page;
    }

    public COSDictionary getCOSDictionary() {
        return this.page;
    }

    public List getTemplates() {
        COSArrayList retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject("Templates");
        if (array != null) {
            ArrayList<FDFTemplate> objects = new ArrayList<FDFTemplate>();
            for (int i = 0; i < array.size(); ++i) {
                objects.add(new FDFTemplate((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(objects, array);
        }
        return retval;
    }

    public void setTemplates(List templates) {
        this.page.setItem("Templates", (COSBase)COSArrayList.converterToCOSArray(templates));
    }

    public FDFPageInfo getPageInfo() {
        FDFPageInfo retval = null;
        COSDictionary dict = (COSDictionary)this.page.getDictionaryObject("Info");
        if (dict != null) {
            retval = new FDFPageInfo(dict);
        }
        return retval;
    }

    public void setPageInfo(FDFPageInfo info) {
        this.page.setItem("Info", (COSObjectable)info);
    }
}

