/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.graphics.xobject.PDInlinedImage;
import org.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.pdfbox.util.ImageParameters;
import org.pdfbox.util.Matrix;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.PDFStreamEngine;
import org.pdfbox.util.ResourceLoader;
import org.pdfbox.util.TextPosition;

public class PageDrawer
extends PDFStreamEngine {
    private static Logger log = Logger.getLogger((Class)(class$org$pdfbox$util$PDFStreamEngine == null ? (class$org$pdfbox$util$PDFStreamEngine = PageDrawer.class$("org.pdfbox.util.PDFStreamEngine")) : class$org$pdfbox$util$PDFStreamEngine));
    private Graphics2D graphics;
    private Dimension pageSize;
    private PDPage page;
    private GeneralPath linePath = new GeneralPath();
    static /* synthetic */ Class class$org$pdfbox$util$PDFStreamEngine;

    public PageDrawer() throws IOException {
        super(ResourceLoader.loadProperties("Resources/PDFTextStripper.properties"));
    }

    public void drawPage(Graphics g, PDPage p, Dimension pageDimension) throws IOException {
        this.graphics = (Graphics2D)g;
        this.page = p;
        this.pageSize = pageDimension;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.processStream(p.getContents().getStream(), this.page.findResources());
        AffineTransform rotation = this.graphics.getTransform();
        rotation.rotate((double)this.page.findRotation() * Math.PI / 180.0);
        this.graphics.setTransform(rotation);
    }

    protected void showCharacter(TextPosition text) {
        try {
            this.graphics.setColor(Color.black);
            PDFont font = text.getFont();
            font.drawString(text.getCharacter(), this.graphics, text.getFontSize(), text.getXScale(), text.getYScale(), text.getX(), (int)(this.pageSize.getHeight() - (double)text.getY()));
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        super.processOperator(operator, arguments);
        String operation = operator.getOperation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processOperator( '" + operation + "' )"));
        }
        if (operation.equals("BI")) {
            ImageParameters params = operator.getImageParameters();
            PDInlinedImage image = new PDInlinedImage();
            image.setImageParameters(params);
            image.setImageData(operator.getImageData());
            BufferedImage awtImage = image.createImage();
            Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
            int width = awtImage.getWidth();
            int height = awtImage.getHeight();
            AffineTransform at = new AffineTransform(ctm.getValue(0, 0) / (float)width, ctm.getValue(0, 1), ctm.getValue(1, 0), ctm.getValue(1, 1) / (float)height, ctm.getValue(2, 0), ctm.getValue(2, 1));
            this.graphics.drawImage(awtImage, at, null);
        } else if (operation.equals("Do")) {
            COSName objectName = (COSName)arguments.get(0);
            Map xobjects = this.getResources().getXObjects();
            PDXObject xobject = (PDXObject)xobjects.get(objectName.getName());
            if (xobject instanceof PDXObjectImage) {
                PDXObjectImage image = (PDXObjectImage)xobject;
                try {
                    BufferedImage awtImage = image.getRGBImage();
                    Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
                    int width = awtImage.getWidth();
                    int height = awtImage.getHeight();
                    double rotationInRadians = (double)this.page.findRotation() * Math.PI / 180.0;
                    AffineTransform rotation = new AffineTransform();
                    rotation.setToRotation(rotationInRadians);
                    AffineTransform rotationInverse = rotation.createInverse();
                    Matrix rotationInverseMatrix = new Matrix();
                    rotationInverseMatrix.setFromAffineTransform(rotationInverse);
                    Matrix rotationMatrix = new Matrix();
                    rotationMatrix.setFromAffineTransform(rotation);
                    Matrix unrotatedCTM = ctm.multiply(rotationInverseMatrix);
                    Matrix scalingParams = unrotatedCTM.extractScaling();
                    Matrix scalingMatrix = Matrix.getScaleInstance(1.0f / (float)width, 1.0f / (float)height);
                    scalingParams = scalingParams.multiply(scalingMatrix);
                    Matrix translationParams = unrotatedCTM.extractTranslating();
                    Matrix translationMatrix = null;
                    int pageRotation = this.page.findRotation();
                    if (pageRotation == 0) {
                        translationMatrix = new Matrix();
                    } else if (pageRotation == 90) {
                        translationMatrix = Matrix.getTranslatingInstance(0.0f, (float)this.pageSize.getHeight());
                    }
                    translationParams = translationParams.multiply(translationMatrix);
                    AffineTransform at = new AffineTransform(scalingParams.getValue(0, 0), 0.0f, 0.0f, scalingParams.getValue(1, 1), translationParams.getValue(2, 0), translationParams.getValue(2, 1));
                    this.graphics.drawImage(awtImage, at, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("Unknown xobject type:" + xobject);
            }
        } else if (operation.equals("l")) {
            COSNumber x = (COSNumber)arguments.get(0);
            COSNumber y = (COSNumber)arguments.get(1);
            this.linePath.lineTo(x.floatValue(), (int)(this.pageSize.getHeight() - (double)y.floatValue()));
        } else if (operation.equals("m")) {
            COSNumber x = (COSNumber)arguments.get(0);
            COSNumber y = (COSNumber)arguments.get(1);
            this.linePath.reset();
            this.linePath.moveTo(x.floatValue(), (int)(this.pageSize.getHeight() - (double)y.floatValue()));
        } else if (operation.equals("re")) {
            COSNumber x = (COSNumber)arguments.get(0);
            COSNumber y = (COSNumber)arguments.get(1);
            COSNumber w = (COSNumber)arguments.get(2);
            COSNumber h = (COSNumber)arguments.get(3);
            Rectangle2D.Double rect = new Rectangle2D.Double(x.doubleValue(), this.pageSize.getHeight() - y.doubleValue(), w.doubleValue(), h.doubleValue());
            this.linePath.reset();
            this.linePath.append(rect, false);
        } else if (operation.equals("S")) {
            this.graphics.draw(this.linePath);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

