/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdfparser.BaseParser;
import org.pdfbox.pdfparser.PDFXref;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.fdf.FDFDocument;
import org.pdfbox.persistence.util.COSObjectKey;

public class PDFParser
extends BaseParser {
    private static Logger log = Logger.getLogger((Class)(class$org$pdfbox$pdfparser$PDFParser == null ? (class$org$pdfbox$pdfparser$PDFParser = PDFParser.class$("org.pdfbox.pdfparser.PDFParser")) : class$org$pdfbox$pdfparser$PDFParser));
    private static final int SPACE_BYTE = 32;
    private static final String PDF_HEADER = "%PDF-";
    private COSDocument document;
    private File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
    private RandomAccessFile raf = null;
    static /* synthetic */ Class class$org$pdfbox$pdfparser$PDFParser;

    public PDFParser(InputStream input) throws IOException {
        this(input, null);
    }

    public PDFParser(InputStream input, RandomAccessFile rafi) throws IOException {
        super(input);
        this.raf = rafi;
    }

    public void setTempDirectory(File tmpDir) {
        this.tempDirectory = tmpDir;
    }

    public void parse() throws IOException {
        block20: {
            try {
                this.document = this.raf == null ? new COSDocument(this.tempDirectory) : new COSDocument(this.raf);
                this.setDocument(this.document);
                String header = this.readLine();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Header=" + header));
                }
                this.document.setHeaderString(header);
                if (header.length() < PDF_HEADER.length() + 1) {
                    throw new IOException("Error: Header is corrupt '" + header + "'");
                }
                int headerStart = header.indexOf(PDF_HEADER);
                if (headerStart > 0) {
                    header = header.substring(headerStart, header.length());
                }
                try {
                    float pdfVersion = Float.parseFloat(header.substring(PDF_HEADER.length(), Math.min(header.length(), PDF_HEADER.length() + 3)));
                    this.document.setVersion(pdfVersion);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Error getting pdf version:" + e);
                }
                this.skipHeaderFillBytes();
                boolean wasLastParsedObjectAnXref = false;
                try {
                    Object nextObject;
                    while ((nextObject = this.parseObject()) != null) {
                        if (nextObject instanceof PDFXref) {
                            PDFXref xref = (PDFXref)nextObject;
                            this.addXref(xref);
                            wasLastParsedObjectAnXref = true;
                        } else {
                            wasLastParsedObjectAnXref = false;
                        }
                        this.skipSpaces();
                    }
                    if (this.document.getTrailer() == null) {
                        COSDictionary trailer = new COSDictionary();
                        Iterator xrefIter = this.document.getObjectsByType("XRef").iterator();
                        while (xrefIter.hasNext()) {
                            COSStream next = (COSStream)((COSObject)xrefIter.next()).getObject();
                            trailer.addAll(next);
                        }
                        this.document.setTrailer(trailer);
                    }
                    if (!this.document.isEncrypted()) {
                        this.document.dereferenceObjectStreams();
                    }
                }
                catch (IOException e) {
                    if (wasLastParsedObjectAnXref) {
                        log.debug((Object)"Skipping some garbage");
                        break block20;
                    }
                    throw e;
                }
            }
            catch (IOException io) {
                if (this.document != null) {
                    this.document.close();
                }
                throw io;
            }
            finally {
                this.pdfSource.close();
            }
        }
    }

    protected void skipHeaderFillBytes() throws IOException {
        this.skipSpaces();
        int c = this.pdfSource.peek();
        if (c >= 128) {
            this.readLine();
        }
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    public PDDocument getPDDocument() throws IOException {
        return new PDDocument(this.getDocument());
    }

    public FDFDocument getFDFDocument() throws IOException {
        return new FDFDocument(this.getDocument());
    }

    private Object parseObject() throws IOException {
        Object object = null;
        char peekedChar = (char)this.pdfSource.peek();
        if (log.isDebugEnabled()) {
            log.debug((Object)("PDFParser.parseObject() peek='" + peekedChar + "'"));
        }
        if (this.pdfSource.isEOF()) {
            log.debug((Object)"Skipping because of EOF");
        } else if (peekedChar == 'x' || peekedChar == 't' || peekedChar == 's') {
            String eof;
            if (peekedChar == 'x' || peekedChar == 't') {
                object = this.parseXrefSection();
            }
            if (peekedChar == 'x' || peekedChar == 's') {
                this.skipSpaces();
                while (this.pdfSource.peek() == 120) {
                    this.parseXrefSection();
                }
                String startxref = this.readString();
                if (!startxref.equals("startxref")) {
                    throw new IOException("expected='startxref' actual='" + startxref + "' " + this.pdfSource);
                }
                this.skipSpaces();
                this.readInt();
            }
            if ((eof = this.readExpectedString("%%EOF")).indexOf("%%EOF") == -1 && !this.pdfSource.isEOF()) {
                throw new IOException("expected='%%EOF' actual='" + eof + "' next=" + this.readString() + " next=" + this.readString());
            }
            if (!this.pdfSource.isEOF() && this.pdfSource.available() < 1000) {
                byte[] data = new byte[1000];
                int amountRead = this.pdfSource.read(data);
                if (amountRead != -1) {
                    this.pdfSource.unread(data, 0, amountRead);
                }
                boolean atEndOfFile = true;
                for (int i = 0; i < amountRead - 3 && atEndOfFile; ++i) {
                    atEndOfFile = data[i] != 69 || data[i + 1] != 79 || data[i + 2] != 70;
                }
                if (atEndOfFile) {
                    while (this.pdfSource.read(data, 0, data.length) != -1) {
                    }
                }
            }
        } else {
            block25: {
                int number;
                String objectKey = null;
                try {
                    number = this.readInt();
                }
                catch (IOException e) {
                    number = this.readInt();
                }
                this.skipSpaces();
                int genNum = this.readInt();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing object (" + number + "," + genNum + ")"));
                }
                if (!(objectKey = this.readString(3)).equals("obj")) {
                    throw new IOException("expected='obj' actual='" + objectKey + "' " + this.pdfSource);
                }
                this.skipSpaces();
                COSBase pb = this.parseDirObject();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    this.pdfSource.unread(endObjectKey.getBytes());
                    this.pdfSource.unread(32);
                    if (!(pb instanceof COSDictionary)) {
                        throw new IOException("stream not preceded by dictionary");
                    }
                    pb = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile());
                    endObjectKey = this.readString();
                }
                COSObjectKey key = new COSObjectKey(number, genNum);
                COSObject pdfObject = this.document.getObjectFromPool(key);
                object = pdfObject;
                pdfObject.setObject(pb);
                if (!endObjectKey.equals("endobj") && !this.pdfSource.isEOF()) {
                    try {
                        Float.parseFloat(endObjectKey);
                        this.pdfSource.unread(32);
                        this.pdfSource.unread(endObjectKey.getBytes());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Missing endobj, found '" + endObjectKey + "' instead, assuming that endobj is not present and will continue parsing."));
                        }
                    }
                    catch (NumberFormatException e) {
                        String secondEndObjectKey = this.readString();
                        if (secondEndObjectKey.equals("endobj")) break block25;
                        throw new IOException("expected='endobj' firstReadAttempt='" + endObjectKey + "' " + "secondReadAttempt='" + secondEndObjectKey + " " + this.pdfSource);
                    }
                }
            }
            this.skipSpaces();
        }
        return object;
    }

    private PDFXref parseXrefSection() throws IOException {
        int start = 0;
        int count = 0;
        String nextLine = null;
        nextLine = this.readLine();
        if (nextLine.equals("xref")) {
            start = this.readInt();
            count = this.readInt();
            nextLine = this.readString();
        }
        this.skipSpaces();
        while (!(nextLine.equals("trailer") || this.pdfSource.isEOF() || this.isEndOfName((char)this.pdfSource.peek()))) {
            nextLine = this.readString();
            this.skipSpaces();
        }
        this.skipSpaces();
        COSDictionary parsedTrailer = this.parseCOSDictionary();
        COSDictionary docTrailer = this.document.getTrailer();
        if (log.isDebugEnabled()) {
            log.debug((Object)("parsedTrailer=" + parsedTrailer));
            log.debug((Object)("docTrailer=" + docTrailer));
        }
        if (docTrailer == null) {
            this.document.setTrailer(parsedTrailer);
        } else {
            docTrailer.addAll(parsedTrailer);
        }
        return new PDFXref(start, count);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

