/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.pdfbox.afmparser.AFMParser;
import org.pdfbox.afmtypes.FontMetric;
import org.pdfbox.cmapparser.CMapParser;
import org.pdfbox.cmaptypes.CMap;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.encoding.AFMEncoding;
import org.pdfbox.encoding.DictionaryEncoding;
import org.pdfbox.encoding.Encoding;
import org.pdfbox.encoding.EncodingManager;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.util.ResourceLoader;

public abstract class PDFont
implements COSObjectable {
    private static Category log = Category.getInstance((String)(class$org$pdfbox$pdmodel$font$PDFont == null ? (class$org$pdfbox$pdmodel$font$PDFont = PDFont.class$("org.pdfbox.pdmodel.font.PDFont")) : class$org$pdfbox$pdmodel$font$PDFont).getName());
    protected COSDictionary font;
    private Encoding fontEncoding = null;
    private CMap cmap = null;
    private static Map afmResources = null;
    private static Map cmapObjects = null;
    private static Map afmObjects = null;
    static /* synthetic */ Class class$org$pdfbox$pdmodel$font$PDFont;

    public static void clearResources() {
        afmObjects.clear();
        cmapObjects.clear();
    }

    public PDFont() {
        this.font = new COSDictionary();
        this.font.setItem(COSName.TYPE, COSName.FONT);
    }

    public PDFont(COSDictionary fontDictionary) {
        this.font = fontDictionary;
    }

    public COSBase getCOSObject() {
        return this.font;
    }

    public abstract float getFontWidth(byte[] var1, int var2, int var3) throws IOException;

    public abstract void drawString(String var1, Graphics var2, float var3, float var4, float var5) throws IOException;

    protected int getCodeFromArray(byte[] data, int offset, int length) {
        int code = 0;
        int i = 0;
        while (i < length) {
            code <<= 8;
            code = (data[offset + i] + 256) % 256;
            ++i;
        }
        return code;
    }

    protected float getFontWidthFromAFMFile(int code) throws IOException {
        FontMetric metric;
        float retval = 0.0f;
        COSName baseFont = (COSName)this.font.getDictionaryObject(COSName.BASE_FONT);
        if (baseFont != null && (metric = this.getAFM(baseFont)) != null) {
            Encoding encoding = this.getEncoding();
            COSName characterName = encoding.getName(code);
            retval = metric.getCharacterWidth(characterName.getName());
        }
        return retval;
    }

    private FontMetric getAFM(COSName name) throws IOException {
        FontMetric result = (FontMetric)afmObjects.get(name);
        if (result == null) {
            String resource = (String)afmResources.get(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("resource: " + resource + ", name: " + name.getName()));
            }
            if (resource != null) {
                InputStream afmStream = ResourceLoader.loadResource(resource);
                if (afmStream == null) {
                    throw new IOException("Can't handle font width:" + resource);
                }
                AFMParser parser = new AFMParser(afmStream);
                parser.parse();
                result = parser.getResult();
                afmObjects.put(name, result);
            }
        }
        return result;
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        String retval = new String(c);
        COSName fontSubtype = (COSName)this.font.getDictionaryObject(COSName.getPDFName("Subtype"));
        if (fontSubtype.getName().equals("Type0") || fontSubtype.getName().equals("TrueType")) {
            if (this.cmap == null) {
                COSName encodingName = null;
                InputStream cmapStream = null;
                if (this.font.getDictionaryObject(COSName.getPDFName("ToUnicode")) != null) {
                    retval = "";
                    COSStream toUnicode = (COSStream)this.font.getDictionaryObject(COSName.getPDFName("ToUnicode"));
                    if (toUnicode != null) {
                        cmapStream = toUnicode.getUnfilteredStream();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Getting embedded CMAP Stream from ToUnicode");
                        }
                    }
                } else {
                    COSBase encoding = this.font.getDictionaryObject(COSName.ENCODING);
                    if (encoding instanceof COSStream) {
                        COSStream encodingStream = (COSStream)encoding;
                        cmapStream = encodingStream.getUnfilteredStream();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Getting embedded CMAP Stream from encoding");
                        }
                    } else if (fontSubtype.getName().equals("Type0") && encoding instanceof COSName) {
                        encodingName = (COSName)encoding;
                        if (cmapObjects.get(encodingName) != null) {
                            this.cmap = (CMap)cmapObjects.get(encodingName);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Getting CMAP Stream from resource");
                            }
                            if ((cmapStream = ResourceLoader.loadResource("Resources/cmap/" + encodingName.getName())) == null) {
                                throw new IOException("Error: Could not find predefined CMAP file for '" + encodingName.getName() + "'");
                            }
                        }
                    } else if (encoding instanceof COSName || encoding instanceof COSDictionary) {
                        Encoding fontEncoding = this.getEncoding();
                        if (fontEncoding != null) {
                            retval = fontEncoding.getCharacter(this.getCodeFromArray(c, offset, length));
                        }
                    } else {
                        COSDictionary fontDescriptor = (COSDictionary)this.font.getDictionaryObject(COSName.getPDFName("FontDescriptor"));
                        if (fontSubtype.getName().equals("TrueType") && fontDescriptor != null && (fontDescriptor.getDictionaryObject(COSName.getPDFName("FontFile")) != null || fontDescriptor.getDictionaryObject(COSName.getPDFName("FontFile2")) != null || fontDescriptor.getDictionaryObject(COSName.getPDFName("FontFile3")) != null)) {
                            retval = new String(c, offset, length);
                        } else {
                            throw new IOException("Error: No 'ToUnicode' and no 'Encoding' for Font");
                        }
                    }
                }
                if (this.cmap == null && cmapStream != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Parsing a new CMAP for font:" + this.font));
                    }
                    CMapParser parser = new CMapParser(cmapStream, null);
                    parser.parse();
                    this.cmap = parser.getResult();
                    if (encodingName != null) {
                        cmapObjects.put(encodingName, this.cmap);
                    }
                    retval = this.cmap.lookup(c, offset, length);
                }
            }
        } else {
            Encoding encoding = this.getEncoding();
            if (encoding != null) {
                retval = encoding.getCharacter(this.getCodeFromArray(c, offset, length));
            }
        }
        return retval;
    }

    private Encoding getEncoding() throws IOException {
        EncodingManager manager = new EncodingManager();
        if (this.fontEncoding == null) {
            COSBase encoding = this.font.getDictionaryObject(COSName.ENCODING);
            if (encoding == null) {
                COSName baseFont = (COSName)this.font.getDictionaryObject(COSName.BASE_FONT);
                if (baseFont != null && afmResources.get(baseFont) != null) {
                    this.fontEncoding = new AFMEncoding(this.getAFM(baseFont));
                }
                if (this.fontEncoding == null) {
                    this.fontEncoding = manager.getStandardEncoding();
                }
            } else if (encoding instanceof COSDictionary) {
                COSDictionary encodingDic = (COSDictionary)this.font.getDictionaryObject(COSName.ENCODING);
                this.fontEncoding = new DictionaryEncoding(encodingDic);
            } else if (encoding instanceof COSName) {
                if (!encoding.equals(COSName.IDENTITY_H)) {
                    this.fontEncoding = manager.getEncoding((COSName)encoding);
                }
            } else {
                throw new IOException("Unexpected encoding type:" + encoding.getClass().getName());
            }
        }
        return this.fontEncoding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        afmResources = new HashMap();
        cmapObjects = new HashMap();
        afmObjects = new HashMap();
        afmResources.put(COSName.getPDFName("Courier-Bold"), "Resources/afm/COB_____.AFM");
        afmResources.put(COSName.getPDFName("Courier-BoldOblique"), "Resources/afm/COBO____.AFM");
        afmResources.put(COSName.getPDFName("Courier"), "Resources/afm/COM_____.AFM");
        afmResources.put(COSName.getPDFName("Courier-Oblique"), "Resources/afm/COO_____.AFM");
        afmResources.put(COSName.getPDFName("Helvetica"), "Resources/afm/HV______.AFM");
        afmResources.put(COSName.getPDFName("Helvetica-Bold"), "Resources/afm/HVB_____.AFM");
        afmResources.put(COSName.getPDFName("Helvetica-BoldOblique"), "Resources/afm/HVBO____.AFM");
        afmResources.put(COSName.getPDFName("Helvetica-Oblique"), "Resources/afm/HVO_____.AFM");
        afmResources.put(COSName.getPDFName("Anna"), "Resources/afm/IARG____.AFM");
        afmResources.put(COSName.getPDFName("PopplLaudatio-Italic"), "Resources/afm/PYI_____.AFM");
        afmResources.put(COSName.getPDFName("PopplLaudatio-Medium"), "Resources/afm/PYM_____.AFM");
        afmResources.put(COSName.getPDFName("PopplLaudatio-MediumItalic"), "Resources/afm/PYMI____.AFM");
        afmResources.put(COSName.getPDFName("PopplLaudatio-Regular"), "Resources/afm/PYRG____.AFM");
        afmResources.put(COSName.getPDFName("Boulevard"), "Resources/afm/QTRG____.AFM");
        afmResources.put(COSName.getPDFName("Symbol"), "Resources/afm/SY______.AFM");
        afmResources.put(COSName.getPDFName("Times-Bold"), "Resources/afm/TIB_____.AFM");
        afmResources.put(COSName.getPDFName("Times-BoldItalic"), "Resources/afm/TIBI____.AFM");
        afmResources.put(COSName.getPDFName("Times-Italic"), "Resources/afm/TII_____.AFM");
        afmResources.put(COSName.getPDFName("Times-Roman"), "Resources/afm/TIR_____.AFM");
        afmResources.put(COSName.getPDFName("Boton-Italic"), "Resources/afm/TNI_____.AFM");
        afmResources.put(COSName.getPDFName("Boton-Medium"), "Resources/afm/TNM_____.AFM");
        afmResources.put(COSName.getPDFName("Boton-MediumItalic"), "Resources/afm/TNMI____.AFM");
        afmResources.put(COSName.getPDFName("Boton-Regular"), "Resources/afm/TNR_____.AFM");
        afmResources.put(COSName.getPDFName("BaskervilleBE-Italic"), "Resources/afm/VII_____.AFM");
        afmResources.put(COSName.getPDFName("BaskervilleBE-Medium"), "Resources/afm/VIM_____.AFM");
        afmResources.put(COSName.getPDFName("BaskervilleBE-MediumItalic"), "Resources/afm/VIMI____.AFM");
        afmResources.put(COSName.getPDFName("BaskervilleBE-Regular"), "Resources/afm/VIRG____.AFM");
        afmResources.put(COSName.getPDFName("Giddyup"), "Resources/afm/WG______.AFM");
        afmResources.put(COSName.getPDFName("Giddyup-Thangs"), "Resources/afm/WGTHA______.AFM");
        afmResources.put(COSName.getPDFName("ZapfDingbats"), "Resources/afm/ZapfDingbats.AFM");
    }
}

