/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.common.COSObjectable;

public class COSArrayList
implements List {
    private COSArray array;
    private List actual;

    public COSArrayList(List actualList, COSArray cosArray) {
        this.actual = actualList;
        this.array = cosArray;
    }

    public int size() {
        return this.actual.size();
    }

    public boolean isEmpty() {
        return this.actual.isEmpty();
    }

    public boolean contains(Object o) {
        return this.actual.contains(o);
    }

    public Iterator iterator() {
        return this.actual.iterator();
    }

    public Object[] toArray() {
        return this.actual.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.actual.toArray(a);
    }

    public boolean add(Object o) {
        if (o instanceof String) {
            this.array.add(new COSString((String)o));
        } else {
            this.array.add(((COSObjectable)o).getCOSObject());
        }
        return this.actual.add(o);
    }

    public boolean remove(Object o) {
        if (o instanceof String) {
            this.array.remove(new COSString((String)o));
        } else {
            this.array.remove(((COSObjectable)o).getCOSObject());
        }
        return this.actual.remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.actual.containsAll(c);
    }

    public boolean addAll(Collection c) {
        this.array.addAll(this.toCOSObjectList(c));
        return this.actual.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.array.addAll(index, this.toCOSObjectList(c));
        return this.actual.addAll(index, c);
    }

    public static List convertIntegerCOSArrayToList(COSArray intArray) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        int i = 0;
        while (i < intArray.size()) {
            numbers.add(new Integer(((COSNumber)intArray.get(i)).intValue()));
            ++i;
        }
        return new COSArrayList(numbers, intArray);
    }

    public static List convertFloatCOSArrayToList(COSArray floatArray) {
        ArrayList<Float> numbers = new ArrayList<Float>();
        int i = 0;
        while (i < floatArray.size()) {
            numbers.add(new Float(((COSNumber)floatArray.get(i)).floatValue()));
            ++i;
        }
        return new COSArrayList(numbers, floatArray);
    }

    public static COSArray converterToCOSArray(List cosObjectableList) {
        COSArray array = new COSArray();
        Iterator iter = cosObjectableList.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof String) {
                array.add(new COSString((String)next));
                continue;
            }
            if (next instanceof Integer || next instanceof Long) {
                array.add(new COSInteger(((Number)next).longValue()));
                continue;
            }
            if (next instanceof Float || next instanceof Double) {
                array.add(new COSFloat(((Number)next).floatValue()));
                continue;
            }
            if (next instanceof COSObjectable) {
                COSObjectable object = (COSObjectable)next;
                array.add(object.getCOSObject());
                continue;
            }
            if (next == null) {
                array.add(COSNull.NULL);
                continue;
            }
            throw new RuntimeException("Error: Don't know how to convert type to COSBase '" + next.getClass().getName() + "'");
        }
        return array;
    }

    private List toCOSObjectList(Collection list) {
        ArrayList<COSBase> cosObjects = new ArrayList<COSBase>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof String) {
                cosObjects.add(new COSString((String)next));
                continue;
            }
            COSObjectable object = (COSObjectable)iter.next();
            cosObjects.add(object.getCOSObject());
        }
        return cosObjects;
    }

    public boolean removeAll(Collection c) {
        this.array.removeAll(this.toCOSObjectList(c));
        return this.actual.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.array.retainAll(this.toCOSObjectList(c));
        return this.actual.retainAll(c);
    }

    public void clear() {
        this.actual.clear();
        this.array.clear();
    }

    public boolean equals(Object o) {
        return this.actual.equals(o);
    }

    public int hashCode() {
        return this.actual.hashCode();
    }

    public Object get(int index) {
        return this.actual.get(index);
    }

    public Object set(int index, Object element) {
        if (element instanceof String) {
            this.array.set(index, new COSString((String)element));
        } else {
            this.array.set(index, ((COSObjectable)element).getCOSObject());
        }
        return this.actual.set(index, element);
    }

    public void add(int index, Object element) {
        this.actual.add(index, element);
        if (element instanceof String) {
            this.array.add(index, new COSString((String)element));
        } else {
            this.array.add(index, ((COSObjectable)element).getCOSObject());
        }
    }

    public Object remove(int index) {
        this.array.remove(index);
        return this.actual.remove(index);
    }

    public int indexOf(Object o) {
        return this.actual.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.actual.indexOf(o);
    }

    public ListIterator listIterator() {
        return this.actual.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.actual.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.actual.subList(fromIndex, toIndex);
    }
}

