/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.encryption.PDFEncryption;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.pdfbox.pdmodel.encryption.PDEncryptionManager;
import org.pdfbox.pdmodel.encryption.PDStandardEncryption;

public class PDDocument {
    private COSDocument document;
    private PDDocumentInformation documentInformation;
    private PDDocumentCatalog documentCatalog;

    public PDDocument() throws IOException {
        this.document = new COSDocument();
        COSDictionary trailer = new COSDictionary();
        this.document.setTrailer(trailer);
        COSDictionary rootDictionary = new COSDictionary();
        COSObject root = new COSObject(rootDictionary);
        this.document.addObject(root);
        trailer.setItem(COSName.getPDFName("Root"), root);
        rootDictionary.setItem(COSName.getPDFName("Type"), COSName.getPDFName("Catalog"));
        rootDictionary.setItem(COSName.getPDFName("Version"), COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        COSObject pagesObject = new COSObject(pages);
        this.document.addObject(pagesObject);
        rootDictionary.setItem(COSName.getPDFName("Pages"), pagesObject);
        pages.setItem(COSName.getPDFName("Type"), COSName.getPDFName("Pages"));
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.getPDFName("Kids"), kidsArray);
        pages.setItem(COSName.getPDFName("Count"), new COSInteger(0));
    }

    public void addPage(PDPage page) {
        PDPageNode rootPages = this.getDocumentCatalog().getPages();
        rootPages.getKids().add(page);
        page.setParent(rootPages);
        rootPages.updateCount();
    }

    public void importPage(PDPage page) throws IOException {
        OutputStream os;
        block6: {
            InputStream is = null;
            os = null;
            try {
                PDPage importedPage = new PDPage(new COSDictionary(page.getCOSDictionary()));
                COSStream src = page.getContents();
                COSStream dest = new COSStream(src.getDictionary(), this.document.getScratchFile());
                importedPage.setContents(dest);
                os = dest.createUnfilteredStream();
                byte[] buf = new byte[10240];
                int amountRead = 0;
                is = src.getUnfilteredStream();
                while ((amountRead = is.read(buf, 0, 10240)) > -1) {
                    os.write(buf, 0, amountRead);
                }
                this.addPage(importedPage);
                Object var10_9 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
    }

    public PDDocument(COSDocument doc) {
        this.document = doc;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            COSName infoName = COSName.getPDFName("Info");
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(infoName);
            if (infoDic == null) {
                infoDic = new COSDictionary();
                trailer.setItem(infoName, infoDic);
            }
            this.documentInformation = new PDDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(COSName.getPDFName("Info"), info.getDictionary());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = infoDic == null ? new PDDocumentCatalog(this) : new PDDocumentCatalog(this, infoDic);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryptionDictionary getEncryptionDictionary() throws IOException {
        return PDEncryptionManager.getEncryptionDictionary(this.document.getEncryptionDictionary());
    }

    public boolean isUserPassword(String password) throws IOException, CryptographyException {
        boolean retval = false;
        PDFEncryption encryptor = new PDFEncryption();
        PDEncryptionDictionary encryptionDictionary = this.getEncryptionDictionary();
        if (encryptionDictionary == null) {
            throw new IOException("Error: Document is not encrypted");
        }
        if (!(encryptionDictionary instanceof PDStandardEncryption)) {
            throw new IOException("Error: Encyption dictionary is not 'Standard'" + encryptionDictionary.getClass().getName());
        }
        COSString documentID = (COSString)this.document.getDocumentID().get(0);
        PDStandardEncryption standard = (PDStandardEncryption)encryptionDictionary;
        retval = encryptor.isUserPassword(password.getBytes(), standard.getUserKey(), standard.getOwnerKey(), standard.getPermissions(), documentID.getBytes(), standard.getRevision(), standard.getLength());
        return retval;
    }

    public boolean isOwnerPassword(String password) throws IOException, CryptographyException {
        boolean retval = false;
        PDFEncryption encryptor = new PDFEncryption();
        PDEncryptionDictionary encryptionDictionary = this.getEncryptionDictionary();
        if (encryptionDictionary == null) {
            throw new IOException("Error: Document is not encrypted");
        }
        if (!(encryptionDictionary instanceof PDStandardEncryption)) {
            throw new IOException("Error: Encyption dictionary is not 'Standard'" + encryptionDictionary.getClass().getName());
        }
        COSString documentID = (COSString)this.document.getDocumentID().get(0);
        PDStandardEncryption standard = (PDStandardEncryption)encryptionDictionary;
        retval = encryptor.isOwnerPassword(password.getBytes(), standard.getUserKey(), standard.getOwnerKey(), standard.getPermissions(), documentID.getBytes(), standard.getRevision(), standard.getLength());
        return retval;
    }

    public int getPageCount() throws IOException {
        COSObject catalog = this.document.getCatalog();
        COSObject pages = (COSObject)catalog.getItem(COSName.PAGES);
        return this.getPageCount(pages);
    }

    private int getPageCount(COSObject pages) {
        COSArray pagesArray = (COSArray)pages.getDictionaryObject(COSName.KIDS);
        int pagecount = 0;
        if (pagesArray != null) {
            int i = 0;
            while (i < pagesArray.size()) {
                COSObject pageChild = (COSObject)pagesArray.get(i);
                pagecount += this.getPageCount(pageChild);
                ++i;
            }
        } else {
            ++pagecount;
        }
        return pagecount;
    }

    public void close() throws IOException {
        this.document.close();
    }
}

