/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.uncjournals;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.neoref.config.Config;

public class QueryUNCJournals {
    public static void main(String[] args) throws Exception {
        String title;
        Connection dbConn = null;
        Vector<String> facultyPublishedSet = new Vector<String>();
        Vector<String> librarySubscribedSet = new Vector<String>();
        Vector<String> uncSubscribedSet = new Vector<String>();
        if (args.length < 1) {
            System.out.println("Usage: queryUNCJournals xls");
            System.out.println("queryUNCJournals ../data/uncjournals.xls");
            System.exit(-1);
        }
        FileOutputStream fos = new FileOutputStream(args[0]);
        WritableWorkbook wbk = Workbook.createWorkbook((OutputStream)fos);
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        dbConn = DriverManager.getConnection(Config.UNCJOURNALSDB_STR);
        Statement stmt = dbConn.createStatement();
        String sql = "SELECT sourceTitle FROM facultyPublished";
        ResultSet rs = stmt.executeQuery(sql);
        rs.beforeFirst();
        while (rs.next()) {
            facultyPublishedSet.add(rs.getString("sourceTitle"));
        }
        sql = "SELECT printTitleName FROM librarySubscribed";
        rs = stmt.executeQuery(sql);
        rs.beforeFirst();
        while (rs.next()) {
            librarySubscribedSet.add(rs.getString("printTitleName"));
        }
        sql = "SELECT title FROM uncSubscribed";
        rs = stmt.executeQuery(sql);
        rs.beforeFirst();
        while (rs.next()) {
            uncSubscribedSet.add(rs.getString("title"));
        }
        WritableSheet sheet = wbk.createSheet("group1", 0);
        sql = "SELECT facultyPublished.sourceTitle, facultyPublished.groupCount, facultyPublished.year, librarySubscribed.publisherName FROM facultyPublished, librarySubscribed WHERE (facultyPublished.sourceTitle = librarySubscribed.printTitleName)";
        rs = stmt.executeQuery(sql);
        sheet.addCell((WritableCell)new Label(0, 0, "Journal Name"));
        sheet.addCell((WritableCell)new Label(1, 0, "Year"));
        sheet.addCell((WritableCell)new Label(2, 0, "Group Count"));
        sheet.addCell((WritableCell)new Label(3, 0, "Publisher"));
        sheet.addCell((WritableCell)new Label(4, 0, "UNC Published"));
        sheet.addCell((WritableCell)new Label(5, 0, "UNC Subscribed"));
        int i = 1;
        rs.beforeFirst();
        while (rs.next()) {
            sheet.addCell((WritableCell)new Label(0, i, rs.getString("sourceTitle")));
            sheet.addCell((WritableCell)new Label(1, i, rs.getString("year")));
            sheet.addCell((WritableCell)new Number(2, i, (double)Integer.parseInt(rs.getString("groupCount"))));
            sheet.addCell((WritableCell)new Label(3, i, rs.getString("publisherName")));
            sheet.addCell((WritableCell)new Label(4, i, "yes"));
            sheet.addCell((WritableCell)new Label(5, i, "yes"));
            ++i;
        }
        sheet = wbk.createSheet("group2", 0);
        sql = "SELECT facultyPublished.sourceTitle, facultyPublished.groupCount, facultyPublished.year, uncSubscribed.publisher FROM facultyPublished, uncSubscribed WHERE (facultyPublished.sourceTitle = uncSubscribed.title)";
        rs = stmt.executeQuery(sql);
        sheet.addCell((WritableCell)new Label(0, 0, "Journal Name"));
        sheet.addCell((WritableCell)new Label(1, 0, "Year"));
        sheet.addCell((WritableCell)new Label(2, 0, "Group Count"));
        sheet.addCell((WritableCell)new Label(3, 0, "Publisher"));
        sheet.addCell((WritableCell)new Label(4, 0, "UNC Published"));
        sheet.addCell((WritableCell)new Label(5, 0, "UNC Subscribed"));
        i = 1;
        rs.beforeFirst();
        while (rs.next()) {
            sheet.addCell((WritableCell)new Label(0, i, rs.getString("sourceTitle")));
            sheet.addCell((WritableCell)new Label(1, i, rs.getString("year")));
            sheet.addCell((WritableCell)new Number(2, i, (double)Integer.parseInt(rs.getString("groupCount"))));
            sheet.addCell((WritableCell)new Label(3, i, rs.getString("publisher")));
            sheet.addCell((WritableCell)new Label(4, i, "yes"));
            sheet.addCell((WritableCell)new Label(5, i, "yes"));
            ++i;
        }
        sheet = wbk.createSheet("group3", 0);
        sql = "SELECT printTitleName, publisherName FROM librarySubscribed";
        rs = stmt.executeQuery(sql);
        sheet.addCell((WritableCell)new Label(0, 0, "Journal Name"));
        sheet.addCell((WritableCell)new Label(1, 0, "Year"));
        sheet.addCell((WritableCell)new Label(2, 0, "Group Count"));
        sheet.addCell((WritableCell)new Label(3, 0, "Publisher"));
        sheet.addCell((WritableCell)new Label(4, 0, "UNC Published"));
        sheet.addCell((WritableCell)new Label(5, 0, "UNC Subscribed"));
        i = 1;
        rs.beforeFirst();
        while (rs.next()) {
            title = rs.getString("printTitleName");
            if (facultyPublishedSet.contains(title)) {
                --i;
            } else {
                sheet.addCell((WritableCell)new Label(0, i, title));
                sheet.addCell((WritableCell)new Label(1, i, ""));
                sheet.addCell((WritableCell)new Label(2, i, ""));
                sheet.addCell((WritableCell)new Label(3, i, rs.getString("publisherName")));
                sheet.addCell((WritableCell)new Label(4, i, "no"));
                sheet.addCell((WritableCell)new Label(5, i, "yes"));
            }
            ++i;
        }
        sheet = wbk.createSheet("group4", 0);
        sql = "SELECT title, publisher FROM uncSubscribed";
        rs = stmt.executeQuery(sql);
        sheet.addCell((WritableCell)new Label(0, 0, "Journal Name"));
        sheet.addCell((WritableCell)new Label(1, 0, "Year"));
        sheet.addCell((WritableCell)new Label(2, 0, "Group Count"));
        sheet.addCell((WritableCell)new Label(3, 0, "Publisher"));
        sheet.addCell((WritableCell)new Label(4, 0, "UNC Published"));
        sheet.addCell((WritableCell)new Label(5, 0, "UNC Subscribed"));
        i = 1;
        rs.beforeFirst();
        while (rs.next()) {
            title = rs.getString("title");
            if (facultyPublishedSet.contains(title)) {
                --i;
            } else {
                sheet.addCell((WritableCell)new Label(0, i, title));
                sheet.addCell((WritableCell)new Label(1, i, ""));
                sheet.addCell((WritableCell)new Label(2, i, ""));
                sheet.addCell((WritableCell)new Label(3, i, rs.getString("publisher")));
                sheet.addCell((WritableCell)new Label(4, i, "no"));
                sheet.addCell((WritableCell)new Label(5, i, "yes"));
            }
            ++i;
        }
        sheet = wbk.createSheet("group5", 0);
        sql = "SELECT sourceTitle, year, groupCount FROM facultyPublished";
        rs = stmt.executeQuery(sql);
        sheet.addCell((WritableCell)new Label(0, 0, "Journal Name"));
        sheet.addCell((WritableCell)new Label(1, 0, "Year"));
        sheet.addCell((WritableCell)new Label(2, 0, "Group Count"));
        sheet.addCell((WritableCell)new Label(3, 0, "Publisher"));
        sheet.addCell((WritableCell)new Label(4, 0, "UNC Published"));
        sheet.addCell((WritableCell)new Label(5, 0, "UNC Subscribed"));
        i = 1;
        rs.beforeFirst();
        while (rs.next()) {
            title = rs.getString("sourceTitle");
            if (librarySubscribedSet.contains(title)) {
                --i;
            } else if (uncSubscribedSet.contains(title)) {
                --i;
            } else {
                sheet.addCell((WritableCell)new Label(0, i, title));
                sheet.addCell((WritableCell)new Label(1, i, rs.getString("year")));
                sheet.addCell((WritableCell)new Number(2, i, (double)Integer.parseInt(rs.getString("groupCount"))));
                sheet.addCell((WritableCell)new Label(3, i, ""));
                sheet.addCell((WritableCell)new Label(4, i, "yes"));
                sheet.addCell((WritableCell)new Label(5, i, "no"));
            }
            ++i;
        }
        rs.close();
        wbk.write();
        wbk.close();
    }
}

