/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.uncjournals;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Vector;
import jxl.Sheet;
import jxl.Workbook;
import org.neoref.config.Config;
import org.neoref.uncjournals.ExcelUtil;

public class InsertUNCJournals {
    public static void main(String[] args) throws Exception {
        int i;
        Connection dbConn = null;
        if (args.length < 3) {
            System.out.println("Usage: insertUNCJournals faculty-published library-subscriptions unc-subscriptions");
            System.out.println("insertUNCJournals ../data/master-list-faculty-published.xls ../data/EBSCO-titles.xls ../data/harrs-stripped.xls");
            System.exit(-1);
        }
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        dbConn = DriverManager.getConnection(Config.UNCJOURNALSDB_STR);
        Statement stmt = dbConn.createStatement();
        String facultyPublished = args[0];
        String librarySubscribed = args[1];
        String uncSubscribed = args[2];
        Workbook wbk = Workbook.getWorkbook((File)new File(facultyPublished));
        Vector<ExcelUtil> columns = new Vector<ExcelUtil>();
        columns.add(new ExcelUtil("sourceTitle", "VARCHAR", 100, null, true));
        columns.add(new ExcelUtil("groupCount", "INT", 50, null));
        columns.add(new ExcelUtil("year", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("publisher", "VARCHAR", 100, null));
        ExcelUtil.createTable(columns, true, dbConn, "facultyPublished");
        Sheet sheet = wbk.getSheet("Sheet1");
        int numRows = sheet.getRows();
        for (i = 1; i < numRows; ++i) {
            ExcelUtil.addRow(columns, sheet, i, dbConn, "facultyPublished");
        }
        wbk = Workbook.getWorkbook((File)new File(librarySubscribed));
        columns = new Vector();
        columns.add(new ExcelUtil("printTitleName", "VARCHAR", 100, null, true, true, 47));
        columns.add(new ExcelUtil("printISSN", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("hegis", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("copyrightCleaningCenter", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("publisherName", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("peerReview", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("subjectHeading", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("titleComment1", "TEXT", -1, null));
        columns.add(new ExcelUtil("titleComment2", "TEXT", -1, null));
        columns.add(new ExcelUtil("titleComment3", "TEXT", -1, null));
        ExcelUtil.createTable(columns, true, dbConn, "librarySubscribed");
        sheet = wbk.getSheet("Original");
        numRows = sheet.getRows();
        for (i = 1; i < numRows; ++i) {
            ExcelUtil.addRow(columns, sheet, i, dbConn, "librarySubscribed");
        }
        wbk = Workbook.getWorkbook((File)new File(uncSubscribed));
        columns = new Vector();
        columns.add(new ExcelUtil("publisher", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("title", "VARCHAR", 100, null, true));
        columns.add(new ExcelUtil("electISSN", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("printISSN", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("publicationType", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("medium", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("titleSpecification", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("comment", "TEXT", -1, null));
        columns.add(new ExcelUtil("frequency", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("customerNumber", "INT", 50, null));
        columns.add(new ExcelUtil("customerCode", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("libraryOrderNumber", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("fund", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("sna", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("snp", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("fromDate", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("priceType", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("noServiceCharge", "VARCHAR", 1, null));
        columns.add(new ExcelUtil("price", "VARCHAR", 50, null));
        columns.add(new ExcelUtil("journalURL", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("publisherURL", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("ingentaURL", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("metaPressURL", "VARCHAR", 100, null));
        columns.add(new ExcelUtil("extenzaURL", "VARCHAR", 100, null));
        ExcelUtil.createTable(columns, true, dbConn, "uncSubscribed");
        sheet = wbk.getSheet("XII-SER Loop June 2005");
        numRows = sheet.getRows();
        for (i = 1; i < numRows; ++i) {
            ExcelUtil.addRow(columns, sheet, i, dbConn, "uncSubscribed");
        }
        System.out.println("Finished!");
    }
}

