/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.spider;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.neoref.config.Config;
import org.neoref.spider.MeshAddHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MeshAdder
extends Thread {
    int start;
    int end;
    int step;
    int interval;
    String journalName;
    static int count = 0;
    static int checkdup = 0;

    MeshAdder(int start, int end, int step, String journalName, int interval) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.journalName = journalName;
        this.interval = interval;
    }

    public void run() {
        try {
            String articlePath = new String();
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            Connection dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
            Statement st = dbConn.createStatement();
            URL esearchURL = new URL("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&term=" + this.journalName + "[ta]&usehistory=y");
            URLConnection conn = esearchURL.openConnection();
            InputStream is = conn.getInputStream();
            InputSource source = new InputSource(is);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(source);
            count = Integer.parseInt(xmlDoc.getElementsByTagName("Count").item(0).getFirstChild().getNodeValue());
            String webEnv = xmlDoc.getElementsByTagName("WebEnv").item(0).getFirstChild().getNodeValue();
            int query_key = Integer.parseInt(xmlDoc.getElementsByTagName("QueryKey").item(0).getFirstChild().getNodeValue());
            if (this.end < 0) {
                this.end = count - 1;
            } else if (this.end > count) {
                this.end = count - 1;
            }
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            MeshAddHandler handler = new MeshAddHandler();
            parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            for (int retstart = this.start; retstart <= this.end; retstart += this.step) {
                if (retstart + this.step > this.end && this.step > 1) {
                    this.step = 1;
                }
                MeshAdder.log("Fetch a list of articles from " + retstart);
                URL efetchURL = new URL("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&WebEnv=" + webEnv + "&query_key=" + query_key + "&retstart=" + retstart + "&retmax=" + this.step + "&retmode=xml");
                conn = efetchURL.openConnection();
                is = conn.getInputStream();
                source = new InputSource(is);
                try {
                    parser.parse(source);
                }
                catch (Exception e) {
                    MeshAdder.log("XML Error Message: " + e.getMessage() + ", skip article...");
                    retstart = retstart + count + 1;
                    MeshAdder.log("Recover automatically from article: " + retstart);
                    retstart -= this.step;
                    count = 0;
                    esearchURL = new URL("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&term=" + this.journalName + "[ta]&usehistory=y");
                    conn = esearchURL.openConnection();
                    is = conn.getInputStream();
                    source = new InputSource(is);
                    dbf = DocumentBuilderFactory.newInstance();
                    db = dbf.newDocumentBuilder();
                    xmlDoc = db.parse(source);
                    webEnv = xmlDoc.getElementsByTagName("WebEnv").item(0).getFirstChild().getNodeValue();
                    query_key = Integer.parseInt(xmlDoc.getElementsByTagName("QueryKey").item(0).getFirstChild().getNodeValue());
                    MeshAdder.log("Backoff before recovery...");
                    MeshAdder.sleep(this.interval / 2);
                    continue;
                }
                MeshAdder.log("Sleeping...");
                MeshAdder.sleep(this.interval);
            }
            MeshAdder.log("Done with meshadd");
        }
        catch (Exception e) {
            MeshAdder.log("General Error Message: " + e.getMessage());
        }
    }

    public static void log(String entry) {
        System.out.println(new Date() + ":" + entry);
    }

    public static void main(String[] args) throws Exception {
        String cfgStr = "";
        String journalName = "";
        int start = 0;
        int end = 0;
        int step = 0;
        int interval = 0;
        if (args.length < 1) {
            System.out.println("Usage: meshadd config-file");
            System.exit(-1);
        }
        BufferedReader cfgIn = new BufferedReader(new FileReader(args[0]));
        while ((cfgStr = cfgIn.readLine()) != null) {
            if (cfgStr.startsWith("#")) continue;
            StringTokenizer st = new StringTokenizer(cfgStr, " ");
            if (st.hasMoreTokens()) {
                start = Integer.parseInt(st.nextToken()) - 1;
            } else {
                System.out.println("bad config file");
                System.exit(-1);
            }
            if (st.hasMoreTokens()) {
                end = Integer.parseInt(st.nextToken()) - 1;
            } else {
                System.out.println("bad config file");
                System.exit(-1);
            }
            if (st.hasMoreTokens()) {
                step = Integer.parseInt(st.nextToken());
            } else {
                System.out.println("bad config file");
                System.exit(-1);
            }
            if (st.hasMoreTokens()) {
                journalName = st.nextToken();
            } else {
                System.out.println("bad config file");
                System.exit(-1);
            }
            if (st.hasMoreTokens()) {
                interval = Integer.parseInt(st.nextToken()) * 1000;
            } else {
                System.out.println("bad config file");
                System.exit(-1);
            }
            if (st.hasMoreTokens()) {
                checkdup = Integer.parseInt(st.nextToken());
            } else {
                System.out.println("bad config file");
                System.exit(-1);
            }
            MeshAdder.log("Handling " + journalName);
            MeshAdder ma = new MeshAdder(start, end, step, journalName, interval);
            ma.start();
            ma.join();
        }
    }
}

