/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.snp;

import java.sql.Connection;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;

public class TextUtil {
    private String name;
    private String type;
    private int length;
    private String value;

    public TextUtil(String name, String type, int length, String value) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.value = value;
    }

    public static String cleanVARCHAR(String str) {
        Perl5Util util = new Perl5Util();
        str = util.substitute("s/[']/\\\\'/g", str);
        return str;
    }

    public static String cleanINT(String str) {
        Perl5Util util = new Perl5Util();
        return (str = util.substitute("s/[,]//g", str)).length() == 0 ? "-1" : str;
    }

    public static String cleanFLOAT(String str) {
        Perl5Util util = new Perl5Util();
        return (str = util.substitute("s/[,]//g", str)).length() == 0 ? "-1" : str;
    }

    public static void createTable(Vector columns, boolean usePKey, Connection dbConn, String table) throws Exception {
        TextUtil tutil;
        int i;
        System.out.println("Creating table " + table);
        String sql = "create table " + table + "(";
        if (usePKey) {
            sql = sql + "id int auto_increment,";
        }
        int size = columns.size();
        for (i = 0; i < size - 1; ++i) {
            tutil = (TextUtil)columns.elementAt(i);
            sql = tutil.type.equals("TEXT") ? sql + tutil.name + " " + tutil.type + "," : sql + tutil.name + " " + tutil.type + "(" + tutil.length + "),";
        }
        tutil = (TextUtil)columns.elementAt(i);
        sql = tutil.type.equals("TEXT") ? sql + tutil.name + " " + tutil.type : sql + tutil.name + " " + tutil.type + "(" + tutil.length + ")";
        if (usePKey) {
            sql = sql + ", primary key(id)";
        }
        sql = sql + ")";
        System.out.println("sql is " + sql);
        Statement stmt = dbConn.createStatement();
        stmt.execute(sql);
    }

    public static void addRow(Vector columns, String line, String delim, int rowIdx, Connection dbConn, String table) throws Exception {
        TextUtil tutil;
        int i;
        boolean inSpace = false;
        System.out.println("Adding row " + rowIdx + " of " + table);
        StringTokenizer st = new StringTokenizer(line, delim, true);
        int size = columns.size();
        for (i = 0; i < size; ++i) {
            String str = st.nextToken();
            if (str.equals(delim)) {
                if (!inSpace && (str = st.nextToken()).equals(delim)) {
                    inSpace = true;
                }
            } else {
                inSpace = false;
            }
            tutil = (TextUtil)columns.elementAt(i);
            tutil.value = tutil.type.endsWith("CHAR") || tutil.type.startsWith("TEXT") ? TextUtil.cleanVARCHAR(str) : (tutil.type.startsWith("INT") ? TextUtil.cleanINT(str) : TextUtil.cleanFLOAT(str));
            columns.setElementAt(tutil, i);
        }
        String sql = "insert into " + table + "(";
        size = columns.size();
        for (i = 0; i < size - 1; ++i) {
            tutil = (TextUtil)columns.elementAt(i);
            sql = sql + tutil.name + ",";
        }
        tutil = (TextUtil)columns.elementAt(i);
        sql = sql + tutil.name;
        sql = sql + ") values (";
        size = columns.size();
        for (i = 0; i < size - 1; ++i) {
            tutil = (TextUtil)columns.elementAt(i);
            sql = sql + "'" + tutil.value + "',";
        }
        tutil = (TextUtil)columns.elementAt(i);
        sql = sql + "'" + tutil.value + "'";
        sql = sql + ")";
        Statement stmt = dbConn.createStatement();
        stmt.executeUpdate(sql);
    }
}

