/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.snp;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Vector;
import jxl.Cell;
import jxl.Sheet;
import org.apache.oro.text.perl.Perl5Util;

public class ExcelUtil {
    private String name;
    private String type;
    private int length;
    private String value;

    public ExcelUtil(String name, String type, int length, String value) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.value = value;
    }

    public static String cleanVARCHAR(Cell cell) {
        Perl5Util util = new Perl5Util();
        String str = cell.getContents();
        str = util.substitute("s/[']/\\\\'/g", str);
        return str;
    }

    public static String cleanINT(Cell cell) {
        Perl5Util util = new Perl5Util();
        String str = cell.getContents();
        return (str = util.substitute("s/[,]//g", str)).length() == 0 ? "-1" : str;
    }

    public static String cleanFLOAT(Cell cell) {
        Perl5Util util = new Perl5Util();
        String str = cell.getContents();
        return (str = util.substitute("s/[,]//g", str)).length() == 0 ? "-1" : str;
    }

    public static void createTable(Vector columns, boolean usePKey, Connection dbConn, String table) throws Exception {
        ExcelUtil eutil;
        int i;
        System.out.println("Creating table " + table);
        String sql = "create table " + table + "(";
        if (usePKey) {
            sql = sql + "id int auto_increment,";
        }
        int size = columns.size();
        for (i = 0; i < size - 1; ++i) {
            eutil = (ExcelUtil)columns.elementAt(i);
            sql = eutil.type.equals("TEXT") ? sql + eutil.name + " " + eutil.type + "," : sql + eutil.name + " " + eutil.type + "(" + eutil.length + "),";
        }
        eutil = (ExcelUtil)columns.elementAt(i);
        sql = eutil.type.equals("TEXT") ? sql + eutil.name + " " + eutil.type : sql + eutil.name + " " + eutil.type + "(" + eutil.length + ")";
        if (usePKey) {
            sql = sql + ", primary key(id)";
        }
        sql = sql + ")";
        System.out.println("sql is " + sql);
        Statement stmt = dbConn.createStatement();
        stmt.execute(sql);
    }

    public static void addRow(Vector columns, Sheet sheet, int rowIdx, Connection dbConn, String table) throws Exception {
        ExcelUtil eutil;
        int i;
        System.out.println("Adding row " + rowIdx + " of " + table);
        int size = columns.size();
        for (i = 0; i < size; ++i) {
            Cell cell = sheet.getCell(i, rowIdx);
            eutil = (ExcelUtil)columns.elementAt(i);
            eutil.value = eutil.type.endsWith("CHAR") || eutil.type.startsWith("TEXT") ? ExcelUtil.cleanVARCHAR(cell) : (eutil.type.startsWith("INT") ? ExcelUtil.cleanINT(cell) : ExcelUtil.cleanFLOAT(cell));
            columns.setElementAt(eutil, i);
        }
        String sql = "insert into " + table + "(";
        size = columns.size();
        for (i = 0; i < size - 1; ++i) {
            eutil = (ExcelUtil)columns.elementAt(i);
            sql = sql + eutil.name + ",";
        }
        eutil = (ExcelUtil)columns.elementAt(i);
        sql = sql + eutil.name;
        sql = sql + ") values (";
        size = columns.size();
        for (i = 0; i < size - 1; ++i) {
            eutil = (ExcelUtil)columns.elementAt(i);
            sql = sql + "'" + eutil.value + "',";
        }
        eutil = (ExcelUtil)columns.elementAt(i);
        sql = sql + "'" + eutil.value + "'";
        sql = sql + ")";
        Statement stmt = dbConn.createStatement();
        stmt.executeUpdate(sql);
    }
}

