/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.query;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.lucene.queryParser.TokenMgrError;
import org.neoref.core.DC;
import org.neoref.core.Meta;
import org.neoref.query.NRQuery;
import org.neoref.query.QueryArgs;
import org.neoref.query.QueryResults;

public class SimpleSearchServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger((Class)(class$org$neoref$query$SimpleSearchServlet == null ? (class$org$neoref$query$SimpleSearchServlet = SimpleSearchServlet.class$("org.neoref.query.SimpleSearchServlet")) : class$org$neoref$query$SimpleSearchServlet));
    static /* synthetic */ Class class$org$neoref$query$SimpleSearchServlet;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String advanced;
        DC.init();
        Meta.getConnected();
        String[] qArray = new String[DC.DCN_FT];
        String simplequery = request.getParameter("simplesearch");
        String tmp = request.getParameter("start");
        int start = 0;
        String useCluster = request.getParameter("useCluster");
        String cluster = request.getParameter("cluster");
        String stateful = request.getParameter("stateful");
        String referredPage = request.getParameter("referredPage");
        String firstState = request.getParameter("firstState");
        String history = request.getParameter("history");
        int numLevel = 0;
        int offset = 0;
        int cutoff = -15;
        if (simplequery == null) {
            simplequery = "";
        }
        if (tmp != null && !tmp.equals("")) {
            start = new Integer(tmp);
        }
        if (start < 0) {
            start = 0;
        }
        if ((advanced = request.getParameter("advanced")) == null) {
            advanced = "false";
        }
        int number = start;
        String tmp2 = request.getParameter("number");
        if (tmp2 != null && !tmp2.equals("")) {
            number = new Integer(tmp2);
        }
        if (number < -1) {
            number = 0;
        }
        int view = 1;
        String tmp3 = request.getParameter("view");
        if (tmp3 != null && !tmp3.equals("")) {
            view = new Integer(tmp3);
        }
        if (view < -1) {
            view = 3;
        }
        QueryResults qResults = null;
        QueryArgs qArgs = new QueryArgs();
        qArray = qArgs.buildQuery(request, advanced, simplequery);
        qArgs.setQuery(qArray[0]);
        qArgs.setStart(start);
        try {
            Calendar prev = Calendar.getInstance();
            if (useCluster != null && useCluster.equals("true")) {
                if (referredPage.equals("results") && cluster != null && !cluster.equals("null") && !cluster.equals("") && stateful != null && stateful.equals("yes")) {
                    HttpSession session = request.getSession(true);
                    qResults = (QueryResults)session.getValue("queryresults");
                } else {
                    qResults = NRQuery.doQuery(qArgs, true);
                }
            } else {
                qResults = NRQuery.doQuery(qArgs, false);
            }
            Calendar cur = Calendar.getInstance();
            long elapsed = cur.getTimeInMillis() - prev.getTimeInMillis();
            log.debug((Object)("time elapsed (ms) for index access: " + elapsed));
            if (useCluster == null) {
                log.debug((Object)"useCluster is null");
            }
            if (useCluster != null && useCluster.equals("true") && referredPage.equals("results")) {
                numLevel = new Integer(request.getParameter("numlevel"));
                cutoff = new Integer(request.getParameter("cutoff"));
                offset = new Integer(request.getParameter("offset"));
                log.debug((Object)("cutoff is " + cutoff));
                log.debug((Object)("offset is " + offset));
                log.debug((Object)("new cutoff is " + (cutoff += offset)));
                if (cluster != null && !cluster.equals("null") && !cluster.equals("")) {
                    log.debug((Object)("cluster is " + cluster));
                    if (offset == 0) {
                        int i;
                        int size;
                        List<String> hitIDs = qResults.getHitIDs();
                        Hashtable idTable = Meta.meshView((List)hitIDs, (int)cutoff);
                        Vector idVec = (Vector)idTable.get(cluster);
                        if (idVec == null) {
                            qResults.setHitCount(0);
                        } else {
                            hitIDs = new ArrayList();
                            size = idVec.size();
                            for (i = 0; i < size; ++i) {
                                hitIDs.add((String)idVec.elementAt(i));
                            }
                            qResults.setHitIDs(hitIDs);
                            qResults.setHitCount(size);
                        }
                        hitIDs = qResults.getAllHitIDs();
                        idTable = Meta.meshView(hitIDs, (int)cutoff);
                        idVec = (Vector)idTable.get(cluster);
                        hitIDs = new ArrayList();
                        size = idVec.size();
                        for (i = 0; i < size; ++i) {
                            hitIDs.add((String)idVec.elementAt(i));
                        }
                        qResults.setAllHitIDs(hitIDs);
                        qResults.setAllHitCount(size);
                        if (qResults.getAllHitCount() > qResults.getHitCount() && qResults.getHitCount() < qArgs.getPageSize()) {
                            qResults.setHitIDs(hitIDs);
                        }
                    }
                    if (stateful != null && stateful.equals("yes")) {
                        if (history == null || history.equals("null") || history.equals("")) {
                            history = "Root|" + cluster;
                        } else if (!history.endsWith("|" + cluster)) {
                            history = history + "|" + cluster;
                        }
                    }
                } else {
                    history = "";
                }
                cur = Calendar.getInstance();
                elapsed = cur.getTimeInMillis() - prev.getTimeInMillis();
                log.debug((Object)("time elapsed (ms) for clustering: " + elapsed));
            }
            log.debug((Object)("no. of hitIDs: " + qResults.getHitCount()));
            log.debug((Object)("no. of allHitIDs: " + qResults.getAllHitCount()));
        }
        catch (TokenMgrError tme) {
            log.warn((Object)("search_exceptionquery=\"" + qArray[0] + "\""));
        }
        catch (SQLException sqle) {
            log.warn((Object)("SQL exception: " + sqle.getMessage()));
        }
        int hitCount = qResults.getAllHitCount();
        int pageTotal = 1 + (hitCount - 1) / qResults.getPageSize();
        int pageCurrent = 1 + qResults.getStart() / qResults.getPageSize();
        int pageLast = pageCurrent + 9 > pageTotal ? pageTotal : pageCurrent + 9;
        int pageFirst = pageCurrent - 9 > 1 ? pageCurrent - 9 : 1;
        request.setAttribute("pagetotal", (Object)new Integer(pageTotal));
        request.setAttribute("pagecurrent", (Object)new Integer(pageCurrent));
        request.setAttribute("pagelast", (Object)new Integer(pageLast));
        request.setAttribute("pagefirst", (Object)new Integer(pageFirst));
        request.setAttribute("hitcount", (Object)new Integer(hitCount));
        request.setAttribute("advanced", (Object)advanced);
        request.setAttribute("query", (Object)qArray);
        request.setAttribute("queryresults", (Object)qResults);
        request.setAttribute("start", (Object)new Integer(start));
        request.setAttribute("view", (Object)new Integer(view));
        request.setAttribute("cluster", (Object)cluster);
        if (stateful != null && offset == 0 && stateful.equals("yes")) {
            ++cutoff;
        }
        request.setAttribute("cutoff", (Object)new Integer(cutoff));
        request.setAttribute("numlevel", (Object)new Integer(numLevel));
        request.setAttribute("useCluster", (Object)useCluster);
        request.setAttribute("stateful", (Object)stateful);
        request.setAttribute("referredPage", (Object)referredPage);
        request.setAttribute("firstState", (Object)firstState);
        request.setAttribute("history", (Object)history);
        this.jspForward(request, response, "/search/results.jsp");
    }

    private void jspForward(HttpServletRequest req, HttpServletResponse resp, String url) throws ServletException, IOException {
        req.getRequestDispatcher(url).forward((ServletRequest)req, (ServletResponse)resp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

