/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.profile;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.neoref.config.Config;

public class DBProfilerPg
extends Thread {
    private static int anyCnt;
    private static int ftCnt;

    DBProfilerPg() {
    }

    public static void count(ResultSet rs, String gene) throws Exception {
        gene = gene.toLowerCase();
        ftCnt = 0;
        anyCnt = 0;
        rs.beforeFirst();
        while (rs.next()) {
            String title = rs.getString(2).toLowerCase();
            String description = rs.getString(3).toLowerCase();
            if (title.indexOf(gene) == -1 && description.indexOf(gene) == -1) {
                ++ftCnt;
            }
            ++anyCnt;
        }
    }

    public static void log(String entry) {
        System.out.println(new Date() + ":" + entry);
    }

    public static void main(String[] args) throws Exception {
        String gene;
        Connection dbConn = null;
        String lastGene = null;
        ArrayList<String> genes = new ArrayList<String>();
        if (args.length < 1) {
            System.out.println("Usage: dbProfilePg gene_file");
            System.exit(-1);
        }
        System.out.println("Building a list of genes...");
        BufferedReader gIn = new BufferedReader(new FileReader(args[0]));
        while ((gene = gIn.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(gene);
            st.nextToken();
            gene = st.nextToken();
            if (gene.equals(lastGene)) continue;
            genes.add(gene);
            lastGene = gene;
        }
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
        Statement stmt = dbConn.createStatement();
        System.out.println("Processing " + genes.size() + " genes...");
        for (int i = 0; i < genes.size(); ++i) {
            gene = (String)genes.get(i);
            String sql = "SELECT id, title, description FROM metadata WHERE";
            sql = sql + " MATCH (";
            sql = sql + "title, description, fulltxt";
            sql = sql + ") AGAINST ('+" + gene;
            sql = sql + "' IN BOOLEAN MODE)";
            sql = sql + " AND identifier REGEXP 'pdf'";
            ResultSet rs = stmt.executeQuery(sql);
            DBProfilerPg.count(rs, gene);
            System.out.println(gene + ": " + ftCnt + "," + anyCnt);
        }
        System.out.println("Finished!");
    }
}

