/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.profile;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.config.Config;
import org.neoref.core.DC;
import org.neoref.core.Meta;
import org.neoref.query.NRQuery;
import org.neoref.query.QueryArgs;
import org.neoref.query.QueryResults;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBProfiler
extends Thread {
    String atStr;
    int graph;
    static Vector titles;

    DBProfiler(String atStr, int graph) {
        this.atStr = atStr;
        this.graph = graph;
    }

    public static void setTitles(Vector t) {
        titles = t;
    }

    public void run() {
        try {
            int i;
            int metaCount = 0;
            int ftCount = 0;
            int allCount = 0;
            QueryResults qResults = null;
            QueryArgs qArgs = new QueryArgs();
            String[] qArray = new String[DC.DCN_FT];
            Perl5Util util = new Perl5Util();
            DC.init();
            qArray[0] = "(((" + DC.dcName[0].toLowerCase() + ":" + this.atStr + ")";
            for (i = 1; i < DC.DCN_FT; ++i) {
                if (i == DC.DC_FULLTXT || i == DC.DC_IDENTIFIER) continue;
                qArray[0] = qArray[0] + " OR (" + DC.dcName[i].toLowerCase() + ":" + this.atStr + ")";
            }
            qArray[0] = qArray[0] + ") AND (identifier:(\"pubmedcentral\")))";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, false);
            List res = qResults.getHitIDs();
            int size = res.size();
            for (i = 0; i < size; ++i) {
                DC dc = Meta.getRecordFT((int)new Integer((String)res.get(i)));
                String titleStr = (String)dc.value.get(DC.DC_TITLE);
                if (!(titleStr = util.substitute("s/\\n//g", titleStr)).endsWith(".")) {
                    titleStr = titleStr + ".";
                }
                if (!titles.contains(titleStr.toLowerCase())) continue;
                ++metaCount;
            }
            qArray[0] = "((" + DC.dcName[DC.DC_FULLTXT].toLowerCase() + ":" + this.atStr + ") AND (identifier:(\"plantcell\" OR \"plantphysiol\" OR \"genesdev\" OR \"oupjournals\")))";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, false);
            ftCount = qResults.getHitCount();
            qArray[0] = "((" + DC.dcName[0].toLowerCase() + ":" + this.atStr + ")";
            for (i = 1; i < DC.DCN_FT; ++i) {
                qArray[0] = qArray[0] + " OR (" + DC.dcName[i].toLowerCase() + ":" + this.atStr + ")";
            }
            qArray[0] = qArray[0] + ")";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, false);
            allCount = qResults.getHitCount();
            if (this.graph == 0) {
                System.out.println(this.atStr + "," + metaCount + "," + ftCount);
            } else {
                System.out.println(metaCount + "," + ftCount);
            }
        }
        catch (Exception e) {
            DBProfiler.log("Error message: " + e.getMessage());
        }
    }

    public static void log(String entry) {
        System.out.println(new Date() + ":" + entry);
    }

    public static void main(String[] args) throws Exception {
        String temp;
        int i;
        int j;
        String atStr = "";
        String atStrLast = "";
        int graph = 0;
        int count = 0;
        Vector<String> titles = new Vector<String>();
        String[] journals = new String[4];
        Connection dbConn = null;
        if (args.length < 2) {
            System.out.println("Usage: dbprofile graph column");
            System.out.println("graph: 1 for output formatted for octave plotting; 0 for text file output");
            System.out.println("column: number from left to right, e.g., 2,3,4 for table column 2, 3, or 4 from left to right");
            System.exit(-1);
        }
        journals[0] = "plant+cell";
        journals[1] = "plant+physiology";
        journals[2] = "genes+development";
        journals[3] = "journal+of+experimental+botany";
        graph = Integer.parseInt(args[0]);
        for (j = 0; j < journals.length; ++j) {
            DBProfiler.sleep(9000L);
            System.out.println("Load titles for " + journals[j]);
            URL esearchURL = new URL("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&term=" + journals[j] + "[ta]&usehistory=y");
            URLConnection conn = esearchURL.openConnection();
            InputStream is = conn.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(is);
            count = Integer.parseInt(xmlDoc.getElementsByTagName("Count").item(0).getFirstChild().getNodeValue());
            String webEnv = xmlDoc.getElementsByTagName("WebEnv").item(0).getFirstChild().getNodeValue();
            int queryKey = Integer.parseInt(xmlDoc.getElementsByTagName("QueryKey").item(0).getFirstChild().getNodeValue());
            int step = 200;
            for (int retstart = 0; retstart < count; retstart += step) {
                System.out.println("retstart: " + retstart);
                URL efetchURL = new URL("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&WebEnv=" + webEnv + "&query_key=" + queryKey + "&retstart=" + retstart + "&retmax=" + step + "&retmode=xml");
                if (retstart + step > count && step > 1) {
                    step = 1;
                }
                conn = efetchURL.openConnection();
                is = conn.getInputStream();
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
                xmlDoc = db.parse(is);
                NodeList titleNodeList = xmlDoc.getElementsByTagName("ArticleTitle");
                int numTitle = titleNodeList.getLength();
                for (i = 0; i < numTitle; ++i) {
                    Node titleNode = titleNodeList.item(i);
                    if (titleNode == null || !titleNode.hasChildNodes()) continue;
                    temp = titleNode.getFirstChild().getNodeValue();
                    titles.add(temp.toLowerCase());
                }
            }
        }
        DBProfiler.setTitles(titles);
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
        Statement stmt = dbConn.createStatement();
        System.out.println("Determine the number of records from the gene table");
        ResultSet rs = stmt.executeQuery("select max(id) from gene;");
        if (rs.next()) {
            count = rs.getInt(1);
        } else {
            System.err.println("gene table does not exist");
            System.exit(-1);
        }
        for (j = 0; j < count; ++j) {
            rs = stmt.executeQuery("select * from gene where id=" + j + ";");
            if (!rs.next()) continue;
            StringTokenizer stCol = new StringTokenizer(args[1], ",");
            if (!stCol.hasMoreTokens()) {
                System.out.println("bad column specification");
                break;
            }
            atStr = "";
            i = 0;
            while (stCol.hasMoreTokens()) {
                int col = Integer.parseInt(stCol.nextToken());
                temp = rs.getString(col);
                if (temp.length() != 0) {
                    if (i > 0) {
                        atStr = atStr + " OR ";
                    }
                    atStr = atStr + "\"" + temp + "\"";
                }
                ++i;
            }
            if (i > 1) {
                atStr = "(" + atStr + ")";
            }
            if (atStr.equals(atStrLast)) continue;
            DBProfiler pf = new DBProfiler(atStr, graph);
            pf.start();
            pf.join();
            atStrLast = atStr;
        }
        System.out.println("Done with profiling!");
    }
}

