/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.index;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.neoref.config.Config;
import org.neoref.core.DC;
import org.neoref.core.Meta;
import org.neoref.index.NRAnalyzer;

public class NRIndexer {
    public static void createIndex() throws SQLException, IOException {
        IndexWriter writer = NRIndexer.openIndex(true);
        NRIndexer.indexAllItems(writer);
        writer.optimize();
        NRIndexer.closeIndex(writer);
    }

    public static void main(String[] args) throws Exception {
        DC.init();
        NRIndexer.createIndex();
        System.out.println("Done with indexing");
    }

    private static IndexWriter openIndex(boolean wipe_existing) throws IOException {
        IndexWriter writer = new IndexWriter(Config.INDEX_DIRECTORY, (Analyzer)new NRAnalyzer(), wipe_existing);
        return writer;
    }

    private static void closeIndex(IndexWriter writer) throws IOException {
        writer.close();
    }

    private static void indexAllItems(IndexWriter writer) throws SQLException, IOException {
        int i;
        int last = Meta.getLast();
        for (i = 1; i <= last; i += DC.STEP) {
            Iterator mi = Meta.getRecordsFT((int)i).iterator();
            while (mi.hasNext()) {
                DC target = (DC)mi.next();
                NRIndexer.writeItemIndex(writer, target);
            }
        }
        if (i - DC.STEP < last && i >= last) {
            i -= DC.STEP;
            while (i <= last) {
                DC dc = Meta.getRecordFT((int)i);
                if (!dc.value.isEmpty()) {
                    NRIndexer.writeItemIndex(writer, dc);
                }
                ++i;
            }
        }
        Meta.updateStart((int)(last + 1));
        Meta.close();
    }

    private static void writeItemIndex(IndexWriter writer, DC dc) throws SQLException, IOException {
        HashMap<String, String> textvalues = new HashMap<String, String>();
        for (int i = 1; i < DC.DCN_FT; ++i) {
            String tmp = (String)dc.value.get(i);
            if (tmp == null || tmp.equals("")) continue;
            textvalues.put(DC.dcName[i].toLowerCase(), tmp);
        }
        NRIndexer.writeIndexRecord(writer, (String)dc.value.get(0), (String)dc.value.get(DC.DC_IDENTIFIER), textvalues);
    }

    private static void writeIndexRecord(IndexWriter iw, String id, String identifier, HashMap textvalues) throws IOException {
        Document doc = new Document();
        String fulltext = "";
        doc.add(Field.UnIndexed((String)DC.dcName[0], (String)id));
        doc.add(Field.Keyword((String)DC.dcName[DC.DC_IDENTIFIER], (String)identifier));
        Iterator i = textvalues.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)textvalues.get(key);
            fulltext = fulltext + " " + value;
            doc.add(Field.Text((String)key, (String)value));
        }
        doc.add(Field.Text((String)"default", (String)fulltext));
        iw.addDocument(doc);
    }
}

