/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.index;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.neoref.config.Config;
import org.neoref.core.DC;
import org.neoref.core.Meta;
import org.neoref.index.NRAnalyzer;

public class IndexNewRecords {
    public static void main(String[] args) throws Exception {
        try {
            if (args.length < 1) {
                System.out.println("Usage: index-new [0|1]");
                System.out.println("0: create index, 1: append index");
                System.exit(-1);
            }
            DC.init();
            IndexWriter writer = Integer.parseInt(args[0]) == 0 ? new IndexWriter(Config.INDEX_DIRECTORY, (Analyzer)new NRAnalyzer(), true) : new IndexWriter(Config.INDEX_DIRECTORY, (Analyzer)new NRAnalyzer(), false);
            IndexNewRecords.indexNewItems(writer);
            writer.optimize();
            writer.close();
            System.out.println("Done with indexing");
        }
        catch (OutOfMemoryError e) {
            System.out.println("Out of Memory Error");
        }
    }

    private static void indexNewItems(IndexWriter writer) throws SQLException, IOException {
        int last = Meta.getLast();
        int i = Meta.getStarted();
        i += DC.STEP;
        while (i <= last) {
            Iterator mi = Meta.getRecordsFT((int)i).iterator();
            while (mi.hasNext()) {
                DC target = (DC)mi.next();
                IndexNewRecords.writeItemIndex(writer, target);
            }
            i += DC.STEP;
        }
        if (i - DC.STEP < last && i >= last) {
            System.gc();
            i -= DC.STEP;
            while (i <= last) {
                DC dc = Meta.getRecordFT((int)i);
                if (!dc.value.isEmpty()) {
                    IndexNewRecords.writeItemIndex(writer, dc);
                }
                ++i;
            }
        }
        Meta.updateStart((int)(last + 1));
        Meta.close();
    }

    private static void writeItemIndex(IndexWriter writer, DC dc) throws SQLException, IOException {
        HashMap<String, String> textvalues = new HashMap<String, String>();
        for (int i = 1; i < DC.DCN_FT; ++i) {
            String tmp = (String)dc.value.get(i);
            if (tmp == null) continue;
            textvalues.put(DC.dcName[i].toLowerCase(), tmp);
        }
        IndexNewRecords.writeIndexRecord(writer, (String)dc.value.get(0), (String)dc.value.get(DC.DC_IDENTIFIER), textvalues);
    }

    private static void writeIndexRecord(IndexWriter iw, String id, String identifier, HashMap textvalues) throws IOException {
        Document doc = new Document();
        String fulltext = "";
        doc.add(Field.UnIndexed((String)DC.dcName[0], (String)id));
        doc.add(Field.Keyword((String)DC.dcName[DC.DC_IDENTIFIER], (String)identifier));
        Iterator i = textvalues.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)textvalues.get(key);
            fulltext = fulltext + " " + value;
            doc.add(Field.Text((String)key, (String)value));
        }
        doc.add(Field.Text((String)"default", (String)fulltext));
        iw.addDocument(doc);
    }
}

