/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.text.ParseException;
import org.apache.xmlrpc.Base64;
import org.apache.xmlrpc.TypeFactory;
import org.apache.xmlrpc.util.DateTool;

public class DefaultTypeFactory
implements TypeFactory {
    private static DateTool dateTool = new DateTool();

    public Object createInteger(String cdata) {
        return new Integer(cdata.trim());
    }

    public Object createBoolean(String cdata) {
        return "1".equals(cdata.trim()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object createDouble(String cdata) {
        return new Double(cdata.trim());
    }

    public Object createDate(String cdata) {
        try {
            return dateTool.parse(cdata.trim());
        }
        catch (ParseException p) {
            throw new RuntimeException(p.getMessage());
        }
    }

    public Object createBase64(String cdata) {
        return Base64.decode(cdata.getBytes());
    }

    public Object createString(String cdata) {
        return cdata;
    }
}

