/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.util.Vector;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.MemberDefinition;

public class ImplementationType
extends ClassType {
    public static ImplementationType forImplementation(ClassDefinition classDefinition, ContextStack contextStack, boolean bl) {
        ImplementationType implementationType;
        block6: {
            if (contextStack.anyErrors()) {
                return null;
            }
            boolean bl2 = false;
            implementationType = null;
            try {
                sun.tools.java.Type type = classDefinition.getType();
                Type type2 = Type.getType(type, contextStack);
                if (type2 != null) {
                    if (!(type2 instanceof ImplementationType)) {
                        return null;
                    }
                    return (ImplementationType)type2;
                }
                if (!ImplementationType.couldBeImplementation(bl, contextStack, classDefinition)) break block6;
                ImplementationType implementationType2 = new ImplementationType(contextStack, classDefinition);
                Type.putType(type, (Type)implementationType2, contextStack);
                contextStack.push(implementationType2);
                bl2 = true;
                if (implementationType2.initialize(contextStack, bl)) {
                    contextStack.pop(true);
                    implementationType = implementationType2;
                    break block6;
                }
                Type.removeType(type, contextStack);
                contextStack.pop(false);
            }
            catch (CompilerError compilerError) {
                if (!bl2) break block6;
                contextStack.pop(false);
            }
        }
        return implementationType;
    }

    public String getTypeDescription() {
        return "Implementation";
    }

    private ImplementationType(ContextStack contextStack, ClassDefinition classDefinition) {
        super(0x6010000, classDefinition, contextStack);
    }

    private static boolean couldBeImplementation(boolean bl, ContextStack contextStack, ClassDefinition classDefinition) {
        boolean bl2 = false;
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        try {
            if (!classDefinition.isClass()) {
                Type.failedConstraint(17, bl, contextStack, classDefinition.getName());
            } else {
                bl2 = batchEnvironment.defRemote.implementedBy(batchEnvironment, classDefinition.getClassDeclaration());
                if (!bl2) {
                    Type.failedConstraint(8, bl, contextStack, classDefinition.getName());
                }
            }
        }
        catch (ClassNotFound classNotFound) {
            Type.classNotFound(contextStack, classNotFound);
        }
        return bl2;
    }

    private boolean initialize(ContextStack contextStack, boolean bl) {
        boolean bl2;
        block6: {
            bl2 = false;
            ClassDefinition classDefinition = this.getClassDefinition();
            if (!this.initParents(contextStack)) break block6;
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            try {
                if (this.addRemoteInterfaces(vector, true, contextStack) == null) break block6;
                boolean bl3 = false;
                int n = 0;
                while (n < vector.size()) {
                    InterfaceType interfaceType = (InterfaceType)vector.elementAt(n);
                    if (interfaceType.isType(4096) || interfaceType.isType(524288)) {
                        bl3 = true;
                    }
                    ImplementationType.copyRemoteMethods(interfaceType, vector2);
                    ++n;
                }
                if (!bl3) {
                    Type.failedConstraint(8, bl, contextStack, this.getQualifiedName());
                    return false;
                }
                if (this.checkMethods(classDefinition, vector2, contextStack, bl)) {
                    bl2 = this.initialize(vector, vector2, null, contextStack, bl);
                }
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(contextStack, classNotFound);
            }
        }
        return bl2;
    }

    private static void copyRemoteMethods(InterfaceType interfaceType, Vector vector) {
        if (interfaceType.isType(4096)) {
            Object object;
            CompoundType.Method[] methodArray = interfaceType.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                object = methodArray[n];
                if (!vector.contains(object)) {
                    vector.addElement(object);
                }
                ++n;
            }
            object = interfaceType.getInterfaces();
            int n2 = 0;
            while (n2 < ((InterfaceType[])object).length) {
                ImplementationType.copyRemoteMethods(object[n2], vector);
                ++n2;
            }
        }
    }

    private boolean checkMethods(ClassDefinition classDefinition, Vector vector, ContextStack contextStack, boolean bl) {
        Object[] objectArray = new CompoundType.Method[vector.size()];
        vector.copyInto(objectArray);
        MemberDefinition memberDefinition = classDefinition.getFirstMember();
        while (memberDefinition != null) {
            if (memberDefinition.isMethod() && !memberDefinition.isConstructor() && !memberDefinition.isInitializer() && !this.updateExceptions(memberDefinition, (CompoundType.Method[])objectArray, contextStack, bl)) {
                return false;
            }
            memberDefinition = memberDefinition.getNextMember();
        }
        return true;
    }

    private boolean updateExceptions(MemberDefinition memberDefinition, CompoundType.Method[] methodArray, ContextStack contextStack, boolean bl) {
        int n = methodArray.length;
        String string = memberDefinition.toString();
        int n2 = 0;
        while (n2 < n) {
            CompoundType.Method method = methodArray[n2];
            MemberDefinition memberDefinition2 = method.getMemberDefinition();
            if (string.equals(memberDefinition2.toString())) {
                try {
                    ValueType[] valueTypeArray = this.getMethodExceptions(memberDefinition, bl, contextStack);
                    method.setImplExceptions(valueTypeArray);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }
}

