/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.Packet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;

class SocketConnection
implements ConnectionService {
    Socket socket;
    BufferedOutputStream socketOutput;
    BufferedInputStream socketInput;
    Object receiveLock = new Object();
    Object sendLock = new Object();

    SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.socketInput = new BufferedInputStream(socket.getInputStream());
        this.socketOutput = new BufferedOutputStream(socket.getOutputStream());
    }

    public void close() {
        try {
            this.socketOutput.flush();
            this.socketOutput.close();
            this.socketInput.close();
            this.socket.close();
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte receiveByte() throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            int n = this.socketInput.read();
            return (byte)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendByte(byte by) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            this.socketOutput.write(by);
            this.socketOutput.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet receivePacket() throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            Packet packet = new Packet();
            int n = this.socketInput.read();
            int n2 = this.socketInput.read();
            int n3 = this.socketInput.read();
            int n4 = this.socketInput.read();
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                throw new EOFException();
            }
            int n5 = (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
            n = this.socketInput.read();
            n2 = this.socketInput.read();
            n3 = this.socketInput.read();
            n4 = this.socketInput.read();
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                throw new EOFException();
            }
            packet.id = (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
            packet.flags = (short)this.socketInput.read();
            if (packet.flags < 0) {
                throw new EOFException();
            }
            if ((packet.flags & 0x80) == 0) {
                packet.cmdSet = (short)this.socketInput.read();
                packet.cmd = (short)this.socketInput.read();
                if (packet.cmdSet < 0 || packet.cmd < 0) {
                    throw new EOFException();
                }
            } else {
                n = this.socketInput.read();
                n2 = this.socketInput.read();
                if (n < 0 || n2 < 0) {
                    throw new EOFException();
                }
                packet.errorCode = (short)((n << 8) + (n2 << 0));
            }
            if ((n5 -= 11) < 0) {
                System.err.println("length is " + n5);
                System.err.println("Read is " + this.socketInput.read());
            }
            packet.data = new byte[n5];
            int n6 = 0;
            while (n6 < packet.data.length) {
                int n7 = this.socketInput.read(packet.data, n6, packet.data.length - n6);
                if (n7 < 0) {
                    throw new EOFException();
                }
                n6 += n7;
            }
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            int n = packet.data.length + 11;
            this.socketOutput.write(n >>> 24 & 0xFF);
            this.socketOutput.write(n >>> 16 & 0xFF);
            this.socketOutput.write(n >>> 8 & 0xFF);
            this.socketOutput.write(n >>> 0 & 0xFF);
            this.socketOutput.write(packet.id >>> 24 & 0xFF);
            this.socketOutput.write(packet.id >>> 16 & 0xFF);
            this.socketOutput.write(packet.id >>> 8 & 0xFF);
            this.socketOutput.write(packet.id >>> 0 & 0xFF);
            this.socketOutput.write(packet.flags);
            if ((packet.flags & 0x80) == 0) {
                this.socketOutput.write(packet.cmdSet);
                this.socketOutput.write(packet.cmd);
            } else {
                this.socketOutput.write(packet.errorCode >>> 8 & 0xFF);
                this.socketOutput.write(packet.errorCode >>> 0 & 0xFF);
            }
            this.socketOutput.write(packet.data);
            this.socketOutput.flush();
        }
    }
}

