/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.code;

import com.sun.tools.javac.v8.util.Hashtable;

public class Pool {
    int pp;
    Object[] pool;
    Hashtable indices;

    public Pool(int n, Object[] objectArray) {
        this.pp = n;
        this.pool = objectArray;
        this.indices = new Hashtable(objectArray.length);
        int n2 = 1;
        while (n2 < n) {
            if (objectArray[n2] != null) {
                this.indices.put(objectArray[n2], new Integer(n2));
            }
            ++n2;
        }
    }

    public Pool() {
        this(1, new Object[64]);
    }

    public void reset() {
        this.pp = 1;
        this.indices.reset();
    }

    private void doublePool() {
        Object[] objectArray = new Object[this.pool.length * 2];
        System.arraycopy(this.pool, 0, objectArray, 0, this.pool.length);
        this.pool = objectArray;
    }

    public int put(Object object) {
        Integer n = (Integer)this.indices.get(object);
        if (n == null) {
            n = new Integer(this.pp);
            this.indices.put(object, n);
            if (this.pp == this.pool.length) {
                this.doublePool();
            }
            this.pool[this.pp++] = object;
            if (object instanceof Long || object instanceof Double) {
                if (this.pp == this.pool.length) {
                    this.doublePool();
                }
                this.pool[this.pp++] = null;
            }
        }
        return n;
    }

    public int get(Object object) {
        Integer n = (Integer)this.indices.get(object);
        return n == null ? -1 : n;
    }
}

