/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;

class SegmentsTermEnum
extends TermEnum {
    private SegmentMergeQueue queue;
    private Term term;
    private int docFreq;

    SegmentsTermEnum(SegmentReader[] segmentReaderArray, int[] nArray, Term term) throws IOException {
        Object object;
        this.queue = new SegmentMergeQueue(segmentReaderArray.length);
        int n = 0;
        while (n < segmentReaderArray.length) {
            object = segmentReaderArray[n];
            SegmentTermEnum segmentTermEnum = term != null ? (SegmentTermEnum)((SegmentReader)object).terms(term) : (SegmentTermEnum)((SegmentReader)object).terms();
            SegmentMergeInfo segmentMergeInfo = new SegmentMergeInfo(nArray[n], segmentTermEnum, (SegmentReader)object);
            if (term == null ? segmentMergeInfo.next() : segmentTermEnum.term() != null) {
                this.queue.put(segmentMergeInfo);
            } else {
                segmentMergeInfo.close();
            }
            ++n;
        }
        if (term != null && this.queue.size() > 0) {
            object = (SegmentMergeInfo)this.queue.top();
            this.term = ((SegmentMergeInfo)object).termEnum.term();
            this.docFreq = ((SegmentMergeInfo)object).termEnum.docFreq();
        }
    }

    public final boolean next() throws IOException {
        SegmentMergeInfo segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
        if (segmentMergeInfo == null) {
            this.term = null;
            return false;
        }
        this.term = segmentMergeInfo.term;
        this.docFreq = 0;
        while (segmentMergeInfo != null && this.term.compareTo(segmentMergeInfo.term) == 0) {
            this.queue.pop();
            this.docFreq += segmentMergeInfo.termEnum.docFreq();
            if (segmentMergeInfo.next()) {
                this.queue.put(segmentMergeInfo);
            } else {
                segmentMergeInfo.close();
            }
            segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
        }
        return true;
    }

    public final Term term() {
        return this.term;
    }

    public final int docFreq() {
        return this.docFreq;
    }

    public final void close() throws IOException {
        this.queue.close();
    }
}

