/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.util.BitVector;

class SegmentTermDocs
implements TermDocs {
    protected SegmentReader parent;
    private InputStream freqStream;
    private int freqCount;
    private BitVector deletedDocs;
    int doc = 0;
    int freq;

    SegmentTermDocs(SegmentReader segmentReader) throws IOException {
        this.parent = segmentReader;
        this.freqStream = (InputStream)segmentReader.freqStream.clone();
        this.deletedDocs = segmentReader.deletedDocs;
    }

    public void seek(Term term) throws IOException {
        TermInfo termInfo = this.parent.tis.get(term);
        this.seek(termInfo);
    }

    void seek(TermInfo termInfo) throws IOException {
        if (termInfo == null) {
            this.freqCount = 0;
        } else {
            this.freqCount = termInfo.docFreq;
            this.doc = 0;
            this.freqStream.seek(termInfo.freqPointer);
        }
    }

    public void close() throws IOException {
        this.freqStream.close();
    }

    public final int doc() {
        return this.doc;
    }

    public final int freq() {
        return this.freq;
    }

    protected void skippingDoc() throws IOException {
    }

    public boolean next() throws IOException {
        while (true) {
            if (this.freqCount == 0) {
                return false;
            }
            int n = this.freqStream.readVInt();
            this.doc += n >>> 1;
            this.freq = (n & 1) != 0 ? 1 : this.freqStream.readVInt();
            --this.freqCount;
            if (this.deletedDocs == null || !this.deletedDocs.get(this.doc)) break;
            this.skippingDoc();
        }
        return true;
    }

    public int read(int[] nArray, int[] nArray2) throws IOException {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n && this.freqCount > 0) {
            int n3 = this.freqStream.readVInt();
            this.doc += n3 >>> 1;
            this.freq = (n3 & 1) != 0 ? 1 : this.freqStream.readVInt();
            --this.freqCount;
            if (this.deletedDocs != null && this.deletedDocs.get(this.doc)) continue;
            nArray[n2] = this.doc;
            nArray2[n2] = this.freq;
            ++n2;
        }
        return n2;
    }

    public boolean skipTo(int n) throws IOException {
        do {
            if (this.next()) continue;
            return false;
        } while (n > this.doc);
        return true;
    }
}

