/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.OutputStream;

final class FieldsWriter {
    private FieldInfos fieldInfos;
    private OutputStream fieldsStream;
    private OutputStream indexStream;

    FieldsWriter(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        this.fieldInfos = fieldInfos;
        this.fieldsStream = directory.createFile(string + ".fdt");
        this.indexStream = directory.createFile(string + ".fdx");
    }

    final void close() throws IOException {
        this.fieldsStream.close();
        this.indexStream.close();
    }

    final void addDocument(Document document) throws IOException {
        Field field;
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        int n = 0;
        Enumeration enumeration = document.fields();
        while (enumeration.hasMoreElements()) {
            field = (Field)enumeration.nextElement();
            if (!field.isStored()) continue;
            ++n;
        }
        this.fieldsStream.writeVInt(n);
        enumeration = document.fields();
        while (enumeration.hasMoreElements()) {
            field = (Field)enumeration.nextElement();
            if (!field.isStored()) continue;
            this.fieldsStream.writeVInt(this.fieldInfos.fieldNumber(field.name()));
            byte by = 0;
            if (field.isTokenized()) {
                by = (byte)(by | 1);
            }
            this.fieldsStream.writeByte(by);
            this.fieldsStream.writeString(field.stringValue());
        }
    }
}

