/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfviewer.ArrayEntry;
import org.pdfbox.pdfviewer.MapEntry;
import org.pdfbox.pdfviewer.PDFTreeCellRenderer;
import org.pdfbox.pdfviewer.PDFTreeModel;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.DefaultFileFilter;

public class PDFViewer
extends JFrame {
    private File currentDir = new File(".");
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextPane jTextPane1;
    private JTree jTree1;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JPanel documentPanel = new JPanel();

    public PDFViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.jTree1.setCellRenderer(new PDFTreeCellRenderer());
        this.jTree1.setModel(null);
        this.setTitle("PDFBox - PDF Viewer");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PDFViewer.this.exitForm(evt);
            }
        });
        this.jScrollPane1.setBorder(new BevelBorder(0));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 500));
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                PDFViewer.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jScrollPane2.setPreferredSize(new Dimension(300, 500));
        this.jScrollPane2.setViewportView(this.jTextPane1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        JScrollPane documentScroller = new JScrollPane();
        documentScroller.setViewportView(this.documentPanel);
        JSplitPane mainPane = new JSplitPane(1, this.jSplitPane1, documentScroller);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.setToolTipText("Open PDF file");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFViewer.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveAsMenuItem.setText("Save As ...");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFViewer.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setText("Cut");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.editMenu.add(this.deleteMenuItem);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Contents");
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.setJMenuBar(this.menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 700) / 2, (screenSize.height - 600) / 2, 700, 600);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.currentDir);
        DefaultFileFilter pdfFilter = new DefaultFileFilter(new String[]{"pdf", "PDF"}, "PDF Files");
        chooser.setFileFilter(pdfFilter);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            String name = chooser.getSelectedFile().getPath();
            this.currentDir = new File(name).getParentFile();
            try {
                this.readPDFFile(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        TreePath path = this.jTree1.getSelectionPath();
        if (path != null) {
            try {
                Object selectedNode = path.getLastPathComponent();
                String data = this.convertToString(selectedNode);
                if (data != null) {
                    this.jTextPane1.setText(data);
                } else {
                    this.jTextPane1.setText("");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String convertToString(Object selectedNode) {
        String data = null;
        if (selectedNode instanceof COSBoolean) {
            data = "" + ((COSBoolean)selectedNode).getValue();
        } else if (selectedNode instanceof COSFloat) {
            data = "" + ((COSFloat)selectedNode).floatValue();
        } else if (selectedNode instanceof COSNull) {
            data = "null";
        } else if (selectedNode instanceof COSInteger) {
            data = "" + ((COSInteger)selectedNode).intValue();
        } else if (selectedNode instanceof COSName) {
            data = "" + ((COSName)selectedNode).getName();
        } else if (selectedNode instanceof COSString) {
            data = "" + ((COSString)selectedNode).getString();
        } else if (selectedNode instanceof COSStream) {
            try {
                COSStream stream = (COSStream)selectedNode;
                InputStream ioStream = stream.getUnfilteredStream();
                ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int amountRead = 0;
                while ((amountRead = ioStream.read(buffer, 0, buffer.length)) != -1) {
                    byteArray.write(buffer, 0, amountRead);
                }
                data = byteArray.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (selectedNode instanceof MapEntry) {
            data = this.convertToString(((MapEntry)selectedNode).getValue());
        } else if (selectedNode instanceof ArrayEntry) {
            data = this.convertToString(((ArrayEntry)selectedNode).getValue());
        }
        return data;
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        PDFViewer viewer = new PDFViewer();
        if (args.length > 0) {
            viewer.readPDFFile(args[0]);
        }
        viewer.show();
    }

    private void readPDFFile(String file) throws Exception {
        FileInputStream input = null;
        File f = new File(file);
        input = new FileInputStream(f);
        PDDocument document = PDFViewer.parseDocument(input);
        PDFTreeModel model = new PDFTreeModel(document);
        this.jTree1.setModel(model);
        this.setTitle("PDFBox - " + f.getAbsolutePath());
    }

    private static PDDocument parseDocument(InputStream input) throws IOException {
        PDDocument document = PDDocument.load(input);
        if (document.isEncrypted()) {
            try {
                document.decrypt("");
            }
            catch (InvalidPasswordException e) {
                System.err.println("Error: The document is encrypted.");
            }
            catch (CryptographyException e) {
                e.printStackTrace();
            }
        }
        return document;
    }
}

