/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.pdfbox.pdmodel.interactive.form.PDChoiceField;
import org.pdfbox.pdmodel.interactive.form.PDField;
import org.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.pdfbox.pdmodel.interactive.form.PDRadioCollection;
import org.pdfbox.pdmodel.interactive.form.PDSignature;
import org.pdfbox.pdmodel.interactive.form.PDTextbox;

public class PDFieldFactory {
    private static final int RADIO_BITMASK = 32768;
    private static final int PUSHBUTTON_BITMASK = 65536;
    private static final int RADIOS_IN_UNISON_BITMASK = 0x2000000;
    private static final COSName BTN = COSName.getPDFName("Btn");
    private static final COSName TX = COSName.getPDFName("Tx");
    private static final COSName CH = COSName.getPDFName("Ch");
    private static final COSName SIG = COSName.getPDFName("Sig");

    public static PDField createField(PDAcroForm acroForm, COSDictionary field) {
        if (PDFieldFactory.isButton(field)) {
            int flags = PDFieldFactory.getFieldFlags(field);
            if (PDFieldFactory.isRadio(flags)) {
                return new PDRadioCollection(acroForm, field);
            }
            if (PDFieldFactory.isPushButton(flags)) {
                return new PDPushButton(acroForm, field);
            }
            return new PDCheckbox(acroForm, field);
        }
        if (PDFieldFactory.isChoiceField(field)) {
            return new PDChoiceField(acroForm, field);
        }
        if (PDFieldFactory.isTextbox(field)) {
            return new PDTextbox(acroForm, field);
        }
        if (PDFieldFactory.isSignature(field)) {
            return new PDSignature(acroForm, field);
        }
        System.err.println("Error finding field type for " + field);
        return null;
    }

    private static int getFieldFlags(COSDictionary field) {
        int retval = 0;
        COSInteger ff = (COSInteger)field.getDictionaryObject(COSName.getPDFName("Ff"));
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    private static boolean isRadio(int flags) {
        return (flags & 0x8000) > 0;
    }

    private static boolean isPushButton(int flags) {
        return (flags & 0x10000) > 0;
    }

    private static boolean isChoiceField(COSDictionary field) {
        return field.getDictionaryObject(COSName.getPDFName("FT")).equals(CH);
    }

    private static boolean isButton(COSDictionary field) {
        return field.getDictionaryObject(COSName.getPDFName("FT")).equals(BTN);
    }

    private static boolean isSignature(COSDictionary field) {
        return field.getDictionaryObject(COSName.getPDFName("FT")).equals(SIG);
    }

    private static boolean isTextbox(COSDictionary field) {
        return field.getDictionaryObject(COSName.getPDFName("FT")).equals(TX);
    }
}

