/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.annotation;

import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;

public abstract class PDAnnotation
implements COSObjectable {
    private COSDictionary dictionary;

    public PDAnnotation() {
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.TYPE, COSName.getPDFName("Annot"));
    }

    public PDAnnotation(COSDictionary dict) {
        this.dictionary = dict;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public PDRectangle getRectangle() {
        COSArray rectArray = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("Rect"));
        PDRectangle rectangle = null;
        if (rectArray != null) {
            rectangle = new PDRectangle(rectArray);
        }
        return rectangle;
    }

    public void setRectangle(PDRectangle rectangle) {
        this.dictionary.setItem(COSName.getPDFName("Rect"), rectangle.getCOSArray());
    }

    public int getAnnotationFlags() {
        int retval = 0;
        COSInteger f = (COSInteger)this.getDictionary().getDictionaryObject(COSName.getPDFName("F"));
        if (f != null) {
            retval = f.intValue();
        }
        return retval;
    }

    public void setAnnotationFlags(int flags) {
        COSInteger f = new COSInteger(flags);
        this.getDictionary().setItem(COSName.getPDFName("F"), f);
    }

    public COSBase getCOSObject() {
        return this.getDictionary();
    }

    public String getAppearanceStream() {
        String retval = null;
        COSName name = (COSName)this.getDictionary().getDictionaryObject(COSName.getPDFName("AS"));
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setAppearanceStream(String as) {
        if (as == null) {
            this.getDictionary().removeItem(COSName.getPDFName("AS"));
        } else {
            this.getDictionary().setItem(COSName.getPDFName("AS"), COSName.getPDFName(as));
        }
    }

    public PDAppearanceDictionary getAppearance() {
        PDAppearanceDictionary ap = null;
        COSDictionary apDic = (COSDictionary)this.dictionary.getDictionaryObject(COSName.getPDFName("AP"));
        if (apDic != null) {
            ap = new PDAppearanceDictionary(apDic);
        }
        return ap;
    }

    public void setAppearance(PDAppearanceDictionary appearance) {
        COSDictionary ap = null;
        if (appearance != null) {
            ap = appearance.getDictionary();
        }
        this.dictionary.setItem(COSName.getPDFName("AP"), ap);
    }
}

