/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfparser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.io.PushBackInputStream;
import org.pdfbox.pdfparser.PDFXref;
import org.pdfbox.persistence.util.COSObjectKey;

public abstract class BaseParser {
    private static Category log = Category.getInstance((String)(class$org$pdfbox$pdfparser$BaseParser == null ? (class$org$pdfbox$pdfparser$BaseParser = BaseParser.class$("org.pdfbox.pdfparser.BaseParser")) : class$org$pdfbox$pdfparser$BaseParser).getName());
    public static final byte[] ENDSTREAM = "endstream".getBytes();
    public static final String DEF = "def";
    protected PushBackInputStream pdfSource;
    private Map objectPool = new HashMap();
    private List xrefs = new ArrayList();
    private static final String HEXDIGITS = "0123456789abcdefABCDEF";
    static /* synthetic */ Class class$org$pdfbox$pdfparser$BaseParser;

    public BaseParser(InputStream input) throws IOException {
        this.pdfSource = new PushBackInputStream(new BufferedInputStream(input, 16384), 4096);
    }

    private static boolean isHexDigit(char ch) {
        return HEXDIGITS.indexOf(ch) != -1;
    }

    private COSBase parseCOSDictionaryValue() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseCOSDictionaryValue() " + this.pdfSource));
        }
        COSBase retval = null;
        COSBase number = this.parseDirObject();
        this.skipSpaces();
        char next = (char)this.pdfSource.peek();
        if (next >= '0' && next <= '9') {
            COSBase generationNumber = this.parseDirObject();
            this.skipSpaces();
            char r = (char)this.pdfSource.read();
            if (r != 'R') {
                throw new IOException("expected='R' actual='" + r + "' " + this.pdfSource);
            }
            COSObjectKey key = new COSObjectKey(((COSInteger)number).intValue(), ((COSInteger)generationNumber).intValue());
            retval = this.getObjectFromPool(key);
        } else {
            retval = number;
        }
        return retval;
    }

    protected COSDictionary parseCOSDictionary() throws IOException {
        char c;
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseCOSDictionary() " + this.pdfSource));
        }
        if ((c = (char)this.pdfSource.read()) != '<') {
            throw new IOException("expected='<' actual='" + c + "'");
        }
        c = (char)this.pdfSource.read();
        if (c != '<') {
            throw new IOException("expected='<' actual='" + c + "' " + this.pdfSource);
        }
        this.skipSpaces();
        COSDictionary obj = new COSDictionary();
        boolean done = false;
        while (!done) {
            this.skipSpaces();
            c = (char)this.pdfSource.peek();
            if (c == '>') {
                done = true;
                continue;
            }
            COSName key = this.parseCOSName();
            COSBase value = this.parseCOSDictionaryValue();
            this.skipSpaces();
            if ((char)this.pdfSource.peek() == 'd') {
                String potentialDEF = this.readString();
                if (!potentialDEF.equals(DEF)) {
                    this.pdfSource.unread(potentialDEF.getBytes());
                } else {
                    this.skipSpaces();
                }
            }
            if (value == null) {
                throw new IOException("Bad Dictionary Declaration " + this.pdfSource);
            }
            obj.setItem(key, value);
        }
        if ((char)this.pdfSource.peek() != '>') {
            throw new IOException("expected='>' actual='" + (char)this.pdfSource.peek() + "'");
        }
        this.pdfSource.read();
        if ((char)this.pdfSource.peek() != '>') {
            throw new IOException("expected='>' actual='" + (char)this.pdfSource.peek() + "'");
        }
        this.pdfSource.read();
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseCOSDictionary() done peek='" + this.pdfSource.peek() + "'"));
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected COSStream parseCOSStream(COSDictionary dic, RandomAccessFile file) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseCOSStream() " + this.pdfSource));
        }
        COSStream stream = new COSStream(dic, file);
        OutputStream out = null;
        try {
            String streamString = this.readString();
            if (!streamString.equals("stream")) {
                throw new IOException("expected='stream' actual='" + streamString + "'");
            }
            int whitespace = this.pdfSource.read();
            if (whitespace == 13) {
                whitespace = this.pdfSource.read();
                if (whitespace != 10) {
                    this.pdfSource.unread(whitespace);
                }
            } else if (whitespace != 10) {
                this.pdfSource.unread(whitespace);
            }
            COSBase streamLength = dic.getDictionaryObject(COSName.LENGTH);
            long length = -1L;
            if (streamLength instanceof COSNumber) {
                length = ((COSNumber)streamLength).intValue();
            } else if (streamLength instanceof COSObject && ((COSObject)streamLength).getObject() instanceof COSNumber) {
                length = ((COSNumber)((COSObject)streamLength).getObject()).intValue();
            }
            out = stream.createFilteredStream();
            String endStream = null;
            this.readUntilEndStream(out);
            char c = (char)this.pdfSource.peek();
            this.skipSpaces();
            endStream = this.readString();
            if (!endStream.equals("endstream")) {
                this.readUntilEndStream(out);
                endStream = this.readString();
                if (!endStream.equals("endstream")) {
                    throw new IOException("expected='endstream' actual='" + endStream + "' " + this.pdfSource);
                }
            }
            Object var14_11 = null;
            if (out == null) return stream;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
        return stream;
    }

    private void readUntilEndStream(OutputStream out) throws IOException {
        int currentIndex = 0;
        int byteRead = 0;
        int additionalBytes = 0;
        byte[] buffer = new byte[ENDSTREAM.length + additionalBytes];
        int writeIndex = 0;
        while (!this.cmpCircularBuffer(buffer, currentIndex, ENDSTREAM) && byteRead != -1) {
            writeIndex = currentIndex - buffer.length;
            if (writeIndex >= 0) {
                out.write(buffer[writeIndex % buffer.length]);
            }
            byteRead = this.pdfSource.read();
            buffer[currentIndex % buffer.length] = (byte)byteRead;
            ++currentIndex;
        }
        int i = 0;
        while (i < additionalBytes) {
            writeIndex = currentIndex - buffer.length;
            if (writeIndex >= 0 && buffer[writeIndex % buffer.length] != 13) {
                out.write(buffer[writeIndex % buffer.length]);
            }
            ++currentIndex;
            ++i;
        }
        this.pdfSource.unread(ENDSTREAM);
    }

    private boolean cmpCircularBuffer(byte[] buffer, int currentIndex, byte[] compareTo) {
        boolean match = true;
        if (currentIndex - compareTo.length < 0) {
            match = false;
        }
        int i = 0;
        while (i < compareTo.length && match) {
            match = buffer[(currentIndex + i - compareTo.length) % buffer.length] == compareTo[i];
            ++i;
        }
        return match;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected COSString parseCOSString() throws IOException {
        char closeBrace;
        char openBrace;
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseCOSString() " + this.pdfSource));
        }
        char nextChar = (char)this.pdfSource.read();
        COSString retval = new COSString();
        if (nextChar == '(') {
            openBrace = '(';
            closeBrace = ')';
        } else {
            if (nextChar != '<') {
                throw new IOException("parseCOSString string should start with '(' or '<' and not '" + nextChar + "' " + this.pdfSource);
            }
            openBrace = '<';
            closeBrace = '>';
        }
        int braces = 1;
        block14: while (braces > 0 && !this.pdfSource.isEOF()) {
            char c = (char)this.pdfSource.read();
            if (c == closeBrace) {
                if (--braces == 0) continue;
                retval.append(c);
                continue;
            }
            if (c == openBrace) {
                ++braces;
                retval.append(c);
                continue;
            }
            if (c == '\\') {
                int next = this.pdfSource.read();
                switch (next) {
                    case 110: {
                        retval.append(10);
                        break;
                    }
                    case 114: {
                        retval.append(13);
                        break;
                    }
                    case 116: {
                        retval.append(9);
                        break;
                    }
                    case 98: {
                        retval.append(8);
                        break;
                    }
                    case 102: {
                        retval.append(12);
                    }
                    case 40: 
                    case 41: 
                    case 92: {
                        retval.append((char)next);
                        break;
                    }
                    case 10: 
                    case 13: {
                        while (this.isEOL()) {
                            if (this.pdfSource.isEOF()) continue block14;
                            this.pdfSource.read();
                        }
                        continue block14;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        StringBuffer octal = new StringBuffer();
                        octal.append("" + (char)next);
                        if ((char)this.pdfSource.peek() >= '0' && (char)this.pdfSource.peek() <= '7') {
                            octal.append((char)this.pdfSource.read());
                        }
                        if ((char)this.pdfSource.peek() >= '0' && (char)this.pdfSource.peek() <= '7') {
                            octal.append((char)this.pdfSource.read());
                        }
                        int character = 0;
                        try {
                            character = Integer.parseInt(octal.toString(), 8);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Error: Expected octal character, actual='" + octal + "'");
                        }
                        retval.append(character);
                        break;
                    }
                    default: {
                        retval.append(92);
                        retval.append((char)next);
                    }
                }
                continue;
            }
            if (openBrace == '<') {
                if (c == '\r' || c == '\n') continue;
                retval.append(c);
                continue;
            }
            retval.append(c);
        }
        if (openBrace == '<') {
            StringBuffer hexBuffer = new StringBuffer(retval.getString());
            retval = new COSString();
            if (hexBuffer.length() % 2 == 1) {
                hexBuffer.append("0");
            }
            int i = 0;
            while (i < hexBuffer.length()) {
                String hexChars = "" + hexBuffer.charAt(i++) + hexBuffer.charAt(i++);
                try {
                    retval.append(Integer.parseInt(hexChars, 16));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Error: Expected hex number, actual='" + hexChars + "'");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseCOSString() done parsed=" + retval));
        }
        return retval;
    }

    protected COSArray parseCOSArray() throws IOException {
        char c;
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseCOSArray() " + this.pdfSource));
        }
        if ((c = (char)this.pdfSource.peek()) != '[') {
            throw new IOException("expected='[' actual='" + c + "'");
        }
        this.pdfSource.read();
        COSArray po = new COSArray();
        COSBase pbo = null;
        this.skipSpaces();
        int i = 0;
        while ((i = this.pdfSource.peek()) > 0 && (char)i != ']') {
            pbo = this.parseDirObject();
            if (pbo instanceof COSObject) {
                COSInteger genNumber = (COSInteger)po.remove(po.size() - 1);
                COSInteger number = (COSInteger)po.remove(po.size() - 1);
                COSObjectKey key = new COSObjectKey(number.intValue(), genNumber.intValue());
                pbo = this.getObjectFromPool(key);
            }
            if (pbo != null) {
                po.add(pbo);
            }
            this.skipSpaces();
        }
        this.pdfSource.read();
        this.skipSpaces();
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseCOSArray() done peek='" + (char)this.pdfSource.peek() + "'"));
        }
        return po;
    }

    private boolean isEndOfName(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t' || ch == '>' || ch == '<' || ch == '[' || ch == '/' || ch == ']' || ch == ')' || ch == '(' || ch == '\uffffffff';
    }

    protected COSName parseCOSName() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseCOSName() " + this.pdfSource));
        }
        COSName retval = null;
        if ((char)this.pdfSource.peek() != '/') {
            throw new IOException("expected='/' actual='" + (char)this.pdfSource.peek() + "' " + this.pdfSource);
        }
        this.pdfSource.read();
        StringBuffer buffer = new StringBuffer();
        while (!this.pdfSource.isEOF()) {
            char c = (char)this.pdfSource.peek();
            if (c == '#') {
                this.pdfSource.read();
                char ch1 = (char)this.pdfSource.read();
                char ch2 = (char)this.pdfSource.read();
                if (BaseParser.isHexDigit(ch1) && BaseParser.isHexDigit(ch2)) {
                    String hex = "" + ch1 + ch2;
                    try {
                        buffer.append((char)Integer.parseInt(hex, 16));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Error: expected hex number, actual='" + hex + "'");
                    }
                }
                this.pdfSource.unread(ch2);
                this.pdfSource.unread(ch1);
                buffer.append(c);
                continue;
            }
            if (this.isEndOfName(c)) break;
            buffer.append(c);
            this.pdfSource.read();
        }
        retval = COSName.getPDFName(buffer.toString());
        return retval;
    }

    protected COSBoolean parseBoolean() throws IOException {
        COSBoolean retval = null;
        char c = (char)this.pdfSource.peek();
        if (c == 't') {
            byte[] trueArray = new byte[4];
            int amountRead = this.pdfSource.read(trueArray, 0, 4);
            String trueString = new String(trueArray, 0, amountRead);
            if (!trueString.equals("true")) {
                throw new IOException("Error parsing boolean: expected='true' actual='" + trueString + "'");
            }
            retval = COSBoolean.TRUE;
        } else if (c == 'f') {
            byte[] falseArray = new byte[5];
            int amountRead = this.pdfSource.read(falseArray, 0, 5);
            String falseString = new String(falseArray, 0, amountRead);
            if (!falseString.equals("false")) {
                throw new IOException("Error parsing boolean: expected='true' actual='" + falseString + "'");
            }
            retval = COSBoolean.FALSE;
        } else {
            throw new IOException("Error parsing boolean expected='t or f' actual='" + c + "'");
        }
        return retval;
    }

    protected COSBase parseDirObject() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseDirObject() " + this.pdfSource));
        }
        COSBase retval = null;
        this.skipSpaces();
        int nextByte = this.pdfSource.peek();
        char c = (char)nextByte;
        switch (c) {
            case '<': {
                int leftBracket = this.pdfSource.read();
                c = (char)this.pdfSource.peek();
                this.pdfSource.unread(leftBracket);
                if (c == '<') {
                    retval = this.parseCOSDictionary();
                    this.skipSpaces();
                    break;
                }
                retval = this.parseCOSString();
                break;
            }
            case '[': {
                retval = this.parseCOSArray();
                break;
            }
            case '(': {
                retval = this.parseCOSString();
                break;
            }
            case '/': {
                retval = this.parseCOSName();
                break;
            }
            case 'n': {
                String nullString = this.readString();
                if (!nullString.equals("null")) {
                    throw new IOException("Expected='null' actual='" + nullString + "'");
                }
                retval = COSNull.NULL;
                break;
            }
            case 't': {
                byte[] trueBytes = new byte[4];
                int amountRead = this.pdfSource.read(trueBytes, 0, 4);
                String trueString = new String(trueBytes, 0, amountRead);
                if (trueString.equals("true")) {
                    retval = COSBoolean.TRUE;
                    break;
                }
                throw new IOException("expected true actual='" + trueString + "' " + this.pdfSource);
            }
            case 'f': {
                byte[] falseBytes = new byte[5];
                int amountRead = this.pdfSource.read(falseBytes, 0, 5);
                String falseString = new String(falseBytes, 0, amountRead);
                if (falseString.equals("false")) {
                    retval = COSBoolean.FALSE;
                    break;
                }
                throw new IOException("expected false actual='" + falseString + "' " + this.pdfSource);
            }
            case 'R': {
                this.pdfSource.read();
                retval = new COSObject(null);
                break;
            }
            default: {
                if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') {
                    StringBuffer buf = new StringBuffer();
                    while (Character.isDigit(c = (char)this.pdfSource.peek()) || c == '-' || c == '+' || c == '.') {
                        buf.append(c);
                        this.pdfSource.read();
                    }
                    retval = COSNumber.get(buf.toString());
                    break;
                }
                String badString = this.readString();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseDirObject() done retval=" + retval));
        }
        return retval;
    }

    private void readSingleSpace() throws IOException {
        int nextByte = this.pdfSource.read();
        if (nextByte != 32) {
            throw new IOException("expected=(0x20) actual=0x" + Integer.toHexString(nextByte));
        }
    }

    protected String readString() throws IOException {
        this.skipSpaces();
        StringBuffer buffer = new StringBuffer(4);
        while (!(this.isEndOfName((char)this.pdfSource.peek()) || this.isClosing() || this.pdfSource.isEOF())) {
            buffer.append((char)this.pdfSource.read());
        }
        return buffer.toString();
    }

    protected String readExpectedString(String theString) throws IOException {
        while (this.isWhitespace() && !this.pdfSource.isEOF()) {
            this.pdfSource.read();
        }
        StringBuffer buffer = new StringBuffer(theString.length());
        for (int charsRead = 0; !this.isEOL() && !this.pdfSource.isEOF() && charsRead < theString.length(); ++charsRead) {
            char next = (char)this.pdfSource.read();
            buffer.append(next);
            if (theString.charAt(charsRead) == next) {
                continue;
            }
            throw new IOException("Error: Expected to read '" + theString + "' instead started reading '" + buffer.toString() + "'");
        }
        while (this.isEOL() && !this.pdfSource.isEOF()) {
            this.pdfSource.read();
        }
        return buffer.toString();
    }

    protected String readString(int length) throws IOException {
        this.skipSpaces();
        StringBuffer buffer = new StringBuffer(length);
        while (!(this.isWhitespace() || this.isClosing() || this.pdfSource.isEOF() || buffer.length() >= length || this.pdfSource.peek() == 91 || this.pdfSource.peek() == 60 || this.pdfSource.peek() == 40 || this.pdfSource.peek() == 47)) {
            buffer.append((char)this.pdfSource.read());
        }
        return buffer.toString();
    }

    protected boolean isClosing() throws IOException {
        char next = (char)this.pdfSource.peek();
        return next == ']';
    }

    protected String readLine() throws IOException {
        while (this.isWhitespace() && !this.pdfSource.isEOF()) {
            this.pdfSource.read();
        }
        StringBuffer buffer = new StringBuffer(11);
        while (!this.isEOL() && !this.pdfSource.isEOF()) {
            char next = (char)this.pdfSource.read();
            buffer.append(next);
        }
        while (this.isEOL() && !this.pdfSource.isEOF()) {
            this.pdfSource.read();
        }
        return buffer.toString();
    }

    protected boolean isEOL() throws IOException {
        int nextByte = this.pdfSource.peek();
        return nextByte == 10 || nextByte == 13;
    }

    protected boolean isWhitespace() throws IOException {
        return this.isWhitespace(this.pdfSource.peek());
    }

    protected boolean isWhitespace(int c) throws IOException {
        return c == 0 || c == 9 || c == 12 || c == 10 || c == 13 || c == 32;
    }

    /*
     * WARNING - void declaration
     */
    protected void skipSpaces() throws IOException {
        int c;
        while ((c = this.pdfSource.peek()) == 0 || c == 9 || c == 10 || c == 12 || c == 13 || c == 32 || c == 37) {
            void var1_1;
            if (var1_1 == 37) {
                while (!this.isEOL() && !this.pdfSource.isEOF()) {
                    this.pdfSource.read();
                }
                continue;
            }
            int n = this.pdfSource.read();
        }
    }

    private boolean cmpArray(byte[] first, byte[] second) {
        return this.cmpArray(first, 0, second);
    }

    protected boolean isxdigit(char c) {
        return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F' || c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f';
    }

    private boolean cmpArray(byte[] first, int firstOffset, byte[] second) {
        boolean show = false;
        boolean retval = true;
        if (first.length - firstOffset >= second.length) {
            int arrayLength = second.length;
            int i = 0;
            while (i < arrayLength && retval) {
                retval = retval && first[firstOffset + i] == second[i];
                ++i;
            }
        } else {
            retval = false;
        }
        return retval;
    }

    protected int readInt() throws IOException {
        int retval = 0;
        int lastByte = 0;
        StringBuffer intBuffer = new StringBuffer();
        while ((lastByte = this.pdfSource.read()) != 32 && lastByte != 10 && lastByte != 13 && lastByte != 0 && lastByte != -1) {
            intBuffer.append((char)lastByte);
        }
        try {
            retval = Integer.parseInt(intBuffer.toString());
        }
        catch (NumberFormatException e) {
            throw new IOException("Error: Expected an integer type, actual='" + intBuffer + "'");
        }
        return retval;
    }

    public void addXref(PDFXref xref) {
        this.xrefs.add(xref);
    }

    public COSObject getObjectFromPool(COSObjectKey key) throws IOException {
        COSObject obj = (COSObject)this.objectPool.get(key);
        if (obj == null) {
            obj = new COSObject(null);
            this.objectPool.put(key, obj);
        }
        return obj;
    }

    public List getXrefs() {
        return this.xrefs;
    }

    private void setXrefs(List newXrefs) {
        this.xrefs = newXrefs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

