/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.encoding;

import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.encoding.Encoding;
import org.pdfbox.encoding.EncodingManager;
import org.pdfbox.encoding.WinAnsiEncoding;

public class DictionaryEncoding
extends Encoding {
    private COSDictionary encoding = null;

    public DictionaryEncoding(COSDictionary fontEncoding) throws IOException {
        this.encoding = fontEncoding;
        Encoding baseEncoding = new WinAnsiEncoding();
        COSName baseEncodingName = (COSName)this.encoding.getDictionaryObject(COSName.BASE_ENCODING);
        if (baseEncodingName != null) {
            EncodingManager manager = new EncodingManager();
            baseEncoding = manager.getEncoding(baseEncodingName);
        }
        this.nameToCode.putAll(baseEncoding.nameToCode);
        this.codeToName.putAll(baseEncoding.codeToName);
        COSArray differences = (COSArray)this.encoding.getDictionaryObject(COSName.DIFFERENCES);
        int currentIndex = -1;
        int i = 0;
        while (differences != null && i < differences.size()) {
            COSBase next = differences.get(i);
            if (next instanceof COSNumber) {
                currentIndex = ((COSNumber)next).intValue();
            } else if (next instanceof COSName) {
                COSName name = (COSName)next;
                this.addCharacterEncoding(currentIndex++, name);
            }
            ++i;
        }
    }
}

